/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.tools.ComparedGedcom;
import ancestris.modules.gedcomcompare.tools.ComparisonFrame;
import ancestris.modules.gedcomcompare.tools.DataFrame;
import ancestris.modules.gedcomcompare.tools.DesktopScrollPane;
import ancestris.modules.gedcomcompare.tools.GraphicDesktopPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GedcomComparePanel
extends JPanel {
    private final int H_GAP = 10;
    private final int V_GAP = 10;
    private final int HORIZONTAL_SIZE = 970;
    private final int VERTICAL_SIZE = 600;
    private GraphicDesktopPane gDesktopPane;
    private JLabel instructionsLabel;
    private JDesktopPane jDesktopPane;
    private JScrollPane jScrollPane;

    public GedcomComparePanel() {
        this.initComponents();
        this.gDesktopPane.setLayout(null);
        this.jScrollPane.getVerticalScrollBar().setUnitIncrement(12);
        this.instructionsLabel = new JLabel("");
        this.gDesktopPane.add(this.instructionsLabel);
    }

    private void initComponents() {
        this.gDesktopPane = new GraphicDesktopPane();
        this.jScrollPane = new DesktopScrollPane(this.gDesktopPane);
        this.jDesktopPane = this.gDesktopPane;
        this.jDesktopPane.setAutoscrolls(true);
        GroupLayout jDesktopPaneLayout = new GroupLayout(this.jDesktopPane);
        this.jDesktopPane.setLayout(jDesktopPaneLayout);
        jDesktopPaneLayout.setHorizontalGroup(jDesktopPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 645, Short.MAX_VALUE));
        jDesktopPaneLayout.setVerticalGroup(jDesktopPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 472, Short.MAX_VALUE));
        this.jScrollPane.setViewportView(this.jDesktopPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane));
    }

    public void placeFrames(List<? extends DataFrame> gframes, List<ComparisonFrame> cframes, boolean create) {
        int frameHeight;
        int frameWidth;
        double newHeight;
        DataFrame mainFrame = null;
        ArrayList<DataFrame> otherFrames = new ArrayList<DataFrame>();
        ArrayList<DataFrame> tmpRemoteFrames = new ArrayList<DataFrame>();
        Insets insets = this.gDesktopPane.getInsets();
        for (DataFrame dataFrame : gframes) {
            dataFrame.setIconifiable(false);
            if (dataFrame.isMain() && mainFrame == null) {
                mainFrame = dataFrame;
                continue;
            }
            if (dataFrame.isRemote()) {
                if (!dataFrame.isVisible()) continue;
                tmpRemoteFrames.add(dataFrame);
                continue;
            }
            otherFrames.add(dataFrame);
        }
        for (DataFrame dataFrame : tmpRemoteFrames) {
            otherFrames.add(dataFrame);
        }
        double myWidth = this.getSize().width;
        double myHeight = this.getSize().height;
        if (myWidth < 50.0) {
            myWidth = 970.0;
        }
        if (myHeight < 50.0) {
            myHeight = 600.0;
        }
        String instructions = null;
        instructions = mainFrame == null ? (tmpRemoteFrames.isEmpty() ? NbBundle.getMessage(this.getClass(), (String)"HELP_Instructions1") : NbBundle.getMessage(this.getClass(), (String)"HELP_Instructions2")) : (otherFrames.isEmpty() ? NbBundle.getMessage(this.getClass(), (String)"HELP_Instructions3") : null);
        if (instructions != null) {
            instructions = "<html><div style='margin-left: 5px; text-align:left; margin-right: 5px; font-size: 12px;'>" + instructions + "</div></html>";
            this.instructionsLabel.setText(instructions);
        } else {
            this.instructionsLabel.setText("");
        }
        int sx = this.instructionsLabel.getPreferredSize().width;
        int sy = this.instructionsLabel.getPreferredSize().height;
        int lx = (int)(myWidth - (double)sx) / 2;
        int ly = (int)(myHeight - (double)sy) / 2;
        this.instructionsLabel.setBounds(lx, ly, sx, sy);
        if (mainFrame != null) {
            if (create && mainFrame.getParent() == null) {
                this.gDesktopPane.add(mainFrame);
                mainFrame.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        GedcomComparePanel.this.gDesktopPane.repaint();
                    }
                });
            }
            Dimension size = mainFrame.getPreferredSize();
            mainFrame.setBounds(insets.left + 10, insets.top + 10, size.width, size.height);
            this.gDesktopPane.revalidate();
            this.gDesktopPane.repaint();
        }
        if (!otherFrames.isEmpty() && (newHeight = this.setFrames(otherFrames, frameWidth = ((DataFrame)otherFrames.get((int)0)).getPreferredSize().width, frameHeight = ((DataFrame)otherFrames.get((int)0)).getPreferredSize().height, myWidth, myHeight, create)) > myHeight) {
            this.setFrames(otherFrames, frameWidth, frameHeight, myWidth, newHeight, false);
        }
        if (cframes == null) {
            return;
        }
        for (ComparisonFrame f : cframes) {
            if (!f.includesMain()) {
                f.setVisible(false);
                this.removeLink(f);
                continue;
            }
            ArrayList<Component> comps = new ArrayList<Component>();
            for (Component c : this.gDesktopPane.getComponents()) {
                if (!(c instanceof ComparedGedcom) || !f.matchID(((ComparedGedcom)((Object)c)).getID()) || !c.isVisible()) continue;
                comps.add(c);
            }
            if (comps.size() != 2) continue;
            f.setVisible(true);
            Rectangle r1 = ((Component)comps.get(0)).getBounds();
            Rectangle r2 = ((Component)comps.get(1)).getBounds();
            Dimension dim = f.getPreferredSize();
            double dx = (r1.x + r2.x) / 2 + (r1.width + r2.width) / 4 - dim.width / 2;
            double dy = (r1.y + r2.y) / 2 + (r1.height + r2.height) / 4 - dim.height / 2;
            this.setFrame(f, dx, dy, false);
            this.removeLink(f);
            ComparedGedcom f0 = (ComparedGedcom)comps.get(0);
            if (f0.isMain()) {
                this.linkFrames(comps.get(0), f);
                this.linkFrames(f, comps.get(1));
                continue;
            }
            this.linkFrames(comps.get(1), f);
            this.linkFrames(f, comps.get(0));
        }
        for (DataFrame frame : otherFrames) {
            frame.moveToFront();
            frame.focusOther();
        }
    }

    private double setFrames(List<DataFrame> otherFrames, int frameWidth, int frameHeight, double myWidth, double myHeight, boolean create) {
        double a = frameWidth + 10;
        double b = frameHeight + 10;
        double H = myWidth - a - 20.0;
        double V = myHeight - b;
        double x = H;
        double y = 10.0;
        String direction = "V";
        for (DataFrame frame : otherFrames) {
            this.setFrame(frame, x, y, create);
            if (direction.equals("V")) {
                double y2 = y + b;
                if (y2 > V) {
                    y = y2;
                    x = 10.0;
                    continue;
                }
                double x2 = H / V * Math.sqrt(V * V - y2 * y2);
                if (x - x2 > a) {
                    direction = "H";
                } else {
                    x = x2;
                    y = y2;
                    continue;
                }
            }
            if (!direction.equals("H")) continue;
            if ((x -= a) < 10.0) {
                x = 10.0;
                y += b;
                direction = "V";
                continue;
            }
            y = V / H * Math.sqrt(H * H - x * x);
        }
        return y;
    }

    private void setFrame(DataFrame frame, double dx, double dy, boolean create) {
        Dimension size = frame.getPreferredSize();
        frame.setBounds((int)dx, (int)dy, size.width, size.height);
        if (create && frame.getParent() == null) {
            this.gDesktopPane.add(frame);
            frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    GedcomComparePanel.this.gDesktopPane.repaint();
                }
            });
        }
        this.gDesktopPane.revalidate();
        this.gDesktopPane.repaint();
    }

    public void addFrame(JInternalFrame frame) {
        this.gDesktopPane.add(frame);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                GedcomComparePanel.this.gDesktopPane.repaint();
            }
        });
        frame.setVisible(true);
        frame.moveToFront();
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.gDesktopPane.setSelectedFrame(frame);
        this.gDesktopPane.revalidate();
        this.gDesktopPane.repaint();
    }

    public void removeFrame(Object o) {
        this.gDesktopPane.remove((JInternalFrame)o);
        this.gDesktopPane.revalidate();
        this.gDesktopPane.repaint();
    }

    public void linkFrames(Object o1, Object o2) {
        this.gDesktopPane.addLink((JInternalFrame)o1, (JInternalFrame)o2);
    }

    public void removeLink(Object o) {
        this.gDesktopPane.removeLink((JInternalFrame)o);
        this.gDesktopPane.revalidate();
        this.gDesktopPane.repaint();
    }

    public void showFrame(JInternalFrame frame, boolean show) {
        frame.setVisible(show);
        this.gDesktopPane.revalidate();
        this.gDesktopPane.repaint();
    }
}

