/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd.geom;

import java.io.Serializable;

public class Point2
implements Serializable {
    private static final long serialVersionUID = 965985679540486895L;
    public double x;
    public double y;
    public static final Point2 NULL_POINT2 = new Point2(0.0, 0.0);

    public Point2() {
    }

    public Point2(double x, double y) {
        this.set(x, y);
    }

    public Point2(Point2 other) {
        this.copy(other);
    }

    public void make(double x, double y) {
        this.set(x, y);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public Point2 interpolate(Point2 other, double factor) {
        Point2 p = new Point2(this.x + (other.x - this.x) * factor, this.y + (other.y - this.y) * factor);
        return p;
    }

    public double distance(Point2 other) {
        double xx = other.x - this.x;
        double yy = other.y - this.y;
        return Math.abs(Math.sqrt(xx * xx + yy * yy));
    }

    public void copy(Point2 other) {
        this.x = other.x;
        this.y = other.y;
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void moveTo(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void move(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public void move(Point2 p) {
        this.x += p.x;
        this.y += p.y;
    }

    public void moveX(double dx) {
        this.x += dx;
    }

    public void moveY(double dy) {
        this.y += dy;
    }

    public void scale(double sx, double sy) {
        this.x *= sx;
        this.y *= sy;
    }

    public void scale(Point2 s) {
        this.x *= s.x;
        this.y *= s.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void swap(Point2 other) {
        if (other != this) {
            double t = this.x;
            this.x = other.x;
            other.x = t;
            t = this.y;
            this.y = other.y;
            other.y = t;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Point2[");
        buf.append(this.x);
        buf.append('|');
        buf.append(this.y);
        buf.append("]");
        return buf.toString();
    }
}

