/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.calendar;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.UUID;

public class ReportCalendar
extends Report {
    private static final TagPath PATH_INDIDEATPLAC = new TagPath("INDI:DEAT:PLAC");
    public boolean output_births = true;
    public boolean output_deaths = true;
    public int assume_dead = 100;
    public boolean dead_birthdays = false;
    public int anniversary = 0;
    public String[] anniversarys = new String[]{this.translate("both_alive"), this.translate("one_alive"), this.translate("all"), this.translate("none")};
    public int year_mode = 0;
    public String[] year_modes = new String[]{this.translate("upcoming"), this.translate("generic")};
    public int hour_mode = 0;
    public String[] hour_modes = new String[]{"HH:mm", "hh:mm a", "hh-mm a", "HH-mm", "HH.mm", "hh;mm a", "HH:mm:ss", "hh:mm:ss a", "hh-mm-ss a", "HH-mm-ss", "HH.mm.ss", "hh;mm;ss a"};
    public int date_long_mode = 0;
    public String[] date_long_modes = new String[]{"dd MMMM yyyy", "dd/MM/yyyy", "MM/dd/yyyy", "MMMM dd yyyy"};
    public int max_names = 0;
    public String[] max_namess = new String[]{this.translate("nolimit"), "1", "2", "3"};
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter HOUR_FORMAT = DateTimeFormatter.ofPattern("HHmmss");
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");

    public void start(Gedcom gedcom) {
        File file = this.getFileFromUser("Choose calendar file", AbstractAncestrisAction.TXT_OK, true, "ics");
        if (file == null) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            this.outputHeader(writer);
            Collection individuals = gedcom.getEntities("INDI");
            Collection families = gedcom.getEntities("FAM");
            for (Indi indi : individuals) {
                if (this.output_births) {
                    this.outputBirthday(writer, indi);
                }
                if (!this.output_deaths) continue;
                this.outputDeathAnniv(writer, indi);
            }
            for (Fam fam : families) {
                if (this.anniversary == 3) continue;
                this.outputWeddingAnniv(writer, fam);
            }
            this.outputFooter(writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.log(this.translate("report_done") + " " + file.getAbsolutePath());
    }

    private void outputHeader(Writer writer) throws IOException {
        writer.write("BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:Ancestris-ReportCalendar\r\n");
    }

    private void outputFooter(Writer writer) throws IOException {
        writer.write("END:VCALENDAR\r\n");
    }

    private void outputBirthday(Writer writer, Indi indi) throws IOException {
        String birAnniv = this.translate("birthday");
        Event event = this.getDate(indi.getBirthDate());
        if (event == null) {
            return;
        }
        event.time = this.getTime(indi.getBirthDate());
        event.categorie = birAnniv;
        PropertyPlace pp = indi.getBirthPlace();
        if (pp != null) {
            event.place = pp.getCity();
        }
        if (!this.dead_birthdays && !this.isAlive(indi, event.date)) {
            return;
        }
        event.summary = birAnniv + " : " + this.getIndiNameId(indi);
        event.description = this.getIndiNameId(indi) + "\\n\r\n " + birAnniv + " : " + event.count + " " + this.translate("years") + "\\n\r\n " + this.translate("birth") + " : " + event.origine.format(DateTimeFormatter.ofPattern(this.date_long_modes[this.date_long_mode])) + this.getPlace(event);
        this.outputEvent(writer, event);
    }

    private void outputDeathAnniv(Writer writer, Indi indi) throws IOException {
        String deaAnniv = this.translate("death_anniversary");
        Event event = this.getDate(indi.getDeathDate());
        if (event == null) {
            return;
        }
        event.time = this.getTime(indi.getDeathDate());
        event.categorie = deaAnniv;
        PropertyPlace pp = indi.getDeathPlace();
        if (pp != null) {
            event.place = pp.getCity();
        }
        event.summary = deaAnniv + " : " + this.getIndiNameId(indi);
        event.description = this.getIndiNameId(indi) + "\\n\r\n " + deaAnniv + " : " + event.count + " " + this.translate("years") + "\\n\r\n " + this.translate("death") + " : " + event.origine.format(DateTimeFormatter.ofPattern(this.date_long_modes[this.date_long_mode])) + this.getPlace(event);
        this.outputEvent(writer, event);
    }

    private void outputWeddingAnniv(Writer writer, Fam fam) throws IOException {
        String wedAnniv = this.translate("wedding_anniversary");
        Event event = this.getDate(fam.getMarriageDate());
        if (event == null) {
            return;
        }
        event.time = this.getTime(fam.getMarriageDate());
        event.categorie = wedAnniv;
        Indi wife = fam.getWife();
        Indi husband = fam.getHusband();
        boolean wifeDead = false;
        boolean husbandDead = false;
        if (wife != null) {
            boolean bl = wifeDead = !this.isAlive(wife, event.date);
        }
        if (husband != null) {
            boolean bl = husbandDead = !this.isAlive(husband, event.date);
        }
        if (this.anniversary == 0 && (wifeDead || husbandDead)) {
            return;
        }
        if (this.anniversary == 1 && wifeDead && husbandDead) {
            return;
        }
        PropertyPlace pp = fam.getMarriagePlace();
        if (pp != null) {
            event.place = pp.getCity();
        }
        event.summary = wedAnniv + " : " + this.getFamName(fam);
        event.description = this.getFamName(fam) + "\\n\r\n " + wedAnniv + " : " + event.count + " " + this.translate("years") + "\\n\r\n " + this.translate("wedding") + " : " + event.origine.format(DateTimeFormatter.ofPattern(this.date_long_modes[this.date_long_mode])) + this.getPlace(event);
        this.outputEvent(writer, event);
    }

    private void outputEvent(Writer writer, Event event) throws IOException {
        if (this.year_mode == 0) {
            event.summary = event.count + " " + event.summary;
        }
        event.summary = event.summary.replace(",", "\\,");
        writer.write("BEGIN:VEVENT\r\n");
        try {
            MessageDigest salt = MessageDigest.getInstance("SHA-256");
            salt.update(UUID.randomUUID().toString().getBytes("UTF-8"));
            String digest = this.encodeHexString(salt.digest());
            writer.write("UID:" + digest + "\r\n");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        writer.write("DTSTAMP:" + LocalDateTime.now().format(DATETIME_FORMATTER) + "\r\n");
        writer.write("CATEGORIES:" + event.categorie + "\r\n");
        if (!"".equals(event.time)) {
            writer.write("DTSTART:" + DATE_FORMAT.format(event.date) + event.time + "\r\n");
            writer.write("DURATION:PT15M\r\n");
        } else {
            writer.write("DTSTART:" + DATE_FORMAT.format(event.date) + "\r\n");
        }
        writer.write("SUMMARY:" + event.summary + "\r\n");
        writer.write("DESCRIPTION:" + event.description + "\r\n");
        if (!"".equals(event.place)) {
            writer.write("LOCATION:" + event.place + "\r\n");
        }
        if (this.year_mode == 1) {
            writer.write("RRULE:FREQ=YEARLY\r\n");
        }
        writer.write("END:VEVENT\r\n");
    }

    private String encodeHexString(byte[] byteArray) {
        StringBuilder hexStringBuilder = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            hexStringBuilder.append(this.byteToHex(byteArray[i]));
        }
        return hexStringBuilder.toString();
    }

    private String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    private Event getDate(PropertyDate date) {
        if (date == null) {
            return null;
        }
        if (date.getFormat() != PropertyDate.DATE) {
            return null;
        }
        if (!date.getStart().isComplete()) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        PointInTime pit = date.getStart();
        cal.set(now.get(1), pit.getMonth(), pit.getDay() + 1);
        if (cal.before(now)) {
            cal.roll(1, true);
        }
        int count = cal.get(1) - date.getStart().getYear();
        LocalDate local = cal.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate origine = LocalDate.of(date.getStart().getYear(), date.getStart().getMonth() + 1, date.getStart().getDay() + 1);
        return new Event(local, origine, count);
    }

    private String getTime(PropertyDate pdate) {
        Property[] ptime = pdate.getParent().getProperties("_TIME");
        if (ptime.length == 0) {
            return "";
        }
        String time = "";
        try {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(this.hour_modes[this.hour_mode]);
            LocalTime ldt = LocalTime.parse(ptime[0].getValue(), dtf);
            time = ldt.format(HOUR_FORMAT);
        }
        catch (DateTimeParseException e) {
            return "";
        }
        if ("".equals(time)) {
            return "";
        }
        return "T" + time;
    }

    private String getPlace(Event event) {
        if ("".equals(event.place)) {
            return "";
        }
        return " ( " + event.place + " )";
    }

    private String getIndiNameId(Indi indi) {
        return (this.getIndiName(indi) + " (" + indi.getId() + ")").trim();
    }

    private String getIndiName(Indi indi) {
        return (this.getFirstNames(indi) + " " + indi.getLastName()).trim();
    }

    private String getFamName(Fam fam) {
        Indi wife = fam.getWife();
        Indi husband = fam.getHusband();
        String id = "(" + fam.getId() + ")";
        if (wife == null && husband == null) {
            return id;
        }
        if (wife == null) {
            return this.getIndiName(husband) + " + " + this.translate("wife") + " " + id;
        }
        if (husband == null) {
            return this.getIndiName(wife) + " + " + this.translate("husband") + " " + id;
        }
        return this.getFirstNames(wife) + " + " + this.getIndiName(husband) + " " + id;
    }

    private String getFirstNames(Indi indi) {
        String firstName = indi.getFirstName();
        if (this.max_names <= 0) {
            return firstName;
        }
        if (firstName.trim().equals("")) {
            return "";
        }
        String[] names = firstName.split("  *");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.max_names && i < names.length; ++i) {
            sb.append(names[i]).append(" ");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private boolean isAlive(Indi indi, LocalDate date) {
        if (indi.getDeathDate() != null || indi.getProperty(PATH_INDIDEATPLAC) != null) {
            return false;
        }
        if (this.assume_dead == 0) {
            return true;
        }
        PropertyDate birth = indi.getBirthDate();
        if (birth == null) {
            return true;
        }
        int d = date.getDayOfMonth();
        Delta delta = birth.getAnniversary(new PointInTime(d - 1, date.getMonthValue(), date.getYear()));
        if (delta == null) {
            return true;
        }
        return delta.getYears() < this.assume_dead;
    }

    private static class Event {
        public LocalDate date;
        public LocalDate origine;
        public int count;
        public String categorie;
        public String summary;
        public String place = "";
        public String time = "";
        public String description = "";

        public Event(LocalDate date, LocalDate origine, int count) {
            this.date = date;
            this.origine = origine;
            this.count = count;
        }
    }
}

