/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.directorytool;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.util.ArrayList;

public class ReportDirectoryTool
extends Report {
    public int optionLifeSpan = 70;
    private final String textTitle = this.translate("title");
    private final String textDate = this.translate("date");
    private final String textAge = this.translate("age");
    private final String textSelect = this.translate("select");
    private final String total = this.translate("total");

    public void start(Gedcom gedcom) {
        int yearToCheck;
        String strTemp = this.getValueFromUser("", this.textSelect);
        if (strTemp == null) {
            return;
        }
        try {
            yearToCheck = Integer.parseInt(strTemp);
        }
        catch (NumberFormatException e) {
            this.println("Invalid year");
            return;
        }
        this.println(this.textTitle + " " + yearToCheck);
        this.println();
        ArrayList<String> indiToPrint = new ArrayList<String>();
        Entity[] individuals = gedcom.getEntities("INDI", "");
        for (int loop = 0; loop < individuals.length; ++loop) {
            String strOccu;
            int tempDOBYear = this.getYear(((Indi)individuals[loop]).getBirthDate());
            int tempDODYear = this.getYear(((Indi)individuals[loop]).getDeathDate());
            if (tempDOBYear == -1 && tempDODYear == -1) continue;
            if (tempDOBYear == -1) {
                tempDOBYear = tempDODYear - this.optionLifeSpan;
            }
            if (tempDODYear == -1) {
                tempDODYear = tempDOBYear + this.optionLifeSpan;
            }
            if (yearToCheck < tempDOBYear || yearToCheck > tempDODYear) continue;
            int iAge = yearToCheck - tempDOBYear;
            Boolean flagHasOccu = false;
            if (individuals[loop].getProperty(new TagPath("INDI:OCCU")) == null) {
                strOccu = "";
            } else {
                strOccu = individuals[loop].getProperty(new TagPath("INDI:OCCU")).getDisplayValue();
                flagHasOccu = true;
            }
            if (flagHasOccu.booleanValue() && individuals[loop].getProperty(new TagPath("INDI:OCCU:DATE")) != null) {
                strOccu = strOccu + " " + individuals[loop].getProperty(new TagPath("INDI:OCCU:DATE")).getDisplayValue();
            }
            if (flagHasOccu.booleanValue() && individuals[loop].getProperty(new TagPath("INDI:OCCU:PLAC")) != null) {
                strOccu = strOccu + " " + individuals[loop].getProperty(new TagPath("INDI:OCCU:PLAC")).getDisplayValue();
            }
            if (strOccu.length() > 0) {
                strOccu = "[" + strOccu + "]";
            }
            indiToPrint.add(individuals[loop] + " - " + this.textAge + " " + iAge + " " + strOccu);
        }
        indiToPrint.stream().sorted().forEach(arg_0 -> ((ReportDirectoryTool)this).println(arg_0));
        this.println();
        this.println(this.total + " " + indiToPrint.size());
    }

    public int getYear(PropertyDate someDate) {
        if (someDate == null || !someDate.isValid() || someDate.isRange()) {
            return -1;
        }
        int year = -1;
        try {
            year = someDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
        return year;
    }
}

