/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.events;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySex;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import genj.util.WordBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class ReportEvents
extends Report {
    public boolean isSortDay = true;
    public boolean reportBirth = true;
    public boolean reportBaptism = true;
    public boolean reportMarriage = true;
    public boolean reportDivorce = true;
    public boolean reportEmigration = true;
    public boolean reportImmigration = true;
    public boolean reportNaturalization = true;
    public boolean reportDeath = true;
    public boolean reportBurial = true;
    public boolean isOutputICal = false;
    public boolean isNoDead = false;
    public String place = "";
    public int sex = 3;
    public String[] sexs = new String[]{PropertySex.TXT_MALE, PropertySex.TXT_FEMALE, PropertySex.TXT_UNKNOWN, ""};
    public String day = "";
    public String month = "";
    public String year = "";
    private String timestamp;
    private static final SimpleDateFormat formatDTSTAMP = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static final SimpleDateFormat formatDTSTART = new SimpleDateFormat("yyyyMMdd");

    public void start(Gedcom gedcom) throws GedcomException {
        if (!(this.reportBirth || this.reportBaptism || this.reportDeath || this.reportBurial || this.reportMarriage || this.reportDivorce || this.reportEmigration || this.reportImmigration || this.reportNaturalization)) {
            return;
        }
        this.timestamp = this.toISO(System.currentTimeMillis(), true);
        formatDTSTART.setTimeZone(TimeZone.getTimeZone("GMT"));
        formatDTSTAMP.setTimeZone(TimeZone.getDefault());
        HashMap<String, List<Hit>> tag2events = new HashMap<String, List<Hit>>();
        if (this.reportBirth) {
            tag2events.put("BIRT", new ArrayList());
        }
        if (this.reportBaptism) {
            tag2events.put("BAPM|BAPL|CHR|CHRA", new ArrayList());
        }
        if (this.reportMarriage) {
            tag2events.put("MARR", new ArrayList());
        }
        if (this.reportDivorce) {
            tag2events.put("DIV", new ArrayList());
        }
        if (this.reportEmigration) {
            tag2events.put("EMI", new ArrayList());
        }
        if (this.reportImmigration) {
            tag2events.put("IMMI", new ArrayList());
        }
        if (this.reportNaturalization) {
            tag2events.put("NATU", new ArrayList());
        }
        if (this.reportDeath) {
            tag2events.put("DEAT", new ArrayList());
        }
        if (this.reportBurial) {
            tag2events.put("BURI", new ArrayList());
        }
        for (Entity indi : gedcom.getEntities("INDI")) {
            this.analyze((Indi)indi, tag2events);
        }
        if (this.isOutputICal) {
            this.println("BEGIN:VCALENDAR");
            this.println("PRODID:-//Genealogy//ReportEvents/EN");
            this.println("VERSION:2.0");
            this.println("METHOD:PUBLISH");
        } else {
            if (this.isNoDead) {
                this.println(this.translate("isNoDead"));
            }
            if (this.place.length() > 0) {
                this.println(this.translate("place") + " = " + this.place);
            }
            if (this.sex != 3) {
                this.println(this.translate("sex") + " = " + this.sexs[this.sex]);
            }
            if (this.day.length() > 0) {
                this.println(this.translate("day") + " = " + this.day);
            }
            if (this.month.length() > 0) {
                this.println(this.translate("month") + " = " + this.month);
            }
            if (this.year.length() > 0) {
                this.println(this.translate("year") + " = " + this.year);
            }
            this.println();
        }
        for (String tag : tag2events.keySet()) {
            List events = (List)tag2events.get(tag);
            if (events.isEmpty()) continue;
            Collections.sort(events);
            if (!this.isOutputICal) {
                this.println(this.getIndent(2) + Gedcom.getName((String)new StringTokenizer(tag, "|").nextToken()));
            }
            for (Hit event : events) {
                this.println(event);
            }
            if (!this.isOutputICal) {
                this.println();
            }
            events.clear();
        }
        if (this.isOutputICal) {
            this.println("END:VCALENDAR");
        }
    }

    private void analyze(Indi indi, Map<String, List<Hit>> tag2events) {
        if (this.isNoDead && indi.getDeathDate() != null && indi.getDeathDate().isValid()) {
            return;
        }
        if (!this.checkSex(indi)) {
            return;
        }
        this.analyzeEvents((Entity)indi, tag2events);
        Fam[] fams = indi.getFamiliesWhereSpouse();
        for (int f = 0; f < fams.length; ++f) {
            Fam fam = fams[f];
            this.analyzeEvents((Entity)fam, tag2events);
        }
    }

    private void analyzeEvents(Entity entity, Map<String, List<Hit>> tag2events) {
        for (String tag : tag2events.keySet()) {
            List<Hit> events = tag2events.get(tag);
            Property[] props = this.getProperties(entity, tag);
            for (int i = 0; i < props.length; ++i) {
                Hit hit;
                Property date;
                Property event = props[i];
                if (!(event instanceof PropertyEvent) || !((date = event.getProperty("DATE")) instanceof PropertyDate) || events.contains(hit = new Hit(entity, (PropertyEvent)event, i, (PropertyDate)date)) || !this.checkDate((PropertyDate)date) || !this.checkPlace(event)) continue;
                events.add(hit);
            }
        }
    }

    private Property[] getProperties(Entity entity, String tag) {
        ArrayList<Property> result = new ArrayList<Property>();
        int j = entity.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = entity.getProperty(i);
            if (!prop.getTag().matches(tag)) continue;
            result.add(prop);
        }
        return Property.toArray(result);
    }

    private boolean checkPlace(Property event) {
        if (this.place.length() == 0) {
            return true;
        }
        PropertyPlace pp = (PropertyPlace)event.getProperty("PLAC");
        if (pp == null) {
            return false;
        }
        return pp.getValue().matches("(?i).*" + this.place + ".*");
    }

    private boolean checkSex(Indi indi) {
        if (this.sex == 3) {
            return true;
        }
        switch (indi.getSex()) {
            case 1: {
                return this.sex == 0;
            }
            case 2: {
                return this.sex == 1;
            }
            case 0: {
                return this.sex == 2;
            }
        }
        return false;
    }

    private boolean checkDate(PropertyDate date) {
        if (date == null || !date.isValid()) {
            return false;
        }
        PointInTime start = date.getStart();
        if (start.getCalendar() != PointInTime.GREGORIAN) {
            return false;
        }
        return this.checkValue(start.getDay() + 1, this.day) && this.checkValue(start.getMonth() + 1, this.month) && this.checkValue(start.getYear(), this.year);
    }

    private boolean checkValue(int value, String filter) {
        if (filter.length() == 0) {
            return true;
        }
        try {
            if (filter.startsWith(">")) {
                return Integer.parseInt(filter.substring(1)) < value;
            }
            if (filter.charAt(0) == '<') {
                return Integer.parseInt(filter.substring(1)) > value;
            }
            if (filter.charAt(0) == '=') {
                return Integer.parseInt(filter.substring(1)) == value;
            }
            int range = filter.indexOf("-");
            if (range > 0) {
                return Integer.parseInt(filter.substring(0, range)) <= value && Integer.parseInt(filter.substring(range + 1)) >= value;
            }
            return Integer.parseInt(filter) == value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private String toISO(long timeMillis, boolean time) {
        Date date = new Date(timeMillis);
        return time ? formatDTSTAMP.format(date) : formatDTSTART.format(date);
    }

    private class Hit
    implements Comparable<Hit> {
        Entity who;
        int num;
        Property event;
        PropertyDate date;
        PointInTime compare;

        Hit(Entity entity, PropertyEvent event, int num, PropertyDate date) {
            this.who = entity;
            this.event = event;
            this.num = num;
            this.date = date;
            PointInTime when = date.getStart();
            this.compare = ReportEvents.this.isSortDay ? new PointInTime(when.getDay(), when.getMonth(), 4, when.getCalendar()) : when;
        }

        @Override
        public int compareTo(Hit other) {
            return this.compare.compareTo(other.compare);
        }

        public boolean equals(Object that) {
            return that instanceof Hit ? this.event == ((Hit)that).event : false;
        }

        public String toString() {
            try {
                if (ReportEvents.this.isOutputICal) {
                    WordBuffer result = new WordBuffer("\n");
                    result.append("BEGIN:VEVENT");
                    result.append("DTSTART:" + ReportEvents.this.toISO(this.date.getStart().getTimeMillis(), false));
                    result.append("UID:" + this.who.getGedcom().getName() + "|" + this.who.getId() + "|" + this.event.getTag() + "|" + this.num);
                    result.append("DTSTAMP:" + ReportEvents.this.timestamp);
                    result.append("SUMMARY:" + Gedcom.getName((String)this.event.getTag()) + " " + this.icalescape(this.who.toString()));
                    Property where = this.event.getProperty("PLAC");
                    if (where != null) {
                        result.append("LOCATION:" + this.icalescape(where.getDisplayValue()));
                    }
                    if (this.event.getTag().equals("BIRT")) {
                        result.append("RRULE:FREQ=YEARLY");
                    }
                    result.append("DESCRIPTION:");
                    result.append("END:VEVENT");
                    return result.toString();
                }
                StringBuilder result = new StringBuilder();
                result.append(ReportEvents.this.getIndent(3));
                result.append(this.date);
                result.append(" ");
                result.append(this.who);
                return result.toString();
            }
            catch (GedcomException t) {
                throw new RuntimeException();
            }
        }

        private String icalescape(String string) {
            return string.replaceAll(",", "\\\\,");
        }
    }
}

