/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedart;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.reports.gedart.DocReport;
import ancestris.reports.gedart.GedartTemplate;
import ancestris.reports.gedart.GedartTemplates;
import ancestris.reports.relatives.ReportRelatives;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.report.Report;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.openide.util.Exceptions;

public class ReportGedart
extends Report {
    private String todoTag = "NOTE";
    private String todoStart = "TODO:";
    private boolean outputSummary = false;
    private boolean isTodo = false;
    private boolean isOneFile = true;
    private DocReport mydoc;
    private Gedcom theGedcom;
    private GedartTemplates gedartTemplates = new GedartTemplates();
    private GedartTemplate[] gedartTemplatesOption = this.gedartTemplates.toArray();
    public int templateModel = 0;
    public String[] templateModels = GedartTemplate.getDescription(this.gedartTemplatesOption);
    public boolean includeIndi = true;
    public boolean includeFam = true;
    public boolean includeBlankCells = false;
    public boolean showID = true;
    public boolean includeTOC = false;
    public boolean includeIndex = false;
    public boolean saveReportToFile = true;

    public File start(Gedcom gedcom, GedartTemplate template) {
        Indi indi;
        this.theGedcom = gedcom;
        ArrayList<Indi> searchResult = this.getSearchEntities(gedcom);
        if (searchResult.isEmpty() && (indi = this.getActiveIndi(gedcom)) != null) {
            List<Indi> relatives = new ReportRelatives().getRelatives(indi);
            searchResult = new ArrayList<Indi>(relatives);
        }
        ArrayList<Entity> indis = new ArrayList<Entity>();
        ArrayList<Entity> fams = new ArrayList<Entity>();
        for (Entity entity : searchResult) {
            if (entity instanceof Indi) {
                indis.add(entity);
                continue;
            }
            if (!(entity instanceof Fam)) continue;
            fams.add(entity);
        }
        return this.process(indis.toArray(new Entity[indis.size()]), fams.toArray(new Entity[fams.size()]), template);
    }

    public File start(Indi indi, GedartTemplate template) {
        this.theGedcom = indi.getGedcom();
        return this.process((Entity[])new Indi[]{indi}, (Entity[])new Fam[0], template);
    }

    public File start(Indi[] indis, GedartTemplate template) {
        this.theGedcom = indis[0].getGedcom();
        return this.process((Entity[])indis, (Entity[])new Fam[0], template);
    }

    public File start(Fam fam, GedartTemplate template) {
        this.theGedcom = fam.getGedcom();
        return this.process((Entity[])new Indi[0], (Entity[])new Fam[]{fam}, template);
    }

    public File start(Fam[] fams, GedartTemplate template) {
        this.theGedcom = fams[0].getGedcom();
        return this.process((Entity[])new Indi[0], (Entity[])fams, template);
    }

    public String accepts(Object context) {
        return this.getName();
    }

    public File start(Object context) throws Throwable {
        if (context instanceof Gedcom) {
            return this.start((Gedcom)context, null);
        }
        if (context instanceof Indi) {
            return this.start((Indi)context, null);
        }
        if (context instanceof Fam) {
            return this.start((Fam)context, null);
        }
        if (context instanceof Indi[]) {
            return this.start((Indi[])context, null);
        }
        if (context instanceof Fam[]) {
            return this.start((Fam[])context, null);
        }
        return null;
    }

    private File process(Entity[] indis, Entity[] fams, GedartTemplate usetemplate) {
        File file;
        boolean isOneEntity;
        String extension = null;
        if (usetemplate == null && this.gedartTemplatesOption.length > this.templateModel) {
            usetemplate = this.gedartTemplatesOption[this.templateModel];
        }
        if (usetemplate == null) {
            return null;
        }
        String thetemplate = usetemplate.getPath();
        LOG.log(Level.INFO, "template:{0}", thetemplate);
        extension = usetemplate.getFormat();
        if (extension == null || extension.isEmpty()) {
            extension = "html";
        }
        boolean bl = isOneEntity = indis.length + fams.length <= 1;
        if (isOneEntity) {
            this.isTodo = false;
        }
        LOG.log(Level.INFO, "tofile=" + this.saveReportToFile);
        if (!this.saveReportToFile) {
            try {
                file = File.createTempFile("Ancestris-", null);
            }
            catch (IOException ioe) {
                file = null;
            }
        } else {
            file = this.getFileFromUser(this.translate("output.file"), AbstractAncestrisAction.TXT_OK, true, extension);
        }
        if (file == null) {
            LOG.log(Level.INFO, "file = null");
            return null;
        }
        LOG.log(Level.INFO, "file=" + file);
        try {
            this.mydoc = new DocReport(file, this.gedartTemplates, this.theGedcom.getEncoding());
            this.mydoc.put("options", this);
            this.mydoc.put("TEMPLATE", thetemplate);
        }
        catch (IOException ioe) {
            System.err.println("IO Exception!");
            ioe.printStackTrace();
            return null;
        }
        if (this.includeIndi) {
            this.mydoc.put("INDIS", indis);
        }
        if (this.includeFam) {
            this.mydoc.put("FAMS", fams);
        }
        this.mydoc.put("GEDCOM", this.theGedcom);
        this.mydoc.render(thetemplate + "/index.vm");
        this.mydoc.close();
        long size = file.length();
        if (size > 500000L && DialogManager.OK_OPTION != DialogManager.create((String)this.translate("TITL_SizeWarning"), (String)this.translate("MSG_SizeWarning", new Object[]{size})).setMessageType(2).setOptionType(2).setDialogId("report.ReportGraphicalTree").show()) {
            this.println("Completed but file not opened as probably too big.");
            return null;
        }
        if (thetemplate.contains("A03_TreePretty")) {
            try {
                String resource = "oaktreeC.jpg";
                String source = "/ancestris/reports/gedart/templates/A03_TreePretty/" + resource;
                URL inputUrl = GedartTemplates.class.getResource(source);
                FileUtils.copyURLToFile((URL)inputUrl, (File)new File(file.getParentFile(), resource));
            }
            catch (IOException ex) {
                this.println("Failed to copy image. Error:" + ex.getMessage());
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.println("Completed.");
        return file;
    }
}

