/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.missinginformation;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.TreeMap;
import java.util.logging.Level;

public class ReportMissingInformation
extends Report {
    public boolean checkBirthDate = true;
    public boolean checkBirthPlace = true;
    public boolean checkBirthSource = true;
    public boolean checkBaptismDate = true;
    public boolean checkBaptismPlace = true;
    public boolean checkBaptismSource = true;
    public boolean checkDeathDate = true;
    public boolean checkDeathPlace = true;
    public boolean checkDeathSource = true;
    public boolean checkSex = true;
    public boolean checkGiven = true;
    public boolean checkSurname = true;
    public boolean checkUseSosa = false;
    public boolean checkSortOnSosa = false;
    public int outputType = 0;
    public String[] outputTypes = new String[]{this.translate("outputScreen"), this.translate("outputCsv")};
    private final String textTitle = this.translate("title");
    private final String textSubject = this.translate("subject");
    private final String textBirth = this.translate("birth");
    private final String textBaptism = this.translate("baptism");
    private final String textDeath = this.translate("death");
    private final String textDate = this.translate("date");
    private final String textPlace = this.translate("place");
    private final String textSex = this.translate("sex");
    private final String textGiven = this.translate("given");
    private final String textSurname = this.translate("surname");
    private final String textId = this.translate("id");
    private final String textKey = this.translate("key");
    private final String textSource = this.translate("source");
    private final String textSeparator = ";";
    private final int colName = 60;
    private final int colData = 6;
    private final int numDataCols = 12;
    private static final int SCREEN = 0;
    private static final int CSV = 1;
    private final StringBuilder report = new StringBuilder();

    public void start(Indi indi) {
        this.report.setLength(0);
        this.displayHeader(indi.getName());
        this.checkIndi(indi);
        if (this.outputType == 1) {
            this.createFile();
        } else {
            this.println(this.report);
        }
    }

    public void checkIndi(Indi indi) {
        Boolean flagOk2;
        Boolean flagOk1;
        Property tempP;
        PropertyPlace tempPlace;
        PropertyDate tempDate;
        StringBuilder strDataRow = new StringBuilder();
        String strNameID = String.format("%-10s", indi.getId());
        strNameID = this.outputType == 1 ? strNameID + ";" + indi.getName() : strNameID + " " + indi.getName();
        strDataRow.append(ReportMissingInformation.align((String)strNameID, (int)60, (int)3));
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkBirthDate) {
            tempDate = indi.getBirthDate();
            this.addSymbol(strDataRow, tempDate != null && tempDate.isValid());
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkBirthPlace) {
            tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:BIRT:PLAC"));
            this.addSymbol(strDataRow, tempPlace != null);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkBirthSource) {
            tempP = indi.getProperty(new TagPath("INDI:BIRT:SOUR"));
            this.addSymbol(strDataRow, tempP != null);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkBaptismDate) {
            flagOk1 = true;
            flagOk2 = true;
            tempDate = (PropertyDate)indi.getProperty(new TagPath("INDI:BAPM:DATE"));
            if (tempDate == null || !tempDate.isValid()) {
                flagOk1 = false;
            }
            if ((tempDate = (PropertyDate)indi.getProperty(new TagPath("INDI:CHR:DATE"))) == null || !tempDate.isValid()) {
                flagOk2 = false;
            }
            this.addSymbol(strDataRow, flagOk1 != false || flagOk2 != false);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkBaptismPlace) {
            flagOk1 = true;
            flagOk2 = true;
            tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:BAPM:PLAC"));
            if (tempPlace == null || "".equals(tempPlace.getValue())) {
                flagOk1 = false;
            }
            if ((tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:CHR:PLAC"))) == null || tempPlace.getValue().length() == 0) {
                flagOk2 = false;
            }
            this.addSymbol(strDataRow, flagOk1 != false || flagOk2 != false);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkBaptismSource) {
            flagOk1 = true;
            flagOk2 = true;
            tempP = indi.getProperty(new TagPath("INDI:BAPM:SOUR"));
            if (tempP == null) {
                flagOk1 = false;
            }
            if ((tempP = indi.getProperty(new TagPath("INDI:CHR:SOUR"))) == null) {
                flagOk2 = false;
            }
            this.addSymbol(strDataRow, flagOk1 != false || flagOk2 != false);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkDeathDate) {
            tempDate = indi.getDeathDate();
            this.addSymbol(strDataRow, indi.getDeathDate() != null && tempDate.isValid());
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkDeathPlace) {
            tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:DEAT:PLAC"));
            this.addSymbol(strDataRow, tempPlace != null);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkDeathSource) {
            tempP = indi.getProperty(new TagPath("INDI:DEAT:SOUR"));
            this.addSymbol(strDataRow, tempP != null);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkSex) {
            this.addSymbol(strDataRow, indi.getSex() == 1 || indi.getSex() == 2);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkGiven) {
            this.addSymbol(strDataRow, !"".equals(indi.getFirstName()));
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        if (this.checkSurname) {
            this.addSymbol(strDataRow, !"".equals(indi.getLastName()));
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.outputType == 1) {
            strDataRow.append(';');
        }
        this.addLine(strDataRow.toString());
    }

    public Object start(Gedcom gedcom) {
        this.report.setLength(0);
        this.displayHeader(gedcom.getName());
        if (this.checkUseSosa) {
            this.useSosa(gedcom);
        } else {
            for (Entity e : gedcom.getEntities("INDI")) {
                this.checkIndi((Indi)e);
            }
        }
        if (this.outputType == 1) {
            return this.createFile();
        }
        this.println(this.report);
        return "OK";
    }

    private void useSosa(Gedcom gedcom) {
        TreeMap<BigInteger, Indi> sosaList = new TreeMap<BigInteger, Indi>();
        TreeMap<String, Indi> sosaListById = new TreeMap<String, Indi>();
        for (Entity e : gedcom.getEntities("INDI")) {
            Indi indi = (Indi)e;
            Property[] props = indi.getProperties(Indi.TAG_SOSA);
            if (props.length == 0) {
                props = indi.getProperties(Indi.TAG_SOSADABOVILLE);
            }
            for (Property prop : props) {
                String sosaStr = prop.getValue();
                int index = sosaStr.indexOf(".");
                if (index != -1 || sosaStr.matches(".*[a-z].*")) continue;
                index = sosaStr.indexOf(" ");
                if (index != -1) {
                    sosaStr = sosaStr.substring(0, index);
                }
                if ((index = sosaStr.indexOf("-")) != -1) continue;
                BigInteger divider = BigInteger.ONE;
                BigInteger bi = new BigInteger(sosaStr + "00").divide(divider);
                sosaList.put(bi, indi);
                sosaListById.put(indi.getId(), indi);
            }
        }
        if (this.checkSortOnSosa) {
            for (BigInteger bi : sosaList.keySet()) {
                this.checkIndi((Indi)sosaList.get(bi));
            }
        } else {
            for (String id : sosaListById.keySet()) {
                this.checkIndi((Indi)sosaListById.get(id));
            }
        }
    }

    public void displayHeader(String strSubject) {
        if (this.outputType == 1) {
            this.displayCsvHeader(strSubject);
            return;
        }
        this.addLine(ReportMissingInformation.align((String)this.textTitle, (int)132, (int)1));
        this.addLine("");
        this.addLine(this.textSubject + ": " + strSubject);
        this.addLine(this.textDate + ": " + PointInTime.getNow().toString());
        this.addLine(this.textKey);
        this.addLine("");
        String strUnderLine = "-";
        for (int loop = 1; loop < 131; ++loop) {
            strUnderLine = strUnderLine + "-";
        }
        String strColHeader1 = ReportMissingInformation.align((String)" ", (int)60, (int)1) + ReportMissingInformation.align((String)this.textBirth, (int)6, (int)1) + ReportMissingInformation.align((String)this.textBirth, (int)6, (int)1) + ReportMissingInformation.align((String)this.textBirth, (int)6, (int)1) + ReportMissingInformation.align((String)this.textBaptism, (int)6, (int)1) + ReportMissingInformation.align((String)this.textBaptism, (int)6, (int)1) + ReportMissingInformation.align((String)this.textBaptism, (int)6, (int)1) + ReportMissingInformation.align((String)this.textDeath, (int)6, (int)1) + ReportMissingInformation.align((String)this.textDeath, (int)6, (int)1) + ReportMissingInformation.align((String)this.textDeath, (int)6, (int)1);
        String strColHeader2 = ReportMissingInformation.align((String)" ", (int)60, (int)1) + ReportMissingInformation.align((String)this.textDate, (int)6, (int)1) + ReportMissingInformation.align((String)this.textPlace, (int)6, (int)1) + ReportMissingInformation.align((String)this.textSource, (int)6, (int)1) + ReportMissingInformation.align((String)this.textDate, (int)6, (int)1) + ReportMissingInformation.align((String)this.textPlace, (int)6, (int)1) + ReportMissingInformation.align((String)this.textSource, (int)6, (int)1) + ReportMissingInformation.align((String)this.textDate, (int)6, (int)1) + ReportMissingInformation.align((String)this.textPlace, (int)6, (int)1) + ReportMissingInformation.align((String)this.textSource, (int)6, (int)1) + ReportMissingInformation.align((String)this.textSex, (int)6, (int)1) + ReportMissingInformation.align((String)this.textGiven, (int)6, (int)1) + ReportMissingInformation.align((String)this.textSurname, (int)6, (int)1);
        this.addLine(strColHeader1);
        this.addLine(strColHeader2);
        this.addLine(strUnderLine);
    }

    public void displayCsvHeader(String strSubject) {
        this.report.append(this.textId).append(";");
        this.report.append(this.textSurname).append(";");
        this.report.append(this.textBirth).append(" ").append(this.textDate).append(";");
        this.report.append(this.textBirth).append(" ").append(this.textPlace).append(";");
        this.report.append(this.textBirth).append(" ").append(this.textSource).append(";");
        this.report.append(this.textBaptism).append(" ").append(this.textDate).append(";");
        this.report.append(this.textBaptism).append(" ").append(this.textPlace).append(";");
        this.report.append(this.textBaptism).append(" ").append(this.textSource).append(";");
        this.report.append(this.textDeath).append(" ").append(this.textDate).append(";");
        this.report.append(this.textDeath).append(" ").append(this.textPlace).append(";");
        this.report.append(this.textDeath).append(" ").append(this.textSource).append(";");
        this.report.append(this.textSex).append(";");
        this.report.append(this.textGiven).append(";");
        this.report.append(this.textSurname).append(";");
        this.report.append("\n");
    }

    private void addSymbol(StringBuilder sb, boolean test) {
        if (test) {
            sb.append(ReportMissingInformation.align((String)"ok", (int)6, (int)1));
        } else {
            sb.append(ReportMissingInformation.align((String)"X", (int)6, (int)1));
        }
    }

    private void addLine(String value) {
        this.report.append(value).append("\n");
    }

    private File createFile() {
        File fichier = this.getFileFromUser(this.translate("output.file"), AbstractAncestrisAction.TXT_OK, true, "csv");
        if (fichier != null) {
            try (FileOutputStream fos = new FileOutputStream(fichier);
                 OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF8"));){
                streamWriter.write(this.report.toString(), 0, this.report.length());
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Error during file creation.", e);
            }
        }
        return fichier;
    }
}

