/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.names;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.TagPath;
import genj.report.Report;

public class ReportNames
extends Report {
    public boolean reportOutputBirth = true;
    public boolean reportOutputDeath = true;
    public boolean reportOutputMarriage = true;
    public boolean reportFilterName = false;
    public boolean reportFilterLine = false;
    public String StrFilter = "";
    public boolean reportDatesOnlyYears = false;
    public String reportDetailSeparator = ";";
    public boolean reportAlwaysDetailSeparator = false;

    public void start(Gedcom gedcom) {
        Entity[] indis = gedcom.getEntities("INDI", "INDI:NAME");
        for (int i = 0; i < indis.length; ++i) {
            this.analyzeIndi((Indi)indis[i]);
        }
    }

    private String getDate(String str) {
        if (this.reportDatesOnlyYears & str.length() > 4) {
            str = str.substring(str.length() - 4);
        }
        return str;
    }

    public void start(Indi indi) {
        this.analyzeIndi(indi);
    }

    private String trim(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    private void analyzeIndi(Indi indi) {
        if (indi == null) {
            return;
        }
        String str = "";
        str = str + "(" + indi.getId() + ")\t";
        str = str + indi.getName();
        if (this.reportOutputBirth) {
            if (this.trim(indi.getBirthAsString()).length() > 0 || this.trim(indi.getProperty(new TagPath("INDI:BIRT:PLAC"))).length() > 0) {
                str = str + this.reportDetailSeparator + this.OPTIONS.getBirthSymbol();
            } else if (this.reportAlwaysDetailSeparator) {
                str = str + this.reportDetailSeparator;
            }
            if (this.trim(indi.getBirthAsString()).length() > 0) {
                str = str + this.trim(this.getDate(indi.getBirthAsString()));
            }
            if (this.trim(indi.getProperty(new TagPath("INDI:BIRT:PLAC"))).length() > 0) {
                str = str + this.reportDetailSeparator + this.trim(indi.getProperty(new TagPath("INDI:BIRT:PLAC")).getDisplayValue());
            }
        } else if (this.reportAlwaysDetailSeparator) {
            str = str + this.reportDetailSeparator;
        }
        if (this.reportOutputDeath) {
            if (indi.getProperty("DEAT") != null && (this.trim(indi.getDeathAsString()).length() > 0 || this.trim(indi.getProperty(new TagPath("INDI:DEAT:PLAC"))).length() > 0)) {
                str = str + this.reportDetailSeparator + this.OPTIONS.getDeathSymbol();
            } else if (this.reportAlwaysDetailSeparator) {
                str = str + this.reportDetailSeparator;
            }
            if (this.trim(indi.getDeathAsString()).length() > 0) {
                str = str + this.trim(this.getDate(indi.getDeathAsString()));
            }
            if (this.trim(indi.getProperty(new TagPath("INDI:DEAT:PLAC"))).length() > 0) {
                str = str + this.reportDetailSeparator + this.trim(indi.getProperty(new TagPath("INDI:DEAT:PLAC")).getDisplayValue());
            }
        } else if (this.reportAlwaysDetailSeparator) {
            str = str + this.reportDetailSeparator;
        }
        if (this.reportOutputMarriage) {
            Fam[] families = indi.getFamiliesWhereSpouse();
            for (int i = 0; i < families.length; ++i) {
                if (this.trim(families[i].getMarriageDate()).length() > 0 || this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0 || indi != families[i].getHusband() && families[i].getHusband() != null || indi != families[i].getWife() && families[i].getWife() != null) {
                    str = str + this.reportDetailSeparator + this.OPTIONS.getMarriageSymbol();
                }
                if (this.trim(families[i].getMarriageDate()).length() > 0 || this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
                    if (this.trim(families[i].getMarriageDate()).length() > 0) {
                        str = str + this.getDate(this.trim(families[i].getMarriageDate().getDisplayValue()));
                    }
                    if (this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
                        str = str + this.reportDetailSeparator + this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC")).getDisplayValue());
                    }
                } else if (this.reportAlwaysDetailSeparator) {
                    str = str + this.reportDetailSeparator;
                }
                if (indi != families[i].getHusband() && families[i].getHusband() != null) {
                    if (this.reportAlwaysDetailSeparator || this.trim(families[i].getMarriageDate()).length() > 0 || this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
                        str = str + this.reportDetailSeparator;
                    }
                    str = str + families[i].getHusband().getName();
                }
                if (indi != families[i].getWife() && families[i].getWife() != null) {
                    if (this.reportAlwaysDetailSeparator || this.trim(families[i].getMarriageDate()).length() > 0 || this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
                        str = str + this.reportDetailSeparator;
                    }
                    str = str + families[i].getWife().getName();
                }
                if (this.trim(families[i].getMarriageDate()).length() <= 0 && this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() <= 0 && (indi == families[i].getHusband() || families[i].getHusband() == null) && (indi == families[i].getWife() || families[i].getWife() == null)) continue;
                str = str + (this.reportAlwaysDetailSeparator ? this.reportDetailSeparator : "");
            }
        }
        if (this.reportFilterName) {
            if (indi.getName().toLowerCase().matches(".*" + this.StrFilter.toLowerCase() + ".*")) {
                this.println(str);
            }
        } else if (this.reportFilterLine && str.toLowerCase().matches(".*" + this.StrFilter.toLowerCase() + ".*")) {
            this.println(str);
        }
        if (!this.reportFilterName & !this.reportFilterLine) {
            this.println(str);
        }
    }
}

