/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.todo;

import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertyXRef;
import genj.report.Report;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ReportToDo
extends Report {
    private static final String PLACE_AND_DATE_FORMAT = "{$V }{$D}{ $P}";
    public String todoTag = "NOTE";
    public String todoStart = "TODO:";
    public boolean outputWorkingSheet = false;
    public boolean outputSummary = true;
    private static final String ROW_FORMAT_HEADER1 = "font-size=larger,background-color=#00ccff,font-weight=bold";
    private static final String FORMAT_HEADER2 = "font-size=large,background-color=#33ffff,font-weight=bold";
    private static final String FORMAT_HEADER3 = "background-color=#ffffcc,font-weight=bold";
    private static final String FORMAT_HEADER3_TODO = "background-color=#99cccc,font-weight=bold";
    private static final String FORMAT_HEADER4 = "background-color=#ffffcc";
    private static final String FORMAT_EMPHASIS = "font-weight=italic";
    private static final String FORMAT_STRONG = "font-weight=bold";

    public Document start(Gedcom gedcom) {
        List ents = gedcom.getEntities();
        return this.start(ents.toArray(new Entity[ents.size()]));
    }

    public void start(Indi indi) {
        this.start((Entity[])new Indi[]{indi});
    }

    public Document start(Fam fam) {
        return this.start((Entity[])new Fam[]{fam});
    }

    public Document start(Entity[] entities) {
        Document doc = new Document(this.translate("titletodos"));
        if (this.outputWorkingSheet) {
            doc.startTable();
            doc.addTableColumn("column-width=12%");
            doc.addTableColumn("column-width=10%");
            doc.addTableColumn("column-width=20%");
            doc.addTableColumn("column-width=20%");
            doc.addTableColumn("column-width=19%");
            doc.addTableColumn("column-width=19%");
            this.exportWorkingSheet(entities, doc);
            doc.endTable();
        }
        if (this.outputSummary) {
            doc.startTable("width=100%,border=0.5pt solid black,genj:csv=true");
            doc.nextTableRow(ROW_FORMAT_HEADER1);
            doc.addTableColumn("");
            doc.addTableColumn("");
            doc.addTableColumn("");
            doc.addTableColumn("");
            doc.addTableColumn("");
            doc.nextTableCell("number-columns-spanned=5");
            doc.addText(this.translate("titletodos"), ROW_FORMAT_HEADER1);
            doc.nextTableRow();
            doc.addText(this.translate("evt.col"), FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(this.translate("date.col"), FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(this.translate("place.col"), FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(this.translate("indi.col"), FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(this.translate("todo.col"), FORMAT_STRONG);
            int nbTodos = this.exportSummary(entities, doc);
            doc.endTable();
            doc.addText(this.translate("nbtodos", new Object[]{"" + nbTodos}));
        }
        return doc;
    }

    private void exportWorkingSheet(Entity[] entities, Document doc) {
        for (int e = 0; e < entities.length; ++e) {
            Entity entity = entities[e];
            List todos = this.findProperties((Property)entity);
            if (todos.isEmpty()) continue;
            if (entity instanceof Indi) {
                this.exportEntity((Indi)entity, doc);
            }
            if (!(entity instanceof Fam)) continue;
            this.exportEntity((Fam)entity, doc);
        }
    }

    private void exportEntity(Fam fam, Document doc) {
        Property prop;
        int i;
        Fam tempFam;
        String tempString = "";
        List todos = this.findProperties((Property)fam);
        if (todos.size() == 0) {
            return;
        }
        doc.nextTableRow(ROW_FORMAT_HEADER1);
        doc.nextTableCell("number-columns-spanned=6");
        doc.addText(this.translate("titlefam", new Object[]{fam.toString(), fam.getId()}));
        Indi tempIndi = fam.getHusband();
        doc.nextTableRow(FORMAT_HEADER2);
        doc.addText(Gedcom.getName((String)"HUSB"));
        doc.nextTableCell("number-columns-spanned=5");
        doc.addText(tempIndi == null ? "" : tempIndi.getName());
        this.outputEventRow((Entity)tempIndi, "BIRT", todos, doc);
        this.outputEventRow((Entity)tempIndi, "BAPM", todos, doc);
        this.outputEventRow((Entity)tempIndi, "DEAT", todos, doc);
        this.outputEventRow((Entity)tempIndi, "BURI", todos, doc);
        if (tempIndi != null && (tempFam = tempIndi.getFamilyWhereBiologicalChild()) != null) {
            doc.nextTableRow();
            doc.nextTableCell(FORMAT_HEADER3);
            doc.addText(this.translate("father") + ":");
            doc.nextTableCell("number-columns-spanned=5");
            this.addIndiString(tempFam.getHusband(), doc);
            doc.nextTableRow();
            doc.nextTableCell(FORMAT_HEADER3);
            doc.addText(this.translate("mother") + ":");
            doc.nextTableCell("number-columns-spanned=5");
            this.addIndiString(tempFam.getWife(), doc);
        }
        tempIndi = fam.getWife();
        doc.nextTableRow(FORMAT_HEADER2);
        doc.addText(Gedcom.getName((String)"WIFE"));
        doc.nextTableCell("number-columns-spanned=5");
        doc.addText(tempIndi == null ? "" : tempIndi.getName());
        this.outputEventRow((Entity)tempIndi, "BIRT", todos, doc);
        this.outputEventRow((Entity)tempIndi, "BAPM", todos, doc);
        this.outputEventRow((Entity)tempIndi, "DEAT", todos, doc);
        this.outputEventRow((Entity)tempIndi, "BURI", todos, doc);
        if (tempIndi != null && (tempFam = tempIndi.getFamilyWhereBiologicalChild()) != null) {
            doc.nextTableRow();
            doc.nextTableCell(FORMAT_HEADER3);
            doc.addText(this.translate("father"));
            doc.nextTableCell("number-columns-spanned=5");
            this.addIndiString(tempFam.getHusband(), doc);
            doc.nextTableRow();
            doc.nextTableCell(FORMAT_HEADER3);
            doc.addText(this.translate("mother") + ":");
            doc.nextTableCell("number-columns-spanned=5");
            this.addIndiString(tempFam.getWife(), doc);
        }
        this.outputEventRow((Entity)fam, "MARR", todos, doc);
        Indi[] children = fam.getChildren();
        if (children.length > 0) {
            doc.nextTableRow(FORMAT_HEADER2);
            doc.nextTableCell("number-columns-spanned=6");
            doc.addText(Gedcom.getName((String)"CHIL", (children.length > 1 ? 1 : 0) != 0));
            for (int c = 0; c < children.length; ++c) {
                doc.nextTableRow();
                doc.nextTableCell(FORMAT_HEADER3);
                doc.addText("" + (c + 1));
                doc.nextTableCell("number-columns-spanned=5");
                this.addIndiString(children[c], doc);
            }
        }
        Property[] propArray = fam.getProperties("NOTE");
        boolean seenNote = false;
        for (i = 0; i < propArray.length; ++i) {
            prop = propArray[i];
            if (todos.contains(prop)) continue;
            if (!seenNote) {
                doc.nextTableRow(FORMAT_HEADER2);
                doc.nextTableCell("number-columns-spanned=6");
                doc.addText(this.translate("main.notes"));
                seenNote = true;
            }
            doc.nextTableRow();
            doc.nextTableCell();
            doc.nextTableCell("number-columns-spanned=5");
            this.outputPropertyValue(prop, doc);
        }
        doc.nextTableRow(FORMAT_HEADER2);
        doc.nextTableCell("number-columns-spanned=6");
        doc.addText(this.translate("titletodo"));
        for (i = 0; i < todos.size(); ++i) {
            prop = (Property)todos.get(i);
            Property parent = prop.getParent();
            doc.nextTableRow();
            if (parent instanceof Fam) {
                doc.nextTableCell();
                doc.nextTableCell("number-columns-spanned=5");
                this.outputPropertyValue(prop, doc);
                continue;
            }
            doc.nextTableCell(FORMAT_HEADER3_TODO);
            doc.addText(Gedcom.getName((String)parent.getTag()));
            doc.nextTableCell("number-columns-spanned=5,");
            doc.addText(parent.format(PLACE_AND_DATE_FORMAT));
            doc.nextParagraph();
            this.outputPropertyValue(prop, doc);
            doc.nextParagraph();
            doc.addText(this.outputProperty(prop, prop.getPath().toString() + ":REPO"));
            doc.nextParagraph();
            doc.addText(this.outputProperty(prop, prop.getPath().toString() + ":NOTE"));
        }
    }

    private void exportEntity(Indi indi, Document doc) {
        Property prop;
        int i;
        Fam[] fams;
        String tempString = "";
        List todos = this.findProperties((Property)indi);
        if (todos.size() == 0) {
            return;
        }
        doc.nextTableRow(ROW_FORMAT_HEADER1);
        doc.nextTableCell("number-columns-spanned=6");
        doc.addText(this.translate("titleindi", new Object[]{indi.getName(), indi.getId()}));
        doc.nextTableRow();
        doc.nextTableCell("number-columns-spanned=6,font-size=large,background-color=#33ffff,font-weight=bold");
        doc.addText(this.translate("titleinfosperso"));
        doc.nextTableRow();
        doc.nextTableCell(FORMAT_HEADER3);
        doc.addText(Gedcom.getName((String)"NAME"));
        doc.nextTableCell("number-columns-spanned=3");
        doc.addText(indi.getLastName() + " ", FORMAT_STRONG);
        doc.addText(indi.getFirstName());
        doc.nextTableCell();
        doc.addText("ID: " + indi.getId());
        doc.nextTableCell();
        doc.addText(Gedcom.getName((String)"SEX") + ": " + PropertySex.getLabelForSex((int)indi.getSex()));
        doc.nextTableRow();
        doc.nextTableCell(FORMAT_HEADER3);
        doc.addText(Gedcom.getName((String)"NICK"));
        doc.nextTableCell("number-columns-spanned=5");
        doc.addText(this.outputProperty((Property)indi, "INDI:NAME:NICK"));
        this.outputEventRow((Entity)indi, "BIRT", todos, doc);
        this.outputEventRow((Entity)indi, "BAPM", todos, doc);
        this.outputEventRow((Entity)indi, "DEAT", todos, doc);
        this.outputEventRow((Entity)indi, "BURI", todos, doc);
        doc.nextTableRow();
        doc.nextTableCell(FORMAT_HEADER3);
        doc.addText(Gedcom.getName((String)"REFN"));
        doc.nextTableCell("number-columns-spanned=3");
        doc.addText(this.outputProperty((Property)indi, "INDI:REFN"));
        doc.nextTableCell(FORMAT_HEADER3);
        doc.addText(Gedcom.getName((String)"CHAN"));
        doc.nextTableCell();
        doc.addText(this.outputProperty((Property)indi, "INDI:CHAN"));
        Fam fam = indi.getFamilyWhereBiologicalChild();
        if (fam != null) {
            doc.nextTableRow();
            doc.nextTableCell(FORMAT_HEADER3);
            doc.addText(this.translate("father") + ":");
            doc.nextTableCell("number-columns-spanned=5");
            this.addIndiString(fam.getHusband(), doc);
            doc.nextTableRow();
            doc.nextTableCell(FORMAT_HEADER3);
            doc.addText(this.translate("mother") + ":");
            doc.nextTableCell("number-columns-spanned=5");
            this.addIndiString(fam.getWife(), doc);
        }
        if ((fams = indi.getFamiliesWhereSpouse()).length > 0) {
            doc.nextTableRow();
            doc.nextTableCell("number-columns-spanned=6,font-size=large,background-color=#33ffff,font-weight=bold");
            doc.addText(Gedcom.getName((String)"FAM", (fams.length > 1 ? 1 : 0) != 0));
        }
        for (int f = 0; f < fams.length; ++f) {
            Fam famc = fams[f];
            Indi spouse = famc.getOtherSpouse(indi);
            if (spouse == null) continue;
            Indi[] children = famc.getChildren();
            doc.nextTableRow();
            doc.nextTableCell("number-rows-spanned=" + (children.length + 1) + "," + FORMAT_HEADER3);
            doc.addText(this.translate("spouse") + ":");
            doc.nextTableCell("number-columns-spanned=5");
            this.addIndiString(spouse, doc);
            doc.nextParagraph();
            doc.addText(Gedcom.getName((String)"MARR") + " : ", FORMAT_STRONG);
            doc.addText(famc.format("MARR", PLACE_AND_DATE_FORMAT));
            if (children.length <= 0) continue;
            doc.nextTableRow();
            doc.nextTableCell("number-rows-spanned=" + children.length + "," + FORMAT_HEADER4);
            doc.addText(Gedcom.getName((String)"CHIL", (children.length > 1 ? 1 : 0) != 0));
            doc.nextTableCell("number-columns-spanned=4");
            this.addIndiString(children[0], doc);
            for (int c = 1; c < children.length; ++c) {
                doc.nextTableRow();
                doc.nextTableCell("number-columns-spanned=4");
                this.addIndiString(children[c], doc);
            }
        }
        doc.nextTableRow();
        doc.nextTableCell("number-columns-spanned=6,font-size=large,background-color=#33ffff,font-weight=bold");
        doc.addText(Gedcom.getName((String)"EVEN", (boolean)true));
        this.outputEventRow((Entity)indi, "OCCU", todos, doc);
        this.outputEventRow((Entity)indi, "RESI", todos, doc);
        Property[] propArray = indi.getProperties("NOTE");
        boolean seenNote = false;
        for (i = 0; i < propArray.length; ++i) {
            prop = propArray[i];
            if (todos.contains(prop)) continue;
            if (!seenNote) {
                doc.nextTableRow();
                doc.nextTableCell("number-columns-spanned=6,font-size=large,background-color=#33ffff,font-weight=bold");
                doc.addText(this.translate("main.notes"));
                seenNote = true;
            }
            doc.nextTableRow();
            doc.nextTableCell("number-columns-spanned=6");
            this.outputPropertyValue(prop, doc);
        }
        doc.nextTableRow();
        doc.nextTableCell("number-columns-spanned=6,font-size=large,background-color=#33ffff,font-weight=bold");
        doc.addText(this.translate("titletodo"));
        for (i = 0; i < todos.size(); ++i) {
            prop = (Property)todos.get(i);
            Property parent = prop.getParent();
            if (parent instanceof Indi) {
                doc.nextTableRow();
                doc.nextTableCell();
                doc.nextTableCell("number-columns-spanned=5");
                this.outputPropertyValue(prop, doc);
                continue;
            }
            doc.nextTableRow();
            doc.nextTableCell(FORMAT_HEADER3_TODO);
            doc.addText(Gedcom.getName((String)parent.getTag()));
            doc.nextTableCell("number-columns-spanned=5");
            doc.addText(parent.format(PLACE_AND_DATE_FORMAT));
            doc.nextParagraph();
            this.outputPropertyValue(prop, doc);
            doc.nextParagraph();
            doc.addText(this.formatString("", this.outputProperty(prop, prop.getPath().toString() + ":REPO"), ""));
            doc.nextParagraph();
            doc.addText(this.formatString("", this.outputProperty(prop, prop.getPath().toString() + ":NOTE"), ""));
        }
    }

    private void outputEventRow(Entity indi, String tag, List todos, Document doc) {
        if (indi == null) {
            return;
        }
        Property[] props = indi.getProperties(tag);
        if (props.length == 0) {
            return;
        }
        if (props.length == 1) {
            doc.nextTableRow();
            doc.nextTableCell(FORMAT_HEADER3);
            doc.addText(Gedcom.getName((String)tag));
            doc.nextTableCell("number-columns-spanned=5");
            doc.addText(indi.format(tag, PLACE_AND_DATE_FORMAT));
            doc.nextParagraph();
            this.outputNotes("Note : ", indi.getProperty(tag), todos, doc);
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            doc.nextTableRow();
            doc.nextTableCell(FORMAT_HEADER3);
            doc.addText(Gedcom.getName((String)tag));
            doc.nextTableCell("number-columns-spanned=5");
            doc.addText(props[i].format(PLACE_AND_DATE_FORMAT));
            doc.nextParagraph();
            this.outputNotes("Note : ", props[i], todos, doc);
        }
    }

    private int exportSummary(Entity[] ents, Document doc) {
        boolean isFirstPage = true;
        int nbTodos = 0;
        for (int e = 0; e < ents.length; ++e) {
            List todos = this.findProperties((Property)ents[e]);
            if (todos.size() == 0) continue;
            for (int i = 0; i < todos.size(); ++i) {
                Property parent;
                Property prop = (Property)todos.get(i);
                if (prop instanceof PropertyMultilineValue || (parent = prop.getParent()) == null) continue;
                doc.nextTableRow();
                if (parent instanceof Entity) {
                    doc.nextTableCell();
                    doc.nextTableCell();
                    doc.nextTableCell();
                } else {
                    doc.addText(Gedcom.getName((String)parent.getTag()));
                    doc.nextTableCell();
                    doc.addText(parent.getPropertyDisplayValue("DATE"));
                    doc.nextTableCell();
                    doc.addText(parent.getPropertyDisplayValue("PLAC"));
                }
                doc.nextTableCell();
                doc.addText(prop.getEntity().toString());
                doc.nextTableCell();
                this.outputPropertyValue(prop, doc);
                ++nbTodos;
            }
        }
        return nbTodos;
    }

    private void outputNotes(String prefix, Property prop, List exclude, Document doc) {
        if (prop == null) {
            return;
        }
        Property[] props = prop.getProperties("NOTE");
        for (int i = 0; i < props.length; ++i) {
            if (exclude.contains(props[i])) continue;
            doc.addText(prefix, FORMAT_STRONG);
            this.outputPropertyValue(props[i], doc);
        }
    }

    private String outputProperty(Property prop, String tagPath) {
        Property subProp = prop.getPropertyByPath(tagPath);
        return subProp == null ? "" : subProp.toString();
    }

    private String formatString(String start, String middle, String end) {
        if (middle != null && middle.length() != 0) {
            return (start == null ? "" : start) + middle + (end == null ? "" : end);
        }
        return "";
    }

    private void addIndiString(Indi indi, Document doc) {
        if (indi == null) {
            return;
        }
        String birth = indi.format("BIRT", this.OPTIONS.getBirthSymbol() + PLACE_AND_DATE_FORMAT);
        String death = indi.format("DEAT", this.OPTIONS.getDeathSymbol() + PLACE_AND_DATE_FORMAT);
        doc.addText(indi.toString(), FORMAT_STRONG);
        doc.addText(" " + birth + " " + death);
    }

    private void outputPropertyValue(Property prop, Document doc) {
        if (prop instanceof PropertyXRef) {
            PropertyXRef xref = (PropertyXRef)prop;
            this.outputPropertyValue((Property)xref.getTargetEntity(), doc);
            return;
        }
        if (!(prop instanceof MultiLineProperty)) {
            doc.addText(prop.getDisplayValue());
            return;
        }
        StringTokenizer lines = new StringTokenizer(prop.getValue(), "\n");
        while (lines.hasMoreTokens()) {
            doc.nextParagraph();
            doc.addText(lines.nextToken());
        }
    }

    private List findProperties(Property of) {
        return of.findProperties(Pattern.compile(this.todoTag), Pattern.compile(this.todoStart + ".*", 32));
    }
}

