/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.editors;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.beans.ImageBean;
import ancestris.modules.editors.genealogyeditor.editors.EntityEditor;
import ancestris.modules.editors.genealogyeditor.editors.IndividualEditor;
import ancestris.modules.editors.genealogyeditor.models.EventsListModel;
import ancestris.modules.editors.genealogyeditor.panels.ChildrenTreeTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.FamilyEventPanel;
import ancestris.modules.editors.genealogyeditor.panels.IndividualsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.MultimediaObjectCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.NoteCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.SourceCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.utilities.PropertyTag2Name;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.UnitOfWork;
import genj.io.InputSource;
import genj.util.Registry;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.DialogDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FamilyEditor
extends EntityEditor {
    private final ArrayList<String> mFamilyEventsTags = new ArrayList<String>(){
        {
            this.add("ANUL");
            this.add("CENS");
            this.add("DIV");
            this.add("DIVF");
            this.add("MARR");
            this.add("ENGA");
            this.add("MARB");
            this.add("MARC");
            this.add("MARL");
            this.add("MARS");
            this.add("RESI");
            this.add("EVEN");
        }
    };
    private Context context;
    private Context selectedEventContext;
    private Fam mFamily;
    private Indi mHusband;
    private Indi mWife;
    private Property mEvent = null;
    private boolean updateOnGoing = false;
    private final EventsListModel mEventsListModel = new EventsListModel();
    private final DefaultComboBoxModel<String> mEventsModel = new DefaultComboBoxModel<String>(new String[0]);
    private Registry registry = null;
    private boolean changeListInProgress = false;
    private JButton addHusbandButton;
    private JButton addWifeButton;
    private JLabel changeDateLabel;
    private JLabel changeDateLabeldate;
    private JPanel childrenPanel;
    private ChildrenTreeTablePanel childrenTreeTablePanel;
    private JButton deleteEventButton;
    private JButton editHusbandButton;
    private JButton editWifeButton;
    private JComboBox<String> eventTypeComboBox;
    private JList eventsList;
    private JPanel eventsListPanel;
    private JScrollPane eventsListScrollPane;
    private JToolBar eventsListToolBar;
    private JPanel eventsPanel;
    private JSplitPane eventsSplitPane;
    private FamilyEventPanel familyEventPanel;
    private JLabel familyIDLabel;
    private JTextField familyIDTextField;
    private JTabbedPane familyTabbedPane;
    private JPanel fatherPanel;
    private JToolBar fatherToolBar;
    private Box.Filler filler1;
    private Box.Filler filler4;
    private JPanel galleryPanel;
    private JLabel husbandBirthDateLabel;
    private JLabel husbandBirthDateLabelDate;
    private JLabel husbandDeathDateLabel;
    private JLabel husbandDeathDateLabelDate;
    private ImageBean husbandImageBean;
    private JTextField husbandNameTextField;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton linkToHusbandButton;
    private JButton linkToWifeButton;
    private JPanel motherPanel;
    private JToolBar motherToolBar;
    private MultimediaObjectCitationsTablePanel multimediaObjectCitationsTablePanel;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private JPanel notesPanel;
    private JToggleButton privateRecordToggleButton;
    private JButton removeHusbandButton;
    private JButton removeWifeButton;
    private SourceCitationsTablePanel sourceCitationsTablePanel;
    private JPanel sourcesPanel;
    private JLabel wifeBirthDateLabel;
    private JLabel wifeBirthDateLabelDate;
    private JLabel wifeDeathDateLabel;
    private JLabel wifeDeathDateLabelDate;
    private ImageBean wifeImageBean;
    private JTextField wifeNameTextField;

    public FamilyEditor() {
        this(false);
    }

    public FamilyEditor(boolean isNew) {
        super(isNew);
        this.initComponents();
        this.selectedEventContext = null;
        this.eventsList.getSelectionModel().addListSelectionListener(new EventsListSelectionHandler());
        this.familyEventPanel.setVisible(false);
        this.familyEventPanel.addChangeListener((ChangeListener)this.changes);
        this.childrenTreeTablePanel.addChangeListener((ChangeListener)this.changes);
        this.sourceCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.noteCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.multimediaObjectCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
        JComboBox.KeySelectionManager manager = new JComboBox.KeySelectionManager(){

            public int selectionForKey(char aKey, ComboBoxModel aModel) {
                System.out.println(aKey);
                return -1;
            }
        };
        this.eventTypeComboBox.setKeySelectionManager(manager);
        this.eventTypeComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.registry = Registry.get(((Object)((Object)this)).getClass());
        this.eventsSplitPane.setDividerLocation(this.registry.get("ariesfamilyeventSplitDividerLocation", this.eventsSplitPane.getDividerLocation()));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.familyIDTextField = new JTextField();
        this.familyIDLabel = new JLabel();
        this.privateRecordToggleButton = new JToggleButton();
        this.fatherPanel = new JPanel();
        this.fatherToolBar = new JToolBar();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.addHusbandButton = new JButton();
        this.linkToHusbandButton = new JButton();
        this.removeHusbandButton = new JButton();
        this.editHusbandButton = new JButton();
        this.husbandNameTextField = new JTextField();
        this.husbandBirthDateLabel = new JLabel();
        this.husbandDeathDateLabel = new JLabel();
        this.husbandImageBean = new ImageBean();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.husbandBirthDateLabelDate = new JLabel();
        this.husbandDeathDateLabelDate = new JLabel();
        this.motherPanel = new JPanel();
        this.motherToolBar = new JToolBar();
        this.filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.addWifeButton = new JButton();
        this.linkToWifeButton = new JButton();
        this.removeWifeButton = new JButton();
        this.editWifeButton = new JButton();
        this.wifeNameTextField = new JTextField();
        this.wifeBirthDateLabel = new JLabel();
        this.wifeDeathDateLabel = new JLabel();
        this.wifeImageBean = new ImageBean();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.wifeBirthDateLabelDate = new JLabel();
        this.wifeDeathDateLabelDate = new JLabel();
        this.familyTabbedPane = new JTabbedPane();
        this.eventsPanel = new JPanel();
        this.eventsSplitPane = new JSplitPane();
        this.eventsListPanel = new JPanel();
        this.eventsListToolBar = new JToolBar();
        this.deleteEventButton = new JButton();
        this.eventTypeComboBox = new JComboBox();
        this.eventsListScrollPane = new JScrollPane();
        this.eventsList = new JList();
        this.jPanel2 = new JPanel();
        this.familyEventPanel = new FamilyEventPanel();
        this.childrenPanel = new JPanel();
        this.childrenTreeTablePanel = new ChildrenTreeTablePanel();
        this.sourcesPanel = new JPanel();
        this.sourceCitationsTablePanel = new SourceCitationsTablePanel();
        this.notesPanel = new JPanel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.galleryPanel = new JPanel();
        this.multimediaObjectCitationsTablePanel = new MultimediaObjectCitationsTablePanel();
        this.changeDateLabel = new JLabel();
        this.changeDateLabeldate = new JLabel();
        this.familyIDTextField.setEditable(false);
        this.familyIDTextField.setColumns(8);
        this.familyIDLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.familyIDLabel.text"), new Object[0]));
        this.privateRecordToggleButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock_open.png")));
        this.privateRecordToggleButton.setToolTipText(NbBundle.getMessage(FamilyEditor.class, (String)"FamilyEditor.privateRecordToggleButton.toolTipText"));
        this.privateRecordToggleButton.setMaximumSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setMinimumSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setPreferredSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setRolloverIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock_open.png")));
        this.privateRecordToggleButton.setRolloverSelectedIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock.png")));
        this.privateRecordToggleButton.setSelectedIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock.png")));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(507, Short.MAX_VALUE).addComponent(this.familyIDLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.familyIDTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.privateRecordToggleButton, -2, -1, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.familyIDLabel).addComponent(this.familyIDTextField, -2, -1, -2).addComponent(this.privateRecordToggleButton, -2, -1, -2)));
        this.fatherPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.fatherPanel.border.title"), new Object[0]), 0, 2));
        this.fatherPanel.setMinimumSize(new Dimension(100, 135));
        this.fatherPanel.setPreferredSize(new Dimension(100, 135));
        this.fatherToolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.fatherToolBar.setFloatable(false);
        this.fatherToolBar.setRollover(true);
        this.fatherToolBar.setMinimumSize(new Dimension(50, 30));
        this.fatherToolBar.setOpaque(false);
        this.fatherToolBar.setPreferredSize(new Dimension(50, 30));
        this.fatherToolBar.add(this.filler1);
        this.addHusbandButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addHusbandButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.addHusbandButton.toolTipText"), new Object[0]));
        this.addHusbandButton.setFocusable(false);
        this.addHusbandButton.setHorizontalTextPosition(0);
        this.addHusbandButton.setVerticalTextPosition(3);
        this.addHusbandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyEditor.this.addHusbandButtonActionPerformed(evt);
            }
        });
        this.fatherToolBar.add(this.addHusbandButton);
        this.linkToHusbandButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/link_add.png")));
        this.linkToHusbandButton.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.linkToHusbandButton.text"), new Object[0]));
        this.linkToHusbandButton.setFocusable(false);
        this.linkToHusbandButton.setHorizontalTextPosition(0);
        this.linkToHusbandButton.setVerticalTextPosition(3);
        this.linkToHusbandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyEditor.this.linkToHusbandButtonActionPerformed(evt);
            }
        });
        this.fatherToolBar.add(this.linkToHusbandButton);
        this.removeHusbandButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.removeHusbandButton.setFocusable(false);
        this.removeHusbandButton.setHorizontalTextPosition(0);
        this.removeHusbandButton.setVerticalTextPosition(3);
        this.removeHusbandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyEditor.this.removeHusbandButtonActionPerformed(evt);
            }
        });
        this.fatherToolBar.add(this.removeHusbandButton);
        this.editHusbandButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editHusbandButton.setFocusable(false);
        this.editHusbandButton.setHorizontalTextPosition(4);
        this.editHusbandButton.setVerticalTextPosition(3);
        this.editHusbandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyEditor.this.editHusbandButtonActionPerformed(evt);
            }
        });
        this.fatherToolBar.add(this.editHusbandButton);
        this.husbandNameTextField.setEditable(false);
        this.husbandNameTextField.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.husbandNameTextField.setFont(new Font("Dialog", 0, 14));
        this.husbandNameTextField.setHorizontalAlignment(2);
        this.husbandNameTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.husbandNameTextField.text"), new Object[0]));
        this.husbandNameTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.husbandNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyEditor.this.husbandNameTextFieldActionPerformed(evt);
            }
        });
        this.husbandBirthDateLabel.setHorizontalAlignment(2);
        this.husbandBirthDateLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.husbandBirthDateLabel.text"), new Object[0]));
        this.husbandDeathDateLabel.setHorizontalAlignment(2);
        this.husbandDeathDateLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.husbandDeathDateLabel.text"), new Object[0]));
        this.husbandImageBean.setMinimumSize(new Dimension(77, 112));
        this.husbandImageBean.setPreferredSize(new Dimension(77, 112));
        GroupLayout husbandImageBeanLayout = new GroupLayout(this.husbandImageBean);
        this.husbandImageBean.setLayout(husbandImageBeanLayout);
        husbandImageBeanLayout.setHorizontalGroup(husbandImageBeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        husbandImageBeanLayout.setVerticalGroup(husbandImageBeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jLabel2.setText(":");
        this.jLabel3.setText(":");
        GroupLayout fatherPanelLayout = new GroupLayout(this.fatherPanel);
        this.fatherPanel.setLayout(fatherPanelLayout);
        fatherPanelLayout.setHorizontalGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fatherPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.husbandImageBean, -2, 71, -2).addGap(18, 18, 18).addGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fatherPanelLayout.createSequentialGroup().addGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.husbandDeathDateLabel, -1, -1, Short.MAX_VALUE).addComponent(this.husbandBirthDateLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.husbandBirthDateLabelDate, -1, -1, Short.MAX_VALUE).addComponent(this.husbandDeathDateLabelDate, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent(this.husbandNameTextField).addComponent(this.fatherToolBar, -1, -1, Short.MAX_VALUE))));
        fatherPanelLayout.setVerticalGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fatherPanelLayout.createSequentialGroup().addGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fatherPanelLayout.createSequentialGroup().addComponent(this.husbandNameTextField, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.husbandBirthDateLabel).addComponent(this.jLabel2).addComponent(this.husbandBirthDateLabelDate)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.husbandDeathDateLabel).addComponent(this.jLabel3).addComponent(this.husbandDeathDateLabelDate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fatherToolBar, -2, 25, -2)).addGroup(fatherPanelLayout.createSequentialGroup().addComponent(this.husbandImageBean, -2, 94, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.motherPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.motherPanel.border.title"), new Object[0]), 0, 2));
        this.motherPanel.setMinimumSize(new Dimension(100, 135));
        this.motherPanel.setPreferredSize(new Dimension(100, 135));
        this.motherToolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.motherToolBar.setFloatable(false);
        this.motherToolBar.setRollover(true);
        this.motherToolBar.setOpaque(false);
        this.motherToolBar.add(this.filler4);
        this.addWifeButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addWifeButton.setFocusable(false);
        this.addWifeButton.setHorizontalTextPosition(0);
        this.addWifeButton.setVerticalTextPosition(3);
        this.addWifeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyEditor.this.addWifeButtonActionPerformed(evt);
            }
        });
        this.motherToolBar.add(this.addWifeButton);
        this.linkToWifeButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/link_add.png")));
        this.linkToWifeButton.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.linkToWifeButton.text"), new Object[0]));
        this.linkToWifeButton.setFocusable(false);
        this.linkToWifeButton.setHorizontalTextPosition(0);
        this.linkToWifeButton.setVerticalTextPosition(3);
        this.linkToWifeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyEditor.this.linkToWifeButtonActionPerformed(evt);
            }
        });
        this.motherToolBar.add(this.linkToWifeButton);
        this.removeWifeButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.removeWifeButton.setFocusable(false);
        this.removeWifeButton.setHorizontalTextPosition(0);
        this.removeWifeButton.setVerticalTextPosition(3);
        this.removeWifeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyEditor.this.removeWifeButtonActionPerformed(evt);
            }
        });
        this.motherToolBar.add(this.removeWifeButton);
        this.editWifeButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editWifeButton.setFocusable(false);
        this.editWifeButton.setHorizontalTextPosition(0);
        this.editWifeButton.setVerticalTextPosition(3);
        this.editWifeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyEditor.this.editWifeButtonActionPerformed(evt);
            }
        });
        this.motherToolBar.add(this.editWifeButton);
        this.wifeNameTextField.setEditable(false);
        this.wifeNameTextField.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.wifeNameTextField.setFont(new Font("Dialog", 0, 14));
        this.wifeNameTextField.setHorizontalAlignment(2);
        this.wifeNameTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.wifeNameTextField.text"), new Object[0]));
        this.wifeNameTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.wifeBirthDateLabel.setHorizontalAlignment(2);
        this.wifeBirthDateLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.wifeBirthDateLabel.text"), new Object[0]));
        this.wifeDeathDateLabel.setHorizontalAlignment(2);
        this.wifeDeathDateLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.wifeDeathDateLabel.text"), new Object[0]));
        this.wifeImageBean.setMinimumSize(new Dimension(77, 112));
        this.wifeImageBean.setPreferredSize(new Dimension(77, 112));
        GroupLayout wifeImageBeanLayout = new GroupLayout(this.wifeImageBean);
        this.wifeImageBean.setLayout(wifeImageBeanLayout);
        wifeImageBeanLayout.setHorizontalGroup(wifeImageBeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        wifeImageBeanLayout.setVerticalGroup(wifeImageBeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jLabel4.setText(":");
        this.jLabel5.setText(":");
        GroupLayout motherPanelLayout = new GroupLayout(this.motherPanel);
        this.motherPanel.setLayout(motherPanelLayout);
        motherPanelLayout.setHorizontalGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(motherPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.wifeImageBean, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.motherToolBar, -1, -1, Short.MAX_VALUE).addGroup(motherPanelLayout.createSequentialGroup().addGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(motherPanelLayout.createSequentialGroup().addGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.wifeDeathDateLabel, -1, -1, Short.MAX_VALUE).addComponent(this.wifeBirthDateLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wifeBirthDateLabelDate, -1, -1, Short.MAX_VALUE).addComponent(this.wifeDeathDateLabelDate, -1, -1, Short.MAX_VALUE))).addComponent(this.wifeNameTextField)).addContainerGap()))));
        motherPanelLayout.setVerticalGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(motherPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wifeImageBean, -2, 94, -2).addGroup(motherPanelLayout.createSequentialGroup().addComponent(this.wifeNameTextField, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wifeBirthDateLabel).addComponent(this.jLabel4).addComponent(this.wifeBirthDateLabelDate)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wifeDeathDateLabel).addComponent(this.jLabel5).addComponent(this.wifeDeathDateLabelDate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.motherToolBar, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        this.eventsSplitPane.setBorder(null);
        this.eventsSplitPane.setDividerSize(6);
        this.eventsSplitPane.setMinimumSize(new Dimension(151, 162));
        this.eventsSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FamilyEditor.this.eventsSplitPanePropertyChange(evt);
            }
        });
        this.eventsListPanel.setMinimumSize(new Dimension(20, 162));
        this.eventsListPanel.setPreferredSize(new Dimension(200, 162));
        this.eventsListPanel.setRequestFocusEnabled(false);
        this.eventsListPanel.setLayout(new BorderLayout());
        this.eventsListToolBar.setFloatable(false);
        this.eventsListToolBar.setRollover(true);
        this.deleteEventButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteEventButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.deleteEventButton.toolTipText"), new Object[0]));
        this.deleteEventButton.setFocusable(false);
        this.deleteEventButton.setHorizontalTextPosition(0);
        this.deleteEventButton.setVerticalTextPosition(3);
        this.deleteEventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyEditor.this.deleteEventButtonActionPerformed(evt);
            }
        });
        this.eventsListToolBar.add(this.deleteEventButton);
        this.eventTypeComboBox.setModel(this.mEventsModel);
        this.eventTypeComboBox.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.eventTypeComboBox.toolTipText"), new Object[0]));
        this.eventTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyEditor.this.eventTypeComboBoxActionPerformed(evt);
            }
        });
        this.eventsListToolBar.add(this.eventTypeComboBox);
        this.eventsListPanel.add((Component)this.eventsListToolBar, "North");
        this.eventsList.setModel(this.mEventsListModel);
        this.eventsList.setSelectionMode(0);
        this.eventsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FamilyEditor.this.eventsListValueChanged(evt);
            }
        });
        this.eventsListScrollPane.setViewportView(this.eventsList);
        this.eventsListPanel.add((Component)this.eventsListScrollPane, "Center");
        this.eventsSplitPane.setLeftComponent(this.eventsListPanel);
        this.jPanel2.setPreferredSize(new Dimension(100, 306));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familyEventPanel, -1, -1, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familyEventPanel, GroupLayout.Alignment.TRAILING, -2, 310, Short.MAX_VALUE));
        this.eventsSplitPane.setRightComponent(this.jPanel2);
        GroupLayout eventsPanelLayout = new GroupLayout(this.eventsPanel);
        this.eventsPanel.setLayout(eventsPanelLayout);
        eventsPanelLayout.setHorizontalGroup(eventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventsSplitPane, -1, -1, Short.MAX_VALUE));
        eventsPanelLayout.setVerticalGroup(eventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventsSplitPane, GroupLayout.Alignment.TRAILING, -1, 312, Short.MAX_VALUE));
        this.familyTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.eventsPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/event.png")), this.eventsPanel);
        GroupLayout childrenPanelLayout = new GroupLayout(this.childrenPanel);
        this.childrenPanel.setLayout(childrenPanelLayout);
        childrenPanelLayout.setHorizontalGroup(childrenPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.childrenTreeTablePanel, -1, -1, Short.MAX_VALUE));
        childrenPanelLayout.setVerticalGroup(childrenPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.childrenTreeTablePanel, -1, -1, Short.MAX_VALUE));
        this.familyTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.childrenPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/child.png")), this.childrenPanel);
        this.sourceCitationsTablePanel.setPreferredSize(null);
        GroupLayout sourcesPanelLayout = new GroupLayout(this.sourcesPanel);
        this.sourcesPanel.setLayout(sourcesPanelLayout);
        sourcesPanelLayout.setHorizontalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        sourcesPanelLayout.setVerticalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.familyTabbedPane.addTab(NbBundle.getMessage(FamilyEditor.class, (String)"FamilyEditor.sourcesPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/source.png")), this.sourcesPanel);
        GroupLayout notesPanelLayout = new GroupLayout(this.notesPanel);
        this.notesPanel.setLayout(notesPanelLayout);
        notesPanelLayout.setHorizontalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        notesPanelLayout.setVerticalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.familyTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.notesPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/note.png")), this.notesPanel);
        GroupLayout galleryPanelLayout = new GroupLayout(this.galleryPanel);
        this.galleryPanel.setLayout(galleryPanelLayout);
        galleryPanelLayout.setHorizontalGroup(galleryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        galleryPanelLayout.setVerticalGroup(galleryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.familyTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("FamilyEditor.galleryPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/media.png")), this.galleryPanel);
        this.changeDateLabel.setHorizontalAlignment(2);
        this.changeDateLabel.setText(NbBundle.getMessage(FamilyEditor.class, (String)"FamilyEditor.changeDateLabel.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familyTabbedPane, -1, 657, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.fatherPanel, -1, 325, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.motherPanel, -1, 326, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.changeDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeDateLabeldate, -1, -1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.motherPanel, -1, -1, Short.MAX_VALUE).addComponent(this.fatherPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.familyTabbedPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.changeDateLabel).addComponent(this.changeDateLabeldate, -2, 15, -2))));
    }

    private void addHusbandButtonActionPerformed(ActionEvent evt) {
        block21: {
            try {
                this.mFamily.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        FamilyEditor.this.mHusband = (Indi)gedcom.createEntity("INDI");
                        FamilyEditor.this.mHusband.setSex(1);
                    }
                });
                final IndividualEditor individualEditor = new IndividualEditor();
                individualEditor.setContext(new Context((Entity)this.mHusband));
                DialogManager.ADialog individualEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.create.husband.title"), (JComponent)((Object)individualEditor));
                individualEditorDialog.setDialogId(IndividualEditor.class.getName());
                if (individualEditorDialog.show() == DialogDescriptor.OK_OPTION) {
                    try {
                        this.mFamily.getGedcom().doUnitOfWork(new UnitOfWork(){

                            public void perform(Gedcom gedcom) throws GedcomException {
                                individualEditor.commit();
                            }
                        });
                    }
                    catch (GedcomException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    this.mFamily.getGedcom().doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            FamilyEditor.this.mFamily.setHusband(FamilyEditor.this.mHusband);
                        }
                    });
                    this.husbandNameTextField.setText(" " + this.mHusband.getName());
                    this.husbandBirthDateLabelDate.setText(this.mHusband.getBirthAsString());
                    this.husbandDeathDateLabelDate.setText(this.mHusband.getDeathAsString());
                    Property[] propertyArray = this.mHusband.getProperties("OBJE");
                    int n = propertyArray.length;
                    int n2 = 0;
                    if (n2 < n) {
                        Property propertyFormat;
                        Property propertyFile;
                        Property multiMediaObject = propertyArray[n2];
                        String objetFormat = null;
                        InputSource file = null;
                        if (this.mFamily.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                            if (multiMediaObject instanceof PropertyMedia) {
                                propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                                if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                    file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                    propertyFormat = propertyFile.getProperty("FORM");
                                    if (propertyFormat != null) {
                                        objetFormat = propertyFormat.getValue();
                                    }
                                }
                            } else {
                                propertyFile = multiMediaObject.getProperty("FILE");
                                if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                    file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                    propertyFormat = propertyFile.getProperty("FORM");
                                    if (propertyFormat != null) {
                                        objetFormat = propertyFormat.getValue();
                                    }
                                }
                            }
                        } else if (multiMediaObject instanceof PropertyMedia) {
                            propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                            }
                            if ((propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FORM")) != null) {
                                objetFormat = propertyFormat.getValue();
                            }
                        } else {
                            propertyFile = multiMediaObject.getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                            }
                            if ((propertyFormat = multiMediaObject.getProperty("FORM")) != null) {
                                objetFormat = propertyFormat.getValue();
                            }
                        }
                        boolean correct = this.husbandImageBean.setImage(file, this.mHusband.getSex());
                        if (!correct) {
                            String title = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType");
                            String text = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType.notSupported");
                            DialogManager.create((String)title, (String)text).setMessageType(2).setOptionType(10).setDialogId("ancestris.aries.error").show();
                        }
                    }
                    this.addHusbandButton.setVisible(false);
                    this.linkToHusbandButton.setVisible(false);
                    this.removeHusbandButton.setVisible(true);
                    this.editHusbandButton.setVisible(true);
                    break block21;
                }
                this.mFamily.getGedcom().undoUnitOfWork(false);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void addWifeButtonActionPerformed(ActionEvent evt) {
        block21: {
            try {
                this.mFamily.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        FamilyEditor.this.mWife = (Indi)gedcom.createEntity("INDI");
                        FamilyEditor.this.mWife.setSex(2);
                    }
                });
                final IndividualEditor individualEditor = new IndividualEditor();
                individualEditor.setContext(new Context((Entity)this.mWife));
                DialogManager.ADialog individualEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.create.wife.title"), (JComponent)((Object)individualEditor));
                individualEditorDialog.setDialogId(IndividualEditor.class.getName());
                if (individualEditorDialog.show() == DialogDescriptor.OK_OPTION) {
                    try {
                        this.mFamily.getGedcom().doUnitOfWork(new UnitOfWork(){

                            public void perform(Gedcom gedcom) throws GedcomException {
                                individualEditor.commit();
                            }
                        });
                    }
                    catch (GedcomException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    this.mFamily.getGedcom().doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            FamilyEditor.this.mFamily.setWife(FamilyEditor.this.mWife);
                        }
                    });
                    this.wifeNameTextField.setText(" " + this.mWife.getName());
                    this.wifeBirthDateLabelDate.setText(this.mWife.getBirthAsString());
                    this.wifeDeathDateLabelDate.setText(this.mWife.getDeathAsString());
                    Property[] propertyArray = this.mWife.getProperties("OBJE");
                    int n = propertyArray.length;
                    int n2 = 0;
                    if (n2 < n) {
                        Property propertyFormat;
                        Property propertyFile;
                        Property multiMediaObject = propertyArray[n2];
                        String objetFormat = null;
                        InputSource file = null;
                        if (this.mFamily.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                            if (multiMediaObject instanceof PropertyMedia) {
                                propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                                if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                    file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                    propertyFormat = propertyFile.getProperty("FORM");
                                    if (propertyFormat != null) {
                                        objetFormat = propertyFormat.getValue();
                                    }
                                }
                            } else {
                                propertyFile = multiMediaObject.getProperty("FILE");
                                if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                    file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                    propertyFormat = propertyFile.getProperty("FORM");
                                    if (propertyFormat != null) {
                                        objetFormat = propertyFormat.getValue();
                                    }
                                }
                            }
                        } else if (multiMediaObject instanceof PropertyMedia) {
                            propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                            }
                            if ((propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FORM")) != null) {
                                objetFormat = propertyFormat.getValue();
                            }
                        } else {
                            propertyFile = multiMediaObject.getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                            }
                            if ((propertyFormat = multiMediaObject.getProperty("FORM")) != null) {
                                objetFormat = propertyFormat.getValue();
                            }
                        }
                        boolean correct = this.wifeImageBean.setImage(file, this.mWife.getSex());
                        if (!correct) {
                            String title = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType");
                            String text = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType.notSupported");
                            DialogManager.create((String)title, (String)text).setMessageType(2).setOptionType(10).setDialogId("ancestris.aries.error").show();
                        }
                    }
                    this.addWifeButton.setVisible(false);
                    this.linkToWifeButton.setVisible(false);
                    this.removeWifeButton.setVisible(true);
                    this.editWifeButton.setVisible(true);
                    break block21;
                }
                this.mFamily.getGedcom().undoUnitOfWork(false);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void linkToHusbandButtonActionPerformed(ActionEvent evt) {
        ArrayList<Indi> individualsList = new ArrayList<Indi>();
        for (Indi individual : this.mFamily.getGedcom().getIndis()) {
            if (individual.getSex() != 1 && individual.getSex() != 0) continue;
            individualsList.add(individual);
        }
        IndividualsTablePanel individualsTablePanel = new IndividualsTablePanel((Property)this.mFamily, individualsList);
        individualsTablePanel.setToolBarVisible(false);
        DialogManager.ADialog individualsTableDialog = new DialogManager.ADialog(NbBundle.getMessage(IndividualsTablePanel.class, (String)"individualsTableDialog.title.select.husband"), (JComponent)individualsTablePanel);
        individualsTableDialog.setDialogId(IndividualsTablePanel.class.getName());
        if (individualsTableDialog.show() == DialogDescriptor.OK_OPTION) {
            this.mHusband = individualsTablePanel.getSelectedIndividual();
            try {
                this.mFamily.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        FamilyEditor.this.mFamily.setHusband(FamilyEditor.this.mHusband);
                    }
                });
                this.husbandNameTextField.setText(" " + this.mHusband.getName());
                this.husbandBirthDateLabelDate.setText(this.mHusband.getBirthAsString());
                this.husbandDeathDateLabelDate.setText(this.mHusband.getDeathAsString());
                Property[] propertyArray = this.mHusband.getProperties("OBJE");
                int n = propertyArray.length;
                int n2 = 0;
                if (n2 < n) {
                    Property propertyFormat;
                    Property propertyFile;
                    Property multiMediaObject = propertyArray[n2];
                    String objetFormat = null;
                    InputSource file = null;
                    if (this.mFamily.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                        if (multiMediaObject instanceof PropertyMedia) {
                            propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                propertyFormat = propertyFile.getProperty("FORM");
                                if (propertyFormat != null) {
                                    objetFormat = propertyFormat.getValue();
                                }
                            }
                        } else {
                            propertyFile = multiMediaObject.getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                propertyFormat = propertyFile.getProperty("FORM");
                                if (propertyFormat != null) {
                                    objetFormat = propertyFormat.getValue();
                                }
                            }
                        }
                    } else if (multiMediaObject instanceof PropertyMedia) {
                        propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                        }
                        if ((propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FORM")) != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    } else {
                        propertyFile = multiMediaObject.getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                        }
                        if ((propertyFormat = multiMediaObject.getProperty("FORM")) != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    }
                    boolean correct = this.husbandImageBean.setImage(file, this.mHusband.getSex());
                    if (!correct) {
                        String title = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType");
                        String text = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType.notSupported");
                        DialogManager.create((String)title, (String)text).setMessageType(2).setOptionType(10).setDialogId("ancestris.aries.error").show();
                    }
                }
                this.addHusbandButton.setVisible(false);
                this.linkToHusbandButton.setVisible(false);
                this.removeHusbandButton.setVisible(true);
                this.editHusbandButton.setVisible(true);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        individualsTablePanel.saveFilterSettings();
    }

    private void linkToWifeButtonActionPerformed(ActionEvent evt) {
        ArrayList<Indi> individualsList = new ArrayList<Indi>();
        for (Indi individual : this.mFamily.getGedcom().getIndis()) {
            if (individual.getSex() != 2 && individual.getSex() != 0) continue;
            individualsList.add(individual);
        }
        IndividualsTablePanel individualsTablePanel = new IndividualsTablePanel((Property)this.mFamily, individualsList);
        individualsTablePanel.setToolBarVisible(false);
        DialogManager.ADialog individualsTableDialog = new DialogManager.ADialog(NbBundle.getMessage(IndividualsTablePanel.class, (String)"individualsTableDialog.title.select.wife"), (JComponent)individualsTablePanel);
        individualsTableDialog.setDialogId(IndividualsTablePanel.class.getName());
        if (individualsTableDialog.show() == DialogDescriptor.OK_OPTION) {
            this.mWife = individualsTablePanel.getSelectedIndividual();
            try {
                this.mFamily.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        FamilyEditor.this.mFamily.setWife(FamilyEditor.this.mWife);
                    }
                });
                this.wifeNameTextField.setText(" " + this.mWife.getName());
                this.wifeBirthDateLabelDate.setText(this.mWife.getBirthAsString());
                this.wifeDeathDateLabelDate.setText(this.mWife.getDeathAsString());
                Property[] propertyArray = this.mWife.getProperties("OBJE");
                int n = propertyArray.length;
                int n2 = 0;
                if (n2 < n) {
                    Property propertyFormat;
                    Property propertyFile;
                    Property multiMediaObject = propertyArray[n2];
                    String objetFormat = null;
                    InputSource file = null;
                    if (this.mFamily.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                        if (multiMediaObject instanceof PropertyMedia) {
                            propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                propertyFormat = propertyFile.getProperty("FORM");
                                if (propertyFormat != null) {
                                    objetFormat = propertyFormat.getValue();
                                }
                            }
                        } else {
                            propertyFile = multiMediaObject.getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                propertyFormat = propertyFile.getProperty("FORM");
                                if (propertyFormat != null) {
                                    objetFormat = propertyFormat.getValue();
                                }
                            }
                        }
                    } else if (multiMediaObject instanceof PropertyMedia) {
                        propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                        }
                        if ((propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FORM")) != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    } else {
                        propertyFile = multiMediaObject.getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                        }
                        if ((propertyFormat = multiMediaObject.getProperty("FORM")) != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    }
                    boolean correct = this.wifeImageBean.setImage(file, this.mWife.getSex());
                    if (!correct) {
                        String title = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType");
                        String text = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType.notSupported");
                        DialogManager.create((String)title, (String)text).setMessageType(2).setOptionType(10).setDialogId("ancestris.aries.error").show();
                    }
                }
                this.addWifeButton.setVisible(false);
                this.linkToWifeButton.setVisible(false);
                this.removeWifeButton.setVisible(true);
                this.editWifeButton.setVisible(true);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        individualsTablePanel.saveFilterSettings();
    }

    private void editHusbandButtonActionPerformed(ActionEvent evt) {
        block16: {
            Indi individual = this.mFamily.getHusband();
            Gedcom gedcom = this.mFamily.getGedcom();
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)individual));
            if (!individualEditor.showPanel()) break block16;
            this.husbandNameTextField.setText(" " + this.mHusband.getName());
            this.husbandBirthDateLabelDate.setText(this.mHusband.getBirthAsString());
            this.husbandDeathDateLabelDate.setText(this.mHusband.getDeathAsString());
            Property[] propertyArray = this.mHusband.getProperties("OBJE");
            int n = propertyArray.length;
            int n2 = 0;
            if (n2 < n) {
                Property propertyFormat;
                Property propertyFile;
                Property multiMediaObject = propertyArray[n2];
                String objetFormat = null;
                InputSource file = null;
                if (this.mFamily.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                    if (multiMediaObject instanceof PropertyMedia) {
                        propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                            propertyFormat = propertyFile.getProperty("FORM");
                            if (propertyFormat != null) {
                                objetFormat = propertyFormat.getValue();
                            }
                        }
                    } else {
                        propertyFile = multiMediaObject.getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                            propertyFormat = propertyFile.getProperty("FORM");
                            if (propertyFormat != null) {
                                objetFormat = propertyFormat.getValue();
                            }
                        }
                    }
                } else if (multiMediaObject instanceof PropertyMedia) {
                    propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                    if (propertyFile != null && propertyFile instanceof PropertyFile) {
                        file = ((PropertyFile)propertyFile).getInput().orElse(null);
                    }
                    if ((propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FORM")) != null) {
                        objetFormat = propertyFormat.getValue();
                    }
                } else {
                    propertyFile = multiMediaObject.getProperty("FILE");
                    if (propertyFile != null && propertyFile instanceof PropertyFile) {
                        file = ((PropertyFile)propertyFile).getInput().orElse(null);
                    }
                    if ((propertyFormat = multiMediaObject.getProperty("FORM")) != null) {
                        objetFormat = propertyFormat.getValue();
                    }
                }
                boolean correct = this.husbandImageBean.setImage(file, this.mHusband.getSex());
                if (!correct) {
                    String title = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType");
                    String text = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType.notSupported");
                    DialogManager.create((String)title, (String)text).setMessageType(2).setOptionType(10).setDialogId("ancestris.aries.error").show();
                }
            }
        }
    }

    private void editWifeButtonActionPerformed(ActionEvent evt) {
        block16: {
            Indi individual = this.mFamily.getWife();
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)individual));
            if (!individualEditor.showPanel()) break block16;
            this.wifeNameTextField.setText(" " + this.mWife.getName());
            this.wifeBirthDateLabelDate.setText(this.mWife.getBirthAsString());
            this.wifeDeathDateLabelDate.setText(this.mWife.getDeathAsString());
            Property[] propertyArray = this.mWife.getProperties("OBJE");
            int n = propertyArray.length;
            int n2 = 0;
            if (n2 < n) {
                Property propertyFormat;
                Property propertyFile;
                Property multiMediaObject = propertyArray[n2];
                String objetFormat = null;
                InputSource file = null;
                if (this.mFamily.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                    if (multiMediaObject instanceof PropertyMedia) {
                        propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                            propertyFormat = propertyFile.getProperty("FORM");
                            if (propertyFormat != null) {
                                objetFormat = propertyFormat.getValue();
                            }
                        }
                    } else {
                        propertyFile = multiMediaObject.getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                            propertyFormat = propertyFile.getProperty("FORM");
                            if (propertyFormat != null) {
                                objetFormat = propertyFormat.getValue();
                            }
                        }
                    }
                } else if (multiMediaObject instanceof PropertyMedia) {
                    propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                    if (propertyFile != null && propertyFile instanceof PropertyFile) {
                        file = ((PropertyFile)propertyFile).getInput().orElse(null);
                    }
                    if ((propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FORM")) != null) {
                        objetFormat = propertyFormat.getValue();
                    }
                } else {
                    propertyFile = multiMediaObject.getProperty("FILE");
                    if (propertyFile != null && propertyFile instanceof PropertyFile) {
                        file = ((PropertyFile)propertyFile).getInput().orElse(null);
                    }
                    if ((propertyFormat = multiMediaObject.getProperty("FORM")) != null) {
                        objetFormat = propertyFormat.getValue();
                    }
                }
                boolean correct = this.wifeImageBean.setImage(file, this.mWife.getSex());
                if (!correct) {
                    String title = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType");
                    String text = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType.notSupported");
                    DialogManager.create((String)title, (String)text).setMessageType(2).setOptionType(10).setDialogId("ancestris.aries.error").show();
                }
            }
        }
    }

    private void removeHusbandButtonActionPerformed(ActionEvent evt) {
        DialogManager createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(FamilyEditor.class, (String)"FamilyEditor.deleteHusbandConfirmation.title"), (String)NbBundle.getMessage(FamilyEditor.class, (String)"FamilyEditor.deleteHusbandConfirmation.text", (Object)this.mFamily.getHusband()));
        if (createYesNo.show() == DialogManager.YES_OPTION) {
            try {
                this.mFamily.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        FamilyEditor.this.mFamily.setHusband(null);
                    }
                });
                this.husbandNameTextField.setText("");
                this.husbandBirthDateLabelDate.setText("");
                this.husbandDeathDateLabelDate.setText("");
                this.husbandImageBean.setImage(null, 1);
                this.addHusbandButton.setVisible(true);
                this.linkToHusbandButton.setVisible(true);
                this.removeHusbandButton.setVisible(false);
                this.editHusbandButton.setVisible(false);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void removeWifeButtonActionPerformed(ActionEvent evt) {
        DialogManager createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(FamilyEditor.class, (String)"FamilyEditor.deleteWifeConfirmation.title"), (String)NbBundle.getMessage(FamilyEditor.class, (String)"FamilyEditor.deleteWifeConfirmation.text", (Object)this.mFamily.getWife()));
        if (createYesNo.show() == DialogManager.YES_OPTION) {
            try {
                this.mFamily.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        FamilyEditor.this.mFamily.setWife(null);
                    }
                });
                this.wifeNameTextField.setText("");
                this.wifeBirthDateLabelDate.setText("");
                this.wifeDeathDateLabelDate.setText("");
                this.wifeImageBean.setImage(null, 2);
                this.addWifeButton.setVisible(true);
                this.linkToWifeButton.setVisible(true);
                this.removeWifeButton.setVisible(false);
                this.editWifeButton.setVisible(false);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void eventTypeComboBoxActionPerformed(ActionEvent evt) {
        if (!this.updateOnGoing) {
            Gedcom gedcom = this.mFamily.getGedcom();
            this.mEvent = null;
            if (this.eventTypeComboBox.getSelectedIndex() > 0) {
                final String eventType = this.eventTypeComboBox.getSelectedItem().toString();
                try {
                    gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            FamilyEditor.this.mEvent = FamilyEditor.this.mFamily.addProperty(PropertyTag2Name.getPropertyTag(eventType), "");
                            Logger.getLogger("ancestris").info(FamilyEditor.this.mEvent.getTag());
                            if (!FamilyEditor.this.mEvent.getTag().equals("EVEN")) {
                                FamilyEditor.this.mEvent.setValue("Y");
                            }
                        }
                    });
                    if (this.mEvent != null) {
                        ArrayList<Property> eventsProperties = new ArrayList<Property>();
                        for (Property property : this.mFamily.getProperties()) {
                            if (!this.mFamilyEventsTags.contains(property.getTag())) continue;
                            eventsProperties.add(property);
                        }
                        this.seteventTypeComboBox(eventsProperties);
                        if (this.mEventsListModel.indexOf(this.mEvent) == -1) {
                            this.mEventsListModel.add(this.mEvent);
                        }
                        this.selectedEventContext = new Context(this.mEvent);
                        this.eventsList.setSelectedIndex(this.mEventsListModel.indexOf(this.mEvent));
                        this.changes.fireChangeEvent();
                    }
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void deleteEventButtonActionPerformed(ActionEvent evt) {
        Property event;
        DialogManager createYesNo;
        final int index = this.eventsList.getSelectedIndex();
        Gedcom gedcom = this.mFamily.getGedcom();
        if (index != -1 && (createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(FamilyEditor.class, (String)"FamilyEditor.eventsList.deleteEventConfirmation.title", (Object)PropertyTag2Name.getTagName((event = this.mEventsListModel.getValueAt(index)).getTag())), (String)NbBundle.getMessage(FamilyEditor.class, (String)"FamilyEditor.eventsList.deleteEventConfirmation.text", (Object)PropertyTag2Name.getTagName(event.getTag()), (Object)this.mFamily))).show() == DialogManager.YES_OPTION) {
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        if (index >= 0 && index < FamilyEditor.this.mEventsListModel.getSize()) {
                            FamilyEditor.this.mFamily.delProperty(FamilyEditor.this.mEventsListModel.remove(index));
                        }
                    }
                });
                ArrayList<Property> eventsProperties = new ArrayList<Property>();
                for (Property property : this.mFamily.getProperties()) {
                    if (!this.mFamilyEventsTags.contains(property.getTag())) continue;
                    eventsProperties.add(property);
                }
                this.seteventTypeComboBox(eventsProperties);
                this.eventsList.setSelectedIndex(0);
                this.changes.fireChangeEvent();
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void eventsListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            return;
        }
        int index = this.eventsList.getSelectedIndex();
        if (index != -1 && index < this.mEventsListModel.getSize()) {
            Property prop = this.mEventsListModel.getValueAt(index);
            this.selectedEventContext = new Context(prop);
        }
    }

    private void husbandNameTextFieldActionPerformed(ActionEvent evt) {
    }

    private void eventsSplitPanePropertyChange(PropertyChangeEvent evt) {
        this.registry.put("ariesfamilyeventSplitDividerLocation", this.eventsSplitPane.getDividerLocation());
    }

    public Component getEditorComponent() {
        return this;
    }

    protected String getTitleImpl() {
        if (this.context == null || this.context.getEntity() == null) {
            return "";
        }
        return new ViewContext(this.context.getEntity()).getText();
    }

    public ViewContext getContext() {
        return new ViewContext(this.context);
    }

    protected void setContextImpl(Context context) {
        this.context = context;
        Entity entity = context.getEntity();
        if (entity != null && entity instanceof Fam && entity.getGedcom() != null) {
            Property propertyFormat;
            Property propertyFile;
            InputSource file;
            String objetFormat;
            Property multiMediaObject;
            int n;
            int n2;
            Property[] propertyArray;
            Property prop;
            this.mFamily = (Fam)entity;
            this.setTitle(NbBundle.getMessage(FamilyEditor.class, (String)(this.isNew() ? "FamilyEditor.create.title" : "FamilyEditor.edit.title"), (Object)this.mFamily.getDisplayTitle(false)));
            if (!this.mFamily.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                this.privateRecordToggleButton.setVisible(false);
            }
            this.familyIDTextField.setText(this.mFamily.getId());
            Property restrictionNotice = this.mFamily.getProperty("RESN", true);
            if (restrictionNotice != null) {
                this.privateRecordToggleButton.setSelected(true);
            }
            ArrayList<Property> familyEvents = new ArrayList<Property>();
            for (Property property : this.mFamily.getProperties()) {
                if (!this.mFamilyEventsTags.contains(property.getTag())) continue;
                familyEvents.add(property);
            }
            Collections.sort(familyEvents, new Comparator<Property>(){

                @Override
                public int compare(Property p1, Property p2) {
                    PropertyDate pDate1 = (PropertyDate)p1.getProperty("DATE");
                    PropertyDate pDate2 = (PropertyDate)p2.getProperty("DATE");
                    if (pDate1 == null && pDate2 == null) {
                        return 0;
                    }
                    if (pDate1 != null && pDate2 == null) {
                        return 1;
                    }
                    if (pDate1 == null && pDate2 != null) {
                        return -1;
                    }
                    return pDate1.compareTo((Property)pDate2);
                }
            });
            this.familyEventPanel.setVisible(false);
            this.changeListInProgress = true;
            this.mEventsListModel.clear();
            this.mEventsListModel.addAll(familyEvents);
            this.seteventTypeComboBox(familyEvents);
            int index = 0;
            Property property = prop = this.selectedEventContext == null ? context.getProperty() : this.selectedEventContext.getProperty();
            if (prop != null && (index = this.mEventsListModel.indexOf(prop)) == -1) {
                index = 0;
            }
            this.eventsList.setSelectedIndex(index);
            this.changeListInProgress = false;
            this.mHusband = this.mFamily.getHusband();
            if (this.mHusband != null) {
                this.husbandNameTextField.setText(" " + this.mHusband.getName());
                this.husbandBirthDateLabelDate.setText(this.mHusband.getBirthAsString());
                this.husbandDeathDateLabelDate.setText(this.mHusband.getDeathAsString());
                InputSource selectedFile = null;
                propertyArray = this.mHusband.getProperties("OBJE");
                n2 = propertyArray.length;
                n = 0;
                if (n < n2) {
                    multiMediaObject = propertyArray[n];
                    objetFormat = null;
                    file = null;
                    if (this.mFamily.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                        if (multiMediaObject instanceof PropertyMedia) {
                            propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                propertyFormat = propertyFile.getProperty("FORM");
                                if (propertyFormat != null) {
                                    objetFormat = propertyFormat.getValue();
                                }
                            }
                        } else {
                            propertyFile = multiMediaObject.getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                propertyFormat = propertyFile.getProperty("FORM");
                                if (propertyFormat != null) {
                                    objetFormat = propertyFormat.getValue();
                                }
                            }
                        }
                    } else if (multiMediaObject instanceof PropertyMedia) {
                        propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                        }
                        if ((propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FORM")) != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    } else {
                        propertyFile = multiMediaObject.getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                        }
                        if ((propertyFormat = multiMediaObject.getProperty("FORM")) != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    }
                    selectedFile = file;
                }
                this.husbandImageBean.setImage(selectedFile, this.mHusband.getSex());
                this.addHusbandButton.setVisible(false);
                this.linkToHusbandButton.setVisible(false);
                this.removeHusbandButton.setVisible(true);
                this.editHusbandButton.setVisible(true);
            } else {
                this.addHusbandButton.setVisible(true);
                this.linkToHusbandButton.setVisible(true);
                this.removeHusbandButton.setVisible(false);
                this.editHusbandButton.setVisible(false);
                this.husbandImageBean.setImage(null, 1);
            }
            this.mWife = this.mFamily.getWife();
            if (this.mWife != null) {
                this.wifeNameTextField.setText(" " + this.mWife.getName());
                this.wifeBirthDateLabelDate.setText(this.mWife.getBirthAsString());
                this.wifeDeathDateLabelDate.setText(this.mWife.getDeathAsString());
                InputSource selectedFile = null;
                propertyArray = this.mWife.getProperties("OBJE");
                n2 = propertyArray.length;
                n = 0;
                if (n < n2) {
                    multiMediaObject = propertyArray[n];
                    objetFormat = null;
                    file = null;
                    if (this.mFamily.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                        if (multiMediaObject instanceof PropertyMedia) {
                            propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                propertyFormat = propertyFile.getProperty("FORM");
                                if (propertyFormat != null) {
                                    objetFormat = propertyFormat.getValue();
                                }
                            }
                        } else {
                            propertyFile = multiMediaObject.getProperty("FILE");
                            if (propertyFile != null && propertyFile instanceof PropertyFile) {
                                file = ((PropertyFile)propertyFile).getInput().orElse(null);
                                propertyFormat = propertyFile.getProperty("FORM");
                                if (propertyFormat != null) {
                                    objetFormat = propertyFormat.getValue();
                                }
                            }
                        }
                    } else if (multiMediaObject instanceof PropertyMedia) {
                        propertyFile = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                        }
                        if ((propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FORM")) != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    } else {
                        propertyFile = multiMediaObject.getProperty("FILE");
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            file = ((PropertyFile)propertyFile).getInput().orElse(null);
                        }
                        if ((propertyFormat = multiMediaObject.getProperty("FORM")) != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    }
                    selectedFile = file;
                }
                this.wifeImageBean.setImage(selectedFile, this.mWife.getSex());
                this.addWifeButton.setVisible(false);
                this.linkToWifeButton.setVisible(false);
                this.removeWifeButton.setVisible(true);
                this.editWifeButton.setVisible(true);
            } else {
                this.wifeImageBean.setImage(null, 2);
                this.addWifeButton.setVisible(true);
                this.linkToWifeButton.setVisible(true);
                this.removeWifeButton.setVisible(false);
                this.editWifeButton.setVisible(false);
            }
            this.childrenTreeTablePanel.set((Property)this.mFamily, this.mFamily.getProperties(PropertyChild.class));
            Property changeDate = this.mFamily.getProperty("CHAN");
            if (changeDate != null) {
                this.changeDateLabeldate.setText(((PropertyChange)changeDate).getDisplayValue());
            }
            this.sourceCitationsTablePanel.set((Property)this.mFamily, Arrays.asList(this.mFamily.getProperties("SOUR")));
            this.noteCitationsTablePanel.set((Property)this.mFamily, Arrays.asList(this.mFamily.getProperties("NOTE")));
            this.multimediaObjectCitationsTablePanel.set((Property)this.mFamily, Arrays.asList(this.mFamily.getProperties("OBJE")));
        }
    }

    public void commit() throws GedcomException {
        Property restrictionNotice = this.mFamily.getProperty("RESN", true);
        if (this.privateRecordToggleButton.isSelected()) {
            if (restrictionNotice == null) {
                this.mFamily.addProperty("RESN", "confidential");
            }
        } else if (restrictionNotice != null) {
            this.mFamily.delProperty(restrictionNotice);
        }
        this.familyEventPanel.commit();
    }

    private void seteventTypeComboBox(List<Property> eventsList) {
        ArrayList<String> localizedEventsList = new ArrayList<String>();
        for (String tag2 : this.mFamilyEventsTags) {
            if (!this.mFamily.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                if (tag2.equals("RESI")) continue;
                localizedEventsList.add(PropertyTag2Name.getTagName(tag2));
                continue;
            }
            localizedEventsList.add(PropertyTag2Name.getTagName(tag2));
        }
        Collections.sort(localizedEventsList);
        this.updateOnGoing = true;
        this.mEventsModel.removeAllElements();
        this.mEventsModel.addElement(NbBundle.getMessage(IndividualEditor.class, (String)"FamilyEditor.eventTypeComboBox.firstElement.title"));
        localizedEventsList.forEach(tag -> this.mEventsModel.addElement((String)tag));
        this.updateOnGoing = false;
    }

    public Entity getEditedEntity() {
        return this.mFamily;
    }

    private class EventsListSelectionHandler
    implements ListSelectionListener {
        private EventsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            ListSelectionModel lsm = (ListSelectionModel)lse.getSource();
            if (!lse.getValueIsAdjusting() && !lsm.isSelectionEmpty()) {
                AriesTopComponent etc;
                if (!FamilyEditor.this.changeListInProgress && FamilyEditor.this.familyEventPanel.hasChanged() && (etc = AriesTopComponent.findEditorWindow(FamilyEditor.this.mFamily.getGedcom())) != null) {
                    etc.commit();
                }
                if (lsm.getMinSelectionIndex() < FamilyEditor.this.mEventsListModel.getSize()) {
                    FamilyEditor.this.familyEventPanel.set((Property)FamilyEditor.this.mFamily, FamilyEditor.this.mEventsListModel.getValueAt(lsm.getMinSelectionIndex()));
                    FamilyEditor.this.familyEventPanel.setVisible(true);
                }
            }
        }
    }
}

