/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import ancestris.modules.editors.genealogyeditor.utilities.PropertyTag2Name;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class EventsTableModel
extends AbstractTableModel {
    private final ArrayList<String> mIndividualAttributesTags = new ArrayList<String>(){
        {
            this.add("CAST");
            this.add("DSCR");
            this.add("EDUC");
            this.add("IDNO");
            this.add("NATI");
            this.add("NCHI");
            this.add("NMR");
            this.add("OCCU");
            this.add("PROP");
            this.add("RELI");
            this.add("RESI");
            this.add("SSN");
            this.add("TITL");
        }
    };
    List<Property> eventsList = new ArrayList<Property>();
    String[] columnsName = new String[]{NbBundle.getMessage(EventsTableModel.class, (String)"EventsTableModel.column.ID.eventType"), NbBundle.getMessage(EventsTableModel.class, (String)"EventsTableModel.column.ID.place"), NbBundle.getMessage(EventsTableModel.class, (String)"EventsTableModel.column.ID.date")};

    @Override
    public int getRowCount() {
        return this.eventsList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.eventsList.size()) {
            Property propertyEvent = this.eventsList.get(row);
            switch (column) {
                case 0: {
                    if (propertyEvent.getTag().equals("EVEN") || propertyEvent.getTag().equals("FACT")) {
                        Property eventType = propertyEvent.getProperty("TYPE");
                        return eventType != null ? eventType.getValue() : "";
                    }
                    if (this.mIndividualAttributesTags.contains(propertyEvent.getTag())) {
                        return PropertyTag2Name.getTagName(propertyEvent.getTag()) + " " + propertyEvent.getValue();
                    }
                    return PropertyTag2Name.getTagName(propertyEvent.getTag());
                }
                case 1: {
                    PropertyPlace place = (PropertyPlace)propertyEvent.getProperty("PLAC");
                    if (place != null) {
                        return place.format("all");
                    }
                    Property address = propertyEvent.getProperty("ADDR");
                    if (address != null) {
                        return address.getValue();
                    }
                    return "";
                }
                case 2: {
                    Property date = propertyEvent.getProperty("DATE");
                    return date != null ? date : new PropertyDate();
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    public void addAll(List<Property> eventsList) {
        this.eventsList.addAll(eventsList);
        this.fireTableDataChanged();
    }

    public void add(Property event) {
        this.eventsList.add(event);
        this.fireTableDataChanged();
    }

    public int indexOf(Property event) {
        return this.eventsList.indexOf(event);
    }

    public Property getValueAt(int row) {
        return this.eventsList.get(row);
    }

    public Property remove(int row) {
        Property event = this.eventsList.remove(row);
        this.fireTableDataChanged();
        return event;
    }

    public void clear() {
        this.eventsList.clear();
        this.fireTableDataChanged();
    }
}

