/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.geneanet;

import ancestris.gedcom.GedcomMgr;
import ancestris.gedcom.SaveOptionsWidget;
import ancestris.modules.exports.geneanet.FilterAssociationOption;
import ancestris.modules.exports.geneanet.FilterPlaceOption;
import ancestris.modules.exports.geneanet.GeneanetExportAction;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAlias;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertyXRef;
import genj.io.Filter;
import genj.io.GedcomReader;
import genj.io.GedcomReaderContext;
import genj.io.GedcomReaderFactory;
import genj.util.DirectAccessTokenizer;
import genj.util.Origin;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import spin.Spin;

public class GeneanetExport {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private final Gedcom gedcom;
    private Gedcom copyGedcom;
    private final SaveOptionsWidget options;
    private final File exportFile;

    GeneanetExport(Gedcom gedcom, File exportFile, SaveOptionsWidget options) {
        this.gedcom = gedcom;
        this.options = options;
        this.exportFile = exportFile;
    }

    public boolean execute() {
        boolean ok;
        LOG.log(Level.INFO, "{0} {1}", new Object[]{NbBundle.getMessage(GeneanetExportAction.class, (String)"GeneanetExportAction.TabTitle"), this.gedcom.getName()});
        LOG.log(Level.INFO, String.format(NbBundle.getMessage(GeneanetExportAction.class, (String)"GeneanetExportAction.Start"), this.gedcom.getName()));
        Origin pOrigin = this.gedcom.getOrigin();
        try {
            Origin nOrigin = Origin.create((URL)this.exportFile.toURI().toURL());
            this.gedcom.setOrigin(nOrigin);
            ok = GedcomMgr.getDefault().saveGedcomImpl(this.gedcom, this.options.getFilters(), null, this.options.getSort());
            this.gedcom.setOrigin(pOrigin);
        }
        catch (IOException e) {
            ok = false;
            LOG.log(Level.INFO, "Can't create new file ", e);
        }
        if (ok) {
            Context context = this.openGedcomQuietly(FileUtil.toFileObject((File)this.exportFile), this.gedcom.getPassword());
            boolean bl = ok = context != null;
            if (ok) {
                this.copyGedcom = context.getGedcom();
            }
        }
        if (ok && this.copyGedcom != null) {
            try {
                ok = this.convertAssociations(this.copyGedcom);
                ok &= this.convertOther(this.copyGedcom);
                ok &= this.convertHeader(this.copyGedcom);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error during Geneanet conversion", e);
                ok = false;
            }
        }
        if (ok) {
            File[] foundFiles;
            ok = GedcomMgr.getDefault().saveGedcomImpl(this.copyGedcom, null, null, false);
            String str = this.copyGedcom.getName().replace(".ged", "") + "_";
            File dir = new File(this.exportFile.getParent());
            for (File file : foundFiles = dir.listFiles((dir1, name) -> name.startsWith(str))) {
                file.delete();
            }
        }
        LOG.log(Level.INFO, "====================");
        LOG.log(Level.INFO, NbBundle.getMessage(GeneanetExportAction.class, (String)"GeneanetExportAction.End"));
        return ok;
    }

    private Context openGedcomQuietly(FileObject input, final String password) {
        Context context;
        if (input == null) {
            return null;
        }
        try {
            Origin origin = Origin.create((FileObject)input);
            GedcomReader reader = (GedcomReader)Spin.off((Object)GedcomReaderFactory.createReader((Origin)origin, (GedcomReaderContext)((GedcomReaderContext)Spin.over((Object)new GedcomReaderContext(){

                public String getPassword() {
                    return password;
                }

                public void handleWarning(int line, String warning, Context context) {
                }
            }))));
            Gedcom localGedcom = reader.read();
            context = new Context(localGedcom);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Unable to open copied gedcom", ex);
            return null;
        }
        return context;
    }

    private boolean convertAssociations(Gedcom gedcom) {
        String rela = null;
        boolean returnAsso = true;
        for (Filter f : this.options.getFilters()) {
            if (!(f instanceof FilterAssociationOption)) continue;
            returnAsso = false;
            break;
        }
        LOG.log(Level.INFO, NbBundle.getMessage(GeneanetExportAction.class, (String)"GeneanetExportAction.ConvertingAssos"));
        boolean is55 = Grammar.V55.equals(gedcom.getGrammar());
        String type = "INDI";
        List list = gedcom.getPropertiesByClass(PropertyAssociation.class);
        for (PropertyAssociation prop : list) {
            Indi indiRela = (Indi)prop.getEntity();
            if (prop.getTarget() == null) continue;
            Property propAsso = prop.getTarget().getParent();
            Property relaProp = prop.getProperty("RELA");
            boolean hasAnchor = false;
            if (relaProp != null) {
                rela = relaProp.getDisplayValue();
                boolean bl = hasAnchor = ((PropertyRelationship)relaProp).getAnchor() != null;
            }
            if (returnAsso) {
                prop.getParent().delProperty((Property)prop);
                Property parent = propAsso.addPropertyXref("ASSO", indiRela.getId(), -1);
                if (is55) {
                    parent.addProperty("TYPE", "INDI");
                }
                parent.addProperty("RELA", rela);
                continue;
            }
            if (!hasAnchor) continue;
            Property cible = indiRela.getProperty(((PropertyRelationship)relaProp).getAnchor());
            if (cible != null) {
                Property parent = cible.addPropertyXref("ASSO", propAsso.getEntity().getId(), -1);
                if (is55) {
                    parent.addProperty("TYPE", "INDI");
                }
                parent.addProperty("RELA", rela);
                prop.getParent().delProperty((Property)prop);
                continue;
            }
            prop.unlink();
            relaProp.setValue(rela);
        }
        LOG.log(Level.INFO, "====================");
        return true;
    }

    private boolean convertHeader(Gedcom gedcom1) throws MissingResourceException {
        Entity entity = gedcom1.getFirstEntity("HEAD");
        Property property = entity.getProperty("NOTE");
        String note = NbBundle.getMessage(GeneanetExportAction.class, (String)"GeneanetExportAction.NoteWarning");
        if (property != null) {
            property.setValue(note);
        } else {
            entity.addProperty("NOTE", note);
        }
        gedcom1.setDestination("Geneanet");
        LOG.log(Level.INFO, note);
        return true;
    }

    private boolean convertOther(Gedcom gedcom) {
        Object props;
        LOG.log(Level.INFO, NbBundle.getMessage(GeneanetExportAction.class, (String)"GeneanetExportAction.ConvertingOther"));
        for (Entity entity : gedcom.getFamilies()) {
            props = entity.getProperties("EVEN");
            for (Property p : props) {
                String rela;
                Property prop = p.getProperty("TYPE");
                if (prop == null || !"Relation".equals(rela = prop.getValue())) continue;
                prop.setValue("unmarried");
            }
            Property[] marc = entity.getProperties("MARC");
            Property[] marr = entity.getProperties("MARR");
            if (marc.length > 0 && marr.length == 0) {
                entity.addProperty("MARR", "Y");
            }
            block10: for (Object p : props = entity.getProperties("CHIL")) {
                Fam adopFam;
                Property adop;
                Entity prop = ((PropertyXRef)p).getTargetEntity();
                if (prop == null || (adop = prop.getProperty("ADOP")) == null) continue;
                PropertyFamilyChild famc = null;
                Iterator iterator = adop.getProperties(PropertyFamilyChild.class).iterator();
                if (iterator.hasNext()) {
                    PropertyFamilyChild pFamChild;
                    famc = pFamChild = (PropertyFamilyChild)iterator.next();
                }
                if (famc == null) continue;
                adop = famc.getProperty("ADOP");
                if (adop == null) {
                    famc.addProperty("ADOP", "BOTH");
                }
                if ((adopFam = (Fam)((PropertyXRef)famc).getTargetEntity()) == null || adopFam.getNoOfChildren() == 0) continue;
                String currentChildId = prop.getEntity().getId();
                for (PropertyChild pChild : adopFam.getProperties(PropertyChild.class)) {
                    if (!pChild.getChild().getId().equals(currentChildId)) continue;
                    pChild.unlink();
                    adopFam.delProperty((Property)pChild);
                    continue block10;
                }
            }
        }
        for (Entity entity : gedcom.getIndis()) {
            for (Property p : entity.getProperties("ALIA")) {
                Property parent = p.getParent();
                if (p instanceof PropertyAlias) continue;
                int pos = parent.getPropertyPosition(p);
                String value = p.getValue();
                parent.delProperty(p);
                try {
                    Property pp = parent.addProperty("NAME", "", pos);
                    pp.setValue(value);
                }
                catch (GedcomException ex) {
                    LOG.log(Level.WARNING, "Error during ALIA conversion", ex);
                }
            }
            for (Property p : entity.getAllProperties("NSFX")) {
                Property parent = p.getParent();
                int pos = parent.getPropertyPosition(p);
                String value = p.getValue();
                parent.delProperty(p);
                try {
                    parent.addProperty("NICK", value, pos);
                }
                catch (GedcomException ex) {
                    LOG.log(Level.WARNING, "Error during NSFX conversion", ex);
                }
            }
            props = entity.getProperties("NAME");
            for (int i = 0; i < ((Object)props).length; ++i) {
                Property tmpS;
                Object p = props[i];
                Property tmpG = p.getProperty("GIVN");
                if (tmpG != null) {
                    tmpG.setGuessed(true);
                }
                if ((tmpS = p.getProperty("SURN")) != null) {
                    tmpS.setGuessed(true);
                }
                if (i <= 0) continue;
                String newValue = p.getValue().replace("/", " ").trim();
                p.setValue(newValue);
            }
        }
        for (Filter fil : this.options.getFilters()) {
            if (!(fil instanceof FilterPlaceOption)) continue;
            this.manageGeneanetPlaceFormat(gedcom);
            break;
        }
        for (Entity entity : gedcom.getEntities()) {
            for (Property p : entity.getAllProperties("_TIME")) {
                Property parent = p.getParent();
                int pos = parent.getPropertyPosition(p);
                String value = p.getValue();
                parent.delProperty(p);
                try {
                    parent.addProperty("TIME", value, pos);
                }
                catch (GedcomException ex) {
                    LOG.log(Level.WARNING, "Error during _TIME conversion", ex);
                }
            }
            for (Property p : entity.getAllProperties("_URL")) {
                Property parent = p.getParent();
                int pos = parent.getPropertyPosition(p);
                String value = p.getValue();
                parent.delProperty(p);
                try {
                    parent.addProperty("URL", value, pos);
                }
                catch (GedcomException ex) {
                    LOG.log(Level.WARNING, "Error during _URL conversion", ex);
                }
            }
            for (Property p : entity.getAllProperties("ADDR")) {
                String addresse = p.getValue();
                for (Property adr1 : p.getAllProperties("ADR1")) {
                    addresse = addresse + " " + adr1.getValue();
                    p.delProperty(adr1);
                }
                for (Property adr2 : p.getAllProperties("ADR2")) {
                    addresse = addresse + " " + adr2.getValue();
                    p.delProperty(adr2);
                }
                for (Property adr3 : p.getAllProperties("ADR3")) {
                    addresse = addresse + " " + adr3.getValue();
                    p.delProperty(adr3);
                }
                p.setValue(addresse);
            }
            for (Property p : entity.getAllSpecificProperties()) {
                if (!entity.contains(p)) continue;
                p.delProperties();
                Property parent = p.getParent();
                if (parent == null) continue;
                parent.delProperty(p);
            }
        }
        return true;
    }

    private void manageGeneanetPlaceFormat(Gedcom gedcom) {
        String format = gedcom.getPlaceFormat();
        String cityTag = PropertyPlace.getCityTag((Gedcom)gedcom);
        DirectAccessTokenizer datForm = new DirectAccessTokenizer(format, ",");
        int pos = datForm.contains(cityTag);
        StringBuilder sbForm = new StringBuilder(format.length() + 5);
        if (pos == -1) {
            return;
        }
        sbForm.append('[');
        for (int i = 0; i < pos; ++i) {
            sbForm.append(datForm.get(i));
            if (i == pos - 1) continue;
            sbForm.append(",");
        }
        sbForm.append("] - ");
        sbForm.append(datForm.getSubstringFrom(pos).trim());
        gedcom.setPlaceFormat(sbForm.toString());
        List allPlaces = gedcom.getPropertiesByClass(PropertyPlace.class);
        HashMap<String, String> allUniquePlaces = new HashMap<String, String>();
        for (Property place : allPlaces) {
            if (allUniquePlaces.containsKey(place.getValue())) {
                place.setValue((String)allUniquePlaces.get(place.getValue()));
                continue;
            }
            DirectAccessTokenizer dat = new DirectAccessTokenizer(place.getValue(), ",");
            StringBuilder sb = new StringBuilder(place.getValue().length() + 5);
            String subdivision = dat.getSubstring(0, pos).trim();
            if (subdivision.startsWith(",")) {
                subdivision = subdivision.substring(1);
            }
            if (!"".equals(subdivision.replaceAll(",", "").trim())) {
                sb.append('[').append(subdivision).append("] - ");
            }
            sb.append(dat.getSubstringFrom(pos).trim());
            String result = sb.toString();
            allUniquePlaces.put(place.getValue(), result);
            place.setValue(result);
        }
    }
}

