/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.document.view.DocumentViewTopComponent;
import ancestris.modules.document.view.HyperLinkTextDocumentView;
import ancestris.modules.document.view.WidgetDocumentView;
import ancestris.swing.ToolBar;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.common.ContextListWidget;
import genj.fo.Document;
import genj.fo.Format;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.io.FileAssociation;
import genj.report.Report;
import genj.report.ReportLoader;
import genj.report.ReportSelector;
import genj.report.Runner;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import genj.view.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import spin.Spin;

public class ReportView
extends View {
    static final Logger LOG = Logger.getLogger("ancestris.report");
    private static final ImageIcon imgStart = new ImageIcon(ReportView.class, "Start");
    private static final ImageIcon imgStop = new ImageIcon(ReportView.class, "Stop");
    private HyperLinkTextDocumentView output;
    private final ActionStart actionStart = new ActionStart();
    private final ActionStop actionStop = new ActionStop();
    private static final Registry REGISTRY = Registry.get(ReportView.class);
    static final Resources RESOURCES = Resources.get(ReportView.class);
    private final ReportSelector selector = new ReportSelector();

    public ReportView() {
        this.setLayout(new BorderLayout());
        this.add(this.selector, "Center");
    }

    public void removeNotify() {
        super.removeNotify();
        ReportLoader.getInstance().saveOptions();
    }

    private Gedcom getSelectedGedcom() {
        Context selected = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        return selected == null ? null : selected.getGedcom();
    }

    public void startReport(Report report, Object context, Gedcom gedcom) {
        if (!this.actionStart.isEnabled()) {
            return;
        }
        this.output = new HyperLinkTextDocumentView(new Context(gedcom), report.getShortName(), NbBundle.getMessage(DocumentViewTopComponent.class, (String)"HINT_DocumentResult", (Object)gedcom.getDisplayName(), (Object)report.getName()));
        if (report.getStartMethod(context) == null) {
            boolean found = false;
            List gedcontexts = GedcomDirectory.getDefault().getContexts();
            for (Context ctx : gedcontexts) {
                if (ctx.getGedcom() != gedcom || ctx.getEntity() == null) continue;
                Entity sample = ctx.getEntity();
                String tag = sample.getTag();
                String txt = report.accepts(sample);
                if (txt == null) continue;
                context = report.getEntityFromUser(txt, gedcom, tag, sample);
                if (context == null) {
                    return;
                }
                found = true;
            }
            if (!found) {
                for (String tag : Gedcom.ENTITIES) {
                    Entity sample = gedcom.getFirstEntity(tag);
                    if (sample == null || report.accepts(sample) == null) continue;
                    String txt = report.accepts(sample);
                    if (txt == null) {
                        Gedcom.getName((String)tag);
                    }
                    if ((context = report.getEntityFromUser(txt, gedcom, tag, null)) != null) break;
                    return;
                }
            }
        }
        if (context == null || report.accepts(context) == null) {
            DialogManager.createError((String)report.getName(), (String)RESOURCES.getString("report.noaccept")).show();
            return;
        }
        REGISTRY.put("lastreport", report.getClass().getName());
        report.setOwner((Component)((Object)this));
        this.output.clear();
        this.actionStart.setEnabled(false);
        this.actionStop.setEnabled(true);
        new Thread(new Runner(gedcom, context, report, (Runner.Callback)Spin.over((Object)new RunnerCallback()))).start();
    }

    public void startReport() {
        Gedcom gedcom = this.getSelectedGedcom();
        if (gedcom == null) {
            return;
        }
        Report report = this.selector.getReport();
        if (report == null) {
            return;
        }
        this.startReport(report, gedcom, gedcom);
    }

    public void stopReport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showResult(Object object) {
        block32: {
            if (object == null) {
                if (this.output.isEmpty()) {
                    this.output.add(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"msg.noresult"));
                }
                return;
            }
            if (object instanceof InterruptedException) {
                this.output.add(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"msg.cancelled"));
                return;
            }
            if (object instanceof Throwable) {
                CharArrayWriter buf = new CharArrayWriter(256);
                ((Throwable)object).printStackTrace(new PrintWriter(buf));
                this.output.add(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"msg.exception", (Object)buf));
                LOG.log(Level.WARNING, "Exception caught ", (Throwable)object);
                return;
            }
            String tabName = this.output.getName();
            String tabToolTip = this.output.getToolTipText();
            try {
                if (object instanceof File) {
                    File file = (File)object;
                    if (file.getName().endsWith(".htm")) {
                        try {
                            object = file.toURI().toURL();
                        }
                        catch (MalformedURLException malformedURLException) {}
                    } else {
                        try {
                            FileAssociation.getDefault().execute(file.getAbsolutePath());
                        }
                        catch (Throwable t) {
                            Logger.getLogger("ancestris.report").log(Level.INFO, "cannot open " + file, t);
                            this.output.add(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"msg.cannotopenfile", (Object)file));
                        }
                        return;
                    }
                }
                if (object instanceof URL) {
                    try {
                        this.output.setPage((URL)object);
                    }
                    catch (IOException e) {
                        this.output.add(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"msg.cannotopenurl", (Object)object, (Object)e.getMessage()));
                    }
                    return;
                }
                if (object instanceof List) {
                    try {
                        object = new ContextListWidget((List)object);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (object instanceof JComponent) {
                    new WidgetDocumentView(new Context(this.getSelectedGedcom()), tabName, tabToolTip, (JComponent)object);
                    return;
                }
                if (!(object instanceof Document)) break block32;
                Document doc = (Document)object;
                Format[] formats = Format.getFormats();
                HashMap<String, String> fmts = new HashMap<String, String>();
                for (Format format : formats) {
                    fmts.put(format.getFormat(), format.getFileExtension());
                }
                FileChooserBuilder fcb = new FileChooserBuilder(Document.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"Fo_Document", (Object)doc.getTitle())).setApproveText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"Fo_OK_Select")).setDefaultExtension(formats[0].getFileExtension()).setFileFilters(fmts).setAcceptAllFileFilterUsed(false).setDefaultDirAsReportDirectory().setFileHiding(true);
                File file = fcb.showSaveDialog();
                if (file == null) {
                    this.showResult(null);
                    return;
                }
                Format formatter = Format.getFormatFromExtension((String)FileChooserBuilder.getExtension((String)file.getName()));
                try {
                    file.getParentFile().mkdirs();
                    formatter.format(doc, file);
                }
                catch (IOException t) {
                    LOG.log(Level.WARNING, "formatting " + doc + " failed", t);
                    this.output.add(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"msg.formatting", (Object)doc));
                    if (this.output.isEmpty()) {
                        this.output.close();
                    }
                    return;
                }
                this.showResult(file);
                return;
            }
            finally {
                if (this.output.isEmpty()) {
                    this.output.close();
                }
            }
        }
        this.output.add(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"msg.unknownresult", (Object)object));
    }

    public void populate(ToolBar toolbar) {
        toolbar.add((Action)((Object)this.actionStart));
        toolbar.add((Action)((Object)this.actionStop));
        toolbar.add(this.selector.getActionGroup());
    }

    private class ActionStart
    extends AbstractAncestrisAction {
        protected ActionStart() {
            this.setImage((Icon)imgStart);
            this.setTip(RESOURCES.getString("report.start.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            ReportView.this.startReport();
        }
    }

    private class ActionStop
    extends AbstractAncestrisAction {
        protected ActionStop() {
            this.setImage((Icon)imgStop);
            this.setTip(RESOURCES.getString("report.stop.tip"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            ReportView.this.stopReport();
        }
    }

    private class RunnerCallback
    implements Runner.Callback {
        private RunnerCallback() {
        }

        @Override
        public void handleOutput(Report report, String s) {
            ReportView.this.output.add(s);
        }

        @Override
        public void handleResult(Report report, Object result) {
            LOG.log(Level.FINE, "Result of report {0} = {1}", new Object[]{report.getName(), result});
            ReportView.this.actionStart.setEnabled(ReportView.this.getSelectedGedcom() != null);
            ReportView.this.actionStop.setEnabled(false);
            ReportView.this.showResult(result);
        }
    }
}

