/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import ancestris.awt.FilteredMouseAdapter;
import ancestris.view.SelectionDispatcher;
import genj.edit.EditView;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.io.InputSource;
import genj.io.PropertyReader;
import genj.io.PropertyTransferable;
import genj.util.swing.ImageIcon;
import genj.view.ViewContext;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import spin.Spin;
import swingx.dnd.tree.DnDTree;
import swingx.dnd.tree.DnDTreeModel;
import swingx.tree.AbstractTreeModel;

public class PropertyTreeWidget
extends DnDTree {
    private static final String UNIX_DND_FILE_PREFIX = "file:";
    private Gedcom gedcom;
    private static Gedcom draggingFrom = null;

    public PropertyTreeWidget(Gedcom gedcom) {
        super.setModel((TreeModel)((Object)new Model(gedcom)));
        this.gedcom = gedcom;
        this.setCellRenderer(new Renderer());
        this.getSelectionModel().setSelectionMode(4);
        this.setToggleClickCount(Integer.MAX_VALUE);
        this.addMouseListener((MouseListener)new FilteredMouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    return;
                }
                TreePath path = PropertyTreeWidget.this.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                if (!PropertyTreeWidget.this.getSelection().contains(path.getLastPathComponent())) {
                    PropertyTreeWidget.this.setSelection(Collections.singletonList((Property)path.getLastPathComponent()));
                }
            }

            public void mouseClickedFiltered(MouseEvent me) {
                super.mouseClickedFiltered(me);
                if (me.getClickCount() > 1) {
                    TreePath path = PropertyTreeWidget.this.getPathForLocation(me.getX(), me.getY());
                    if (path == null) {
                        return;
                    }
                    SelectionDispatcher.fireSelection((AWTEvent)me, (Context)new Context((Property)path.getLastPathComponent()));
                }
            }
        });
        this.setExpandsSelectedPaths(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
    }

    public ViewContext getContext() {
        Entity root = (Entity)this.getRoot();
        if (root == null) {
            return new ViewContext(this.gedcom);
        }
        List<Property> selection = this.getSelection();
        if (selection.isEmpty()) {
            return new ViewContext(root);
        }
        return new ViewContext(this.gedcom, new ArrayList(), selection);
    }

    public void setModel() {
        throw new IllegalArgumentException();
    }

    private Model getPropertyModel() {
        return (Model)((Object)this.getModel());
    }

    public Object[] getPathFor(Property property) {
        return this.getPropertyModel().getPathToRoot(property);
    }

    public void addNotify() {
        super.addNotify();
        this.gedcom.addGedcomListener((GedcomListener)Spin.over((Object)((Object)this.getPropertyModel())));
    }

    public void removeNotify() {
        this.gedcom.removeGedcomListener((GedcomListener)Spin.over((Object)((Object)this.getPropertyModel())));
        super.removeNotify();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(256, 128);
    }

    public void setRoot(Property property) {
        if (this.getPropertyModel().getRoot() == property) {
            return;
        }
        this.getPropertyModel().setRoot(property);
    }

    public void expandAllRows() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void expand(TagPath path) {
        block0: for (int row = this.getRowCount() - 1; row >= 0; --row) {
            TreePath tp = this.getPathForRow(row);
            if (path.length() != tp.getPathCount()) continue;
            for (int i = 0; i < path.length(); ++i) {
                if (!path.get(i).equals(((Property)tp.getPathComponent(i)).getTag())) continue block0;
            }
            this.expandRow(row);
        }
    }

    public Property getRoot() {
        return this.getPropertyModel().getPropertyRoot();
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(0);
    }

    public void setSelection(List<? extends Property> select) {
        this.clearSelection();
        Property root = (Property)this.getPropertyModel().getRoot();
        if (root == null) {
            return;
        }
        TreePath first = null;
        for (Property property : select) {
            try {
                TreePath path = new TreePath(this.getPropertyModel().getPathToRoot(property));
                this.addSelectionPath(path);
                if (first != null) continue;
                first = path;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (first != null) {
            this.scrollPathToVisible(first);
        }
    }

    public List<Property> getSelection() {
        ArrayList<Property> result = new ArrayList<Property>();
        TreePath[] paths = this.getSelectionPaths();
        for (int i = 0; paths != null && i < paths.length; ++i) {
            Property p = (Property)paths[i].getLastPathComponent();
            if (p.getEntity() == null) continue;
            result.add(p);
        }
        return result;
    }

    public Property getPropertyAt(int x, int y) {
        TreePath path = super.getPathForLocation(x, y);
        if (path == null || path.getPathCount() == 0) {
            return null;
        }
        return (Property)path.getLastPathComponent();
    }

    public Property getPropertyAt(Point pos) {
        return this.getPropertyAt(pos.x, pos.y);
    }

    public String getToolTipText(MouseEvent event) {
        Property prop = this.getPropertyAt(event.getX(), event.getY());
        if (prop == null) {
            return null;
        }
        if (prop.isTransient()) {
            return null;
        }
        if (prop.getEntity() == null) {
            return null;
        }
        String info = prop.getPropertyInfo();
        if (info == null) {
            return null;
        }
        return "<html><table width=200><tr><td>" + info + "</td></tr></table></html";
    }

    public void setUI(TreeUI ui) {
        super.setUI(ui);
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof Property) {
            return ((Property)value).getTag();
        }
        return "";
    }

    private abstract class IOUnitOfWork
    implements UnitOfWork {
        private IOUnitOfWork() {
        }

        public final void perform(Gedcom gedcom) throws GedcomException {
            try {
                this.performIO(gedcom);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        protected abstract void performIO(Gedcom var1) throws IOException, UnsupportedFlavorException;
    }

    private class Renderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        private Color selectedCellBackgroundColor;
        private Color selectedCellForeroundColor = new Color(UIManager.getColor("Tree.selectionForeground").getRGB());
        private Color nonselectedCellBackgroundColor;
        private Color nonselectedCellForeroundColor;

        private Renderer() {
            this.selectedCellBackgroundColor = new Color(UIManager.getColor("Tree.selectionBackground").getRGB());
            this.nonselectedCellForeroundColor = new Color(UIManager.getColor("Tree.foreground").getRGB());
            this.nonselectedCellBackgroundColor = new Color(UIManager.getColor("Tree.background").getRGB());
            this.setOpaque(true);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            return retDimension;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object object, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(object instanceof Property)) {
                return this;
            }
            Property prop = (Property)object;
            if (sel) {
                this.setForeground(this.selectedCellForeroundColor);
                this.setBackground(this.selectedCellBackgroundColor);
            } else {
                this.setForeground(this.nonselectedCellForeroundColor);
                this.setBackground(this.nonselectedCellBackgroundColor);
            }
            ImageIcon img = prop.getImage(true);
            if (prop.isPrivate()) {
                img = img.getOverLayed(MetaProperty.IMG_PRIVATE);
            }
            this.setIcon((Icon)img);
            String str = prop instanceof Entity ? this.calcText((Entity)prop) : this.calcText(prop);
            this.setText("<html>" + str + "</html>");
            Dimension retDimension = super.getPreferredSize();
            Font font = this.getFont();
            if (font != null) {
                int fontSize = font.getSize() + 4;
                retDimension = new Dimension(this.getFontMetrics(font).stringWidth(this.getText()), fontSize);
            } else {
                retDimension.height = retDimension != null ? retDimension.height : 12;
            }
            this.setPreferredSize(retDimension);
            return this;
        }

        private String calcText(Entity entity) {
            String tag = entity.getTag();
            String value = "NOTE".equals(tag) ? "" : " " + entity.getValue();
            int nl = value.indexOf(10);
            if (nl >= 0) {
                value = value.substring(0, nl) + "...";
            }
            return "<b>@" + entity.getId() + "@ " + tag + value + "</b>";
        }

        private String calcText(Property prop) {
            StringBuilder result = new StringBuilder();
            if (!prop.isTransient()) {
                if (prop.isGuessed()) {
                    result.append("<i>" + prop.getTag() + "</i>");
                } else {
                    result.append("<b>" + prop.getTag() + "</b>");
                }
                result.append(' ');
            }
            if (prop.isSecret()) {
                result.append("*****");
            } else {
                String val = prop.isValid() && !prop.hasWarning() ? prop.getDisplayValue() : prop.getValue();
                int nl = val.indexOf(10);
                if (nl >= 0) {
                    val = val.substring(0, nl) + "...";
                }
                result.append(val);
            }
            return result.toString();
        }
    }

    private class Model
    extends AbstractTreeModel
    implements DnDTreeModel,
    GedcomListener {
        private Property root = null;
        private Gedcom ged;

        protected Model(Gedcom gedcom) {
            this.ged = gedcom;
        }

        protected void setRoot(Property set) {
            this.root = set;
            this.rootExchanged();
            PropertyTreeWidget.this.setRootVisible(this.root != null);
        }

        public Property getPropertyRoot() {
            return this.root;
        }

        public Transferable createTransferable(Object[] nodes) {
            draggingFrom = this.ged;
            ArrayList<Property> props = new ArrayList<Property>(nodes.length);
            for (Object node : nodes) {
                props.add((Property)node);
            }
            List list = Property.normalize(props);
            return new PropertyTransferable(list);
        }

        public int getDragActions(Transferable transferable) {
            return 3;
        }

        public int getDropActions(Transferable transferable, Object parent, int index) {
            try {
                if (transferable.isDataFlavorSupported(PropertyTransferable.VMLOCAL_FLAVOR)) {
                    List dragged = (List)transferable.getTransferData(PropertyTransferable.VMLOCAL_FLAVOR);
                    for (Property pparent = (Property)parent; pparent != null; pparent = pparent.getParent()) {
                        if (!dragged.contains(pparent)) continue;
                        return 0;
                    }
                    return 3;
                }
                if (transferable.isDataFlavorSupported(PropertyTransferable.STRING_FLAVOR)) {
                    return 3;
                }
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    return 3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        public void drop(final Transferable transferable, Object parent, final int index, final int action) throws IOException, UnsupportedFlavorException {
            final Property pparent = (Property)parent;
            if (transferable.isDataFlavorSupported(PropertyTransferable.VMLOCAL_FLAVOR)) {
                final List children = (List)transferable.getTransferData(PropertyTransferable.VMLOCAL_FLAVOR);
                if (action == 2 && pparent.hasProperties(children)) {
                    this.ged.doMuteUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            pparent.moveProperties(children, index);
                        }
                    });
                    return;
                }
                this.ged.doMuteUnitOfWork((UnitOfWork)new IOUnitOfWork(){

                    @Override
                    protected void performIO(Gedcom gedcom) throws IOException, UnsupportedFlavorException {
                        ArrayList xrefs = new ArrayList();
                        String string = transferable.getTransferData(PropertyTransferable.STRING_FLAVOR).toString();
                        new PropertyReader((Reader)new StringReader(string), xrefs, true).read(pparent, index);
                        if (action == 2 && draggingFrom == gedcom) {
                            for (Property child : children) {
                                child.getParent().delProperty(child);
                            }
                        }
                        for (PropertyXRef xref : xrefs) {
                            try {
                                xref.link();
                            }
                            catch (Throwable t) {
                                EditView.LOG.log(Level.WARNING, "caught exception during dnd trying to link xrefs", t);
                            }
                        }
                    }
                });
                return;
            }
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                this.ged.doMuteUnitOfWork((UnitOfWork)new IOUnitOfWork(){

                    @Override
                    protected void performIO(Gedcom gedcom) throws IOException, UnsupportedFlavorException {
                        for (File file : (List)transferable.getTransferData(DataFlavor.javaFileListFlavor)) {
                            pparent.addFile((InputSource)InputSource.get((File)file).orElse(null));
                        }
                    }
                });
                return;
            }
            if (!transferable.isDataFlavorSupported(PropertyTransferable.STRING_FLAVOR)) {
                return;
            }
            final String string = transferable.getTransferData(PropertyTransferable.STRING_FLAVOR).toString();
            if (string.length() < 4) {
                return;
            }
            if (string.startsWith(PropertyTreeWidget.UNIX_DND_FILE_PREFIX)) {
                this.ged.doMuteUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) {
                        StringTokenizer files = new StringTokenizer(string, "\n");
                        while (files.hasMoreTokens()) {
                            String file = files.nextToken().trim();
                            if (!file.startsWith(PropertyTreeWidget.UNIX_DND_FILE_PREFIX)) continue;
                            pparent.addFile((InputSource)InputSource.get((File)new File(file.substring(PropertyTreeWidget.UNIX_DND_FILE_PREFIX.length()))).orElse(null));
                        }
                    }
                });
                return;
            }
            EditView.LOG.fine("reading dropped text '" + string + "'");
            this.ged.doMuteUnitOfWork((UnitOfWork)new IOUnitOfWork(){

                @Override
                protected void performIO(Gedcom gedcom) throws IOException, UnsupportedFlavorException {
                    new PropertyReader((Reader)new StringReader(string), null, true).read(pparent, index);
                }
            });
        }

        public void drag(Transferable transferable, int action) throws UnsupportedFlavorException, IOException {
            final List children = (List)transferable.getTransferData(PropertyTransferable.VMLOCAL_FLAVOR);
            if (children.isEmpty()) {
                return;
            }
            if (action == 2 && draggingFrom != this.ged) {
                this.ged.doMuteUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) {
                        for (int i = 0; i < children.size(); ++i) {
                            Property child = (Property)children.get(i);
                            child.getParent().delProperty(child);
                        }
                    }
                });
            }
        }

        public void releaseTransferable(Transferable transferable) {
            draggingFrom = null;
        }

        protected Object getParent(Object node) {
            if (node == this.root) {
                return null;
            }
            return ((Property)node).getParent();
        }

        public Object getChild(Object parent, int index) {
            return ((Property)parent).getProperty(index);
        }

        public int getChildCount(Object parent) {
            return ((Property)parent).getNoOfProperties();
        }

        public int getIndexOfChild(Object parent, Object child) {
            try {
                return ((Property)parent).getPropertyPosition((Property)child);
            }
            catch (Throwable t) {
                return -1;
            }
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node) {
            return ((Property)node).getNoOfProperties() == 0;
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (this.root == entity) {
                this.setRoot(null);
            }
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            if (this.root != property.getEntity()) {
                return;
            }
            Object[] path = PropertyTreeWidget.this.getPathFor(property);
            this.fireTreeNodesInserted((Object)this, path, new int[]{pos}, new Property[]{added});
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            if (this.root != property.getEntity()) {
                return;
            }
            this.fireTreeNodesChanged((Object)this, PropertyTreeWidget.this.getPathFor(property), null, null);
            if (property.getParent() != null && property.getParent().getTag().equals("NAME")) {
                Property[] famss;
                this.fireTreeNodesChanged((Object)this, PropertyTreeWidget.this.getPathFor(property.getParent()), null, null);
                for (Property fams : famss = property.getEntity().getProperties("FAMS")) {
                    this.fireTreeNodesChanged((Object)this, PropertyTreeWidget.this.getPathFor(fams), null, null);
                }
            }
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
            if (this.root != property.getEntity()) {
                return;
            }
            if (property instanceof PropertyChange) {
                return;
            }
            this.fireTreeNodesRemoved((Object)this, PropertyTreeWidget.this.getPathFor(property), new int[]{pos}, new Property[]{deleted});
        }
    }
}

