/*
 * Decompiled with CFR 0.152.
 */
package genj.table;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.common.PathTreeWidget;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.table.TableView;
import genj.util.GridBagHelper;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import genj.util.swing.ListSelectionWidget;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TableViewSettings
extends JPanel {
    private PathTreeWidget pathTree;
    private ListSelectionWidget<TagPath> pathList;
    private Resources resources = Resources.get((Object)this);

    public TableViewSettings(final TableView view) {
        final Grammar grammar = view.getGedcom() != null ? view.getGedcom().getGrammar() : Grammar.V55;
        GridBagHelper gh = new GridBagHelper((Container)this);
        this.pathTree = new PathTreeWidget();
        PathTreeWidget.Listener plistener = new PathTreeWidget.Listener(){

            public void handleSelection(TagPath path, boolean on) {
                if (!on) {
                    TableViewSettings.this.pathList.removeChoice((Object)path);
                } else {
                    TableViewSettings.this.pathList.addChoice((Object)path);
                }
            }
        };
        String tag = view.getMode().getTag();
        Object[] selectedPaths = view.getMode(tag).getPaths();
        TagPath[] usedPaths = grammar.getAllPaths(tag, Property.class);
        this.pathTree.setGrammar(grammar);
        this.pathTree.setPaths(usedPaths, (TagPath[])selectedPaths);
        this.pathTree.addListener(plistener);
        final Move up = new Move(true);
        final Move dn = new Move(false);
        final Del del = new Del();
        this.pathList = new ListSelectionWidget<TagPath>(){

            protected ImageIcon getIcon(TagPath path) {
                return grammar.getMeta(path).getImage();
            }
        };
        this.pathList.setChoices(selectedPaths);
        this.pathList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TagPath path = (TagPath)TableViewSettings.this.pathList.getChoice(e.getPoint());
                if (path != null && e.getClickCount() == 2) {
                    TableViewSettings.this.pathTree.setSelected(path, false);
                }
            }
        });
        this.pathList.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i = TableViewSettings.this.pathList.getSelectedIndex();
                up.setEnabled(i > 0);
                dn.setEnabled(i >= 0 && i < TableViewSettings.this.pathList.getChoices().size() - 1);
                del.setEnabled(i >= 0);
            }
        });
        this.pathList.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                List choices = TableViewSettings.this.pathList.getChoices();
                view.getMode().setPaths(choices.toArray(new TagPath[choices.size()]), false);
            }
        });
        gh.add((Component)new JLabel(this.resources.getString("info.columns")), 0, 0, 4, 1, 1);
        gh.add((Component)this.pathTree, 0, 1, 4, 1, 68);
        gh.add((Component)new JLabel(this.resources.getString("info.order")), 0, 2, 4, 1, 1);
        gh.add(this.pathList, 0, 3, 4, 1, 68);
        gh.add((Component)new JButton((Action)((Object)up)), 0, 4, 1, 1, 1);
        gh.add((Component)new JButton((Action)((Object)dn)), 1, 4, 1, 1, 1);
        gh.add((Component)new JButton((Action)((Object)del)), 2, 4, 1, 1, 1);
        final JCheckBox cbTableFollowEntity = new JCheckBox(this.resources.getString("cbTableFollowEntity.text"), TableView.getFollowEntity());
        cbTableFollowEntity.setToolTipText(this.resources.getString("cbTableFollowEntity.toolTipText"));
        cbTableFollowEntity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TableView.setFollowEntity(cbTableFollowEntity.isSelected());
            }
        });
        gh.add((Component)cbTableFollowEntity, 0, 5, 4, 1, 1, new Insets(8, 0, 0, 0));
    }

    private class Del
    extends AbstractAncestrisAction {
        protected Del() {
            this.setEnabled(false);
            this.setText(TableViewSettings.this.resources.getString("info.del"));
        }

        public void actionPerformed(ActionEvent e) {
            TableViewSettings.this.pathTree.setSelected((TagPath)TableViewSettings.this.pathList.getSelectedChoice(), false);
        }
    }

    private class Move
    extends AbstractAncestrisAction {
        private boolean up;

        protected Move(boolean up) {
            this.up = up;
            this.setEnabled(false);
            if (up) {
                this.setText(TableViewSettings.this.resources.getString("info.up"));
            } else {
                this.setText(TableViewSettings.this.resources.getString("info.down"));
            }
        }

        public void actionPerformed(ActionEvent e) {
            int i = TableViewSettings.this.pathList.getSelectedIndex();
            if (this.up) {
                TableViewSettings.this.pathList.swapChoices(i, i - 1);
            } else {
                TableViewSettings.this.pathList.swapChoices(i, i + 1);
            }
        }
    }
}

