/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.placeeditor.models;

import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyPlace;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class GedcomPlaceTableModel
extends AbstractTableModel {
    private Gedcom gedcom = null;
    private Map<String, Set<PropertyPlace>> placesMap = null;
    private String currentPlaceFormat = null;
    private String[] columsTitle;
    private String[][] data = null;
    private int nbColumns = 0;
    private int nbRows = 0;

    public GedcomPlaceTableModel(Gedcom gedcom) {
        this.gedcom = gedcom;
    }

    public void update() {
        String[] placeFormat = PropertyPlace.getFormat((Gedcom)this.gedcom);
        int maxLength = placeFormat.length;
        String newPlaceFormat = PropertyPlace.arrayToString((String[])placeFormat);
        this.placesMap = this.getGeoPlacesMap();
        Set<String> places = this.placesMap.keySet();
        for (String place : places) {
            int l = PropertyPlace.getFormat((String)place).length - 2;
            if (l <= maxLength) continue;
            maxLength = l;
        }
        for (int i = placeFormat.length; i < maxLength; ++i) {
            newPlaceFormat = newPlaceFormat + ",?";
        }
        if (!newPlaceFormat.equals(this.currentPlaceFormat)) {
            this.currentPlaceFormat = newPlaceFormat;
            placeFormat = PropertyPlace.getFormat((String)newPlaceFormat);
            this.nbColumns = placeFormat.length + 2;
            this.columsTitle = new String[this.nbColumns];
            for (int index = 0; index < placeFormat.length; ++index) {
                this.columsTitle[index] = placeFormat[index];
            }
            this.columsTitle[index] = "Latitude";
            this.columsTitle[index + 1] = "Longitude";
            this.fireTableStructureChanged();
        }
        this.nbRows = places.size();
        this.data = new String[this.nbRows][this.nbColumns];
        int row = 0;
        for (String place : places) {
            String[] line = PropertyPlace.getFormat((String)place);
            for (int i = 0; i < this.nbColumns; ++i) {
                this.data[row][i] = i < line.length - 2 ? line[i] : (i >= this.nbColumns - 2 ? line[i - this.nbColumns + line.length] : "");
            }
            ++row;
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (value instanceof String && this.data[row][column].compareTo((String)value) != 0) {
            this.data[row][column] = (String)value;
            this.fireTableCellUpdated(row, column);
        }
    }

    @Override
    public int getRowCount() {
        return this.nbRows;
    }

    @Override
    public int getColumnCount() {
        return this.nbColumns;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.data != null) {
            if (row >= 0 && row < this.data.length && column >= 0 && this.data[row] != null && column < this.data[row].length) {
                return this.data[row][column];
            }
            return "";
        }
        return "";
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.columsTitle[col];
    }

    public Set<PropertyPlace> getValueAt(int row) {
        if (this.placesMap != null) {
            Object[] toArray = this.placesMap.keySet().toArray();
            return this.placesMap.get(toArray[row]);
        }
        return null;
    }

    private Map<String, Set<PropertyPlace>> getGeoPlacesMap() {
        TreeMap<String, Set<PropertyPlace>> ret = new TreeMap<String, Set<PropertyPlace>>();
        for (String placeStr : this.gedcom.getReferenceSet("PLAC").getKeys((Comparator)this.gedcom.getCollator())) {
            Set props = this.gedcom.getReferenceSet("PLAC").getReferences((Object)placeStr);
            for (Property prop : props) {
                String keyString = ((PropertyPlace)prop).getGeoValue();
                HashSet<PropertyPlace> set = (HashSet<PropertyPlace>)ret.get(keyString);
                if (set == null) {
                    set = new HashSet<PropertyPlace>();
                    ret.put(keyString, set);
                }
                set.add((PropertyPlace)prop);
            }
        }
        return ret;
    }

    public void setGeoPlacesFromModel() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            String[] newValueArray = Arrays.copyOfRange(this.data[row], 0, this.getColumnCount() - 2);
            String newPlaceValue = PropertyPlace.formatSpaces((String)PropertyPlace.arrayToString((String[])newValueArray));
            String newLatValue = this.data[row][this.getColumnCount() - 2];
            String newLonValue = this.data[row][this.getColumnCount() - 1];
            Set<PropertyPlace> pPlaces = this.getValueAt(row);
            for (PropertyPlace pPlace : pPlaces) {
                String lon;
                if (!newPlaceValue.equals(pPlace.getValue())) {
                    pPlace.setValue(newPlaceValue);
                }
                PropertyLatitude pLat = pPlace.getLatitude(false);
                PropertyLongitude pLon = pPlace.getLongitude(false);
                String lat = pLat != null ? pLat.getValue() : "";
                String string = lon = pLon != null ? pLon.getValue() : "";
                if (newLatValue.equals(lat) && newLonValue.equals(lon)) continue;
                pPlace.setCoordinates(newLatValue, newLonValue);
            }
        }
    }

    public void eraseModel() {
        Iterator<Map.Entry<String, Set<PropertyPlace>>> it = this.placesMap.entrySet().iterator();
        while (it.hasNext()) {
            Set<PropertyPlace> set = it.next().getValue();
            Iterator<PropertyPlace> it2 = set.iterator();
            while (it2.hasNext()) {
                it2.next();
                it2.remove();
            }
            it.remove();
        }
        this.placesMap = null;
    }
}

