/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.FamBox;
import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.Translator;
import ancestris.report.svgtree.build.NoSpouseFilter;
import ancestris.report.svgtree.build.RemoveDuplicates;
import ancestris.report.svgtree.build.RemoveDuplicatesPrepare;
import ancestris.report.svgtree.build.RemoveFamboxes;
import ancestris.report.svgtree.build.RemoveFamboxesWhereNoSpouse;
import ancestris.report.svgtree.build.TreeBuilder;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BasicTreeBuilder
implements TreeBuilder {
    public int gen_ancestors = 3;
    public String[] gen_ancestorss = new String[]{"nolimit", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public int gen_ancestor_descendants = 3;
    public String[] gen_ancestor_descendantss = new String[]{"nolimit", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public int gen_descendants = 3;
    public String[] gen_descendantss = new String[]{"nolimit", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public boolean show_duplicates = false;
    public boolean show_spouses = true;
    public boolean other_marriages = true;
    public boolean display_fambox = true;
    private boolean husband_first = true;
    private final Translator translator;

    public BasicTreeBuilder(Translator translator) {
        this.translator = translator;
        this.gen_ancestorss[0] = translator.translate(this.gen_ancestorss[0]);
        this.gen_ancestor_descendantss[0] = translator.translate(this.gen_ancestor_descendantss[0]);
        this.gen_descendantss[0] = translator.translate(this.gen_descendantss[0]);
    }

    public void setHusbandFirst(boolean set) {
        this.husband_first = set;
    }

    @Override
    public IndiBox build(Indi indi) {
        IndiBox indiBox = new IndiBox(indi);
        this.buildTree(indiBox, this.gen_ancestors == 0 ? 999 : this.gen_ancestors - 1, this.gen_descendants == 0 ? 999 : this.gen_descendants - 1, this.gen_ancestor_descendants == 0 ? 999 : this.gen_ancestor_descendants - 1, 0, 0, true);
        if (!this.show_spouses) {
            new NoSpouseFilter().filter(indiBox);
        }
        if (!this.display_fambox) {
            new RemoveFamboxes().filter(indiBox);
        } else {
            new RemoveFamboxesWhereNoSpouse().filter(indiBox);
        }
        RemoveDuplicatesPrepare rdp = new RemoveDuplicatesPrepare();
        rdp.filter(indiBox);
        this.sortSosa(rdp.getMap());
        IndiBox.netTotalBoxes = 0;
        new RemoveDuplicates(this.show_duplicates).filter(indiBox);
        return indiBox;
    }

    private void buildTree(IndiBox deCujusBox, int maxAncGen, int maxDesGen, int maxAncDesGen, int currentAncGen, int currentDesGen, boolean mainSosaLine) {
        BigInteger sosaStart = BigInteger.ONE.add(BigInteger.ONE);
        HashMap<BigInteger, IndiBox> sosaIndiBoxesMap = new HashMap<BigInteger, IndiBox>();
        sosaIndiBoxesMap.put(sosaStart, deCujusBox);
        if (currentAncGen <= maxAncGen) {
            this.buildSosaTree(sosaIndiBoxesMap, deCujusBox, maxAncGen, currentAncGen + 1, sosaStart, mainSosaLine);
        }
        for (BigInteger sosa : sosaIndiBoxesMap.keySet()) {
            this.buildDescendantsTree((IndiBox)sosaIndiBoxesMap.get(sosa), sosa.equals(BigInteger.ONE.shiftLeft(1)) ? maxDesGen : maxAncDesGen, currentDesGen + 1, mainSosaLine);
        }
        if (this.other_marriages) {
            for (BigInteger sosa : sosaIndiBoxesMap.keySet()) {
                IndiBox last = (IndiBox)sosaIndiBoxesMap.get(sosa);
                if (last.spouse != null && last.spouse.nextMarriage != null) {
                    this.buildTree(last.spouse.nextMarriage, maxAncGen, maxAncDesGen, maxAncDesGen, sosa.bitLength() - 2, currentDesGen, false);
                }
                if (last.nextMarriage == null) continue;
                this.buildTree(last.nextMarriage, maxAncGen, maxAncDesGen, maxAncDesGen, sosa.bitLength() - 2, currentDesGen, false);
            }
        }
    }

    private void buildSosaTree(Map<BigInteger, IndiBox> map, IndiBox indiBox, int maxGen, int currentGen, BigInteger sosa, boolean mainSosaLine) {
        BigInteger sosaStart = BigInteger.ONE.add(BigInteger.ONE);
        this.setLinks(indiBox, sosa, mainSosaLine);
        if (currentGen <= maxGen) {
            BigInteger bi;
            Indi parent = this.getParent(indiBox.individual);
            if (parent != null && (mainSosaLine || !sosaStart.equals(sosa))) {
                IndiBox parentBox = new IndiBox(parent, indiBox);
                parentBox.family = new FamBox(this.getFamily(indiBox.individual));
                indiBox.parent = parentBox;
                bi = sosa.shiftLeft(1);
                map.put(bi, parentBox);
                this.buildSosaTree(map, parentBox, maxGen, currentGen + 1, bi, mainSosaLine);
            }
            if (indiBox.spouse != null && (parent = this.getParent(indiBox.spouse.individual)) != null) {
                IndiBox parentSpouseBox = new IndiBox(parent, indiBox.spouse);
                parentSpouseBox.family = new FamBox(this.getFamily(indiBox.spouse.individual));
                indiBox.spouse.parent = parentSpouseBox;
                bi = sosa.add(BigInteger.ONE).shiftLeft(1);
                map.put(bi, parentSpouseBox);
                this.buildSosaTree(map, parentSpouseBox, maxGen, currentGen + 1, bi, mainSosaLine);
            }
        }
    }

    private void buildDescendantsTree(IndiBox indiBox, int maxGen, int currentGen, boolean mainSosaLine) {
        if (currentGen > maxGen || indiBox.getFamily() == null) {
            return;
        }
        ArrayList<Indi> children = new ArrayList<Indi>(Arrays.asList(indiBox.getFamily().getChildren(true)));
        if (indiBox.prev != null) {
            children.remove(indiBox.prev.individual);
        }
        indiBox.children = new IndiBox[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            IndiBox childBox = new IndiBox((Indi)children.get(i), indiBox);
            this.setLinks(childBox, indiBox.family.sosa, mainSosaLine);
            indiBox.children[i] = childBox;
            this.buildDescendantsTree(childBox, maxGen, currentGen + 1, mainSosaLine);
            IndiBox spouse = childBox.spouse;
            while (spouse != null && spouse.nextMarriage != null) {
                this.buildDescendantsTree(spouse.nextMarriage, maxGen, currentGen + 1, mainSosaLine);
                spouse = spouse.nextMarriage.spouse;
            }
            IndiBox marriage = childBox.nextMarriage;
            while (marriage != null) {
                this.buildDescendantsTree(marriage, maxGen, currentGen + 1, mainSosaLine);
                marriage = marriage.nextMarriage;
            }
        }
    }

    private void setLinks(IndiBox indiBox, BigInteger sosa, boolean mainSosaLine) {
        if (indiBox.family != null && indiBox.spouse != null) {
            return;
        }
        ArrayList<Fam> families = new ArrayList<Fam>(Arrays.asList(indiBox.individual.getFamiliesWhereSpouse(true)));
        if (!families.isEmpty()) {
            Indi spouse;
            Fam indiboxFamily = (Fam)families.get(0);
            if (!this.other_marriages) {
                indiboxFamily = indiBox.individual.getPreferredFamily();
            }
            if (indiBox.family != null) {
                indiboxFamily = indiBox.family.family;
            } else {
                indiBox.family = new FamBox(indiboxFamily);
            }
            if (mainSosaLine) {
                indiBox.family.sosa = sosa;
            }
            if ((spouse = indiboxFamily.getOtherSpouse(indiBox.individual)) != null) {
                indiBox.spouse = new IndiBox(spouse, indiBox);
            }
            if (this.other_marriages) {
                IndiBox last = indiBox.spouse;
                if (last == null) {
                    last = indiBox;
                }
                if (spouse != null) {
                    families.remove(indiboxFamily);
                    families.addAll(Arrays.asList(spouse.getFamiliesWhereSpouse()));
                }
                families.remove(indiboxFamily);
                families.add(0, indiboxFamily);
                Iterator i = families.iterator();
                i.next();
                while (i.hasNext()) {
                    Fam f = (Fam)i.next();
                    Indi indi = indiBox.individual;
                    if (indiBox.individual != f.getHusband() && indiBox.individual != f.getWife()) {
                        indi = spouse;
                    }
                    IndiBox box = new IndiBox(indi, last);
                    box.family = new FamBox(f);
                    if (f.getOtherSpouse(indi) != null) {
                        box.spouse = new IndiBox(f.getOtherSpouse(indi), box);
                    }
                    last.nextMarriage = box;
                    last = box.spouse;
                    if (last != null) continue;
                    last = box;
                }
            }
        }
    }

    private Indi getParent(Indi i) {
        Fam f = this.getFamily(i);
        if (f == null) {
            return null;
        }
        if (this.husband_first) {
            if (f.getHusband() != null) {
                return f.getHusband();
            }
            return f.getWife();
        }
        if (f.getWife() != null) {
            return f.getWife();
        }
        return f.getHusband();
    }

    private Fam getFamily(Indi i) {
        Fam[] fs = i.getFamiliesWhereChild();
        if (fs.length == 0) {
            return null;
        }
        return fs[0];
    }

    private void sortSosa(Map<Fam, List<FamBox>> map) {
        for (Fam fam : map.keySet()) {
            List<FamBox> list = map.get(fam);
            if (list.size() == 1) continue;
            Collections.sort(list, (o1, o2) -> {
                BigInteger bi1 = ((FamBox)o1).sosa;
                BigInteger bi2 = ((FamBox)o2).sosa;
                if (bi1 == null && bi2 == null) {
                    return 0;
                }
                if (bi1 == null && bi2 != null) {
                    return 1;
                }
                if (bi1 != null && bi2 == null) {
                    return -1;
                }
                return ((FamBox)o1).sosa.compareTo(((FamBox)o2).sosa);
            });
            int i = 1;
            for (FamBox fb : list) {
                fb.index = i++;
                fb.indexTotal = list.size();
            }
        }
    }
}

