/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.search.Matcher;
import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class Hit {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private static final SimpleAttributeSet PLAIN = new SimpleAttributeSet();
    private static final SimpleAttributeSet RED = new SimpleAttributeSet();
    private static final SimpleAttributeSet BOLD = new SimpleAttributeSet();
    private static final Color[] FG_COLORS = new Color[2];
    private Property property;
    private ImageIcon img;
    private StyledDocument doc;
    private int entity;

    public Hit(Property setProp, String value, Matcher.Match[] matches, int setEntity, boolean isID) {
        this.property = setProp;
        this.img = this.property.getImage(false);
        this.entity = setEntity;
        this.doc = new DefaultStyledDocument();
        Color c = FG_COLORS[setEntity & 1];
        StyleConstants.setForeground(PLAIN, c);
        StyleConstants.setForeground(BOLD, c);
        try {
            int offset = 0;
            String tag = setProp.getPropertyName();
            this.doc.insertString(offset++, " ", PLAIN);
            if (setProp instanceof Entity) {
                tag = "";
            }
            if (!isID) {
                this.doc.insertString(offset, tag, BOLD);
                offset += tag.length();
                this.doc.insertString(offset++, " ", PLAIN);
            }
            this.doc.insertString(offset, value, PLAIN);
            if (matches != null) {
                for (int i = 0; i < matches.length; ++i) {
                    Matcher.Match m = matches[i];
                    this.doc.setCharacterAttributes(offset + m.pos, m.len, RED, false);
                }
            }
            offset += value.length();
            if (isID) {
                this.doc.insertString(offset++, " ", PLAIN);
                this.doc.insertString(offset, tag, BOLD);
            }
            SimpleAttributeSet localImg = new SimpleAttributeSet();
            JLabel jl = new JLabel((Icon)setProp.getImage(false));
            jl.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            StyleConstants.setComponent(localImg, jl);
            this.doc.insertString(0, " ", localImg);
            this.doc.insertString(0, "[" + setProp.getEntity().getId() + "] ", PLAIN);
        }
        catch (BadLocationException e) {
            LOG.log(Level.INFO, "Error during hit creation", e);
        }
    }

    StyledDocument getDocument() {
        return this.doc;
    }

    Property getProperty() {
        return this.property;
    }

    ImageIcon getImage() {
        return this.img;
    }

    int getEntity() {
        return this.entity;
    }

    public String toString() {
        return this.property != null ? this.property.toString() : "isNull";
    }

    static {
        StyleConstants.setForeground(RED, Color.RED);
        StyleConstants.setBold(BOLD, true);
        Hit.FG_COLORS[0] = Color.BLACK;
        Hit.FG_COLORS[1] = new Color(0, 51, 241);
    }
}

