/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.agecalc;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.gedcom.agecalc.AgeCalcPanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.UnitOfWork;
import genj.gedcom.time.PointInTime;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AgeCalclAction
extends AbstractAncestrisContextAction {
    private Context contextToOpen = null;
    private Gedcom gedcom = null;

    public AgeCalclAction() {
        this.setImage("ancestris/modules/gedcom/agecalc/agecalc16.png");
        this.setText(NbBundle.getMessage(AgeCalclAction.class, (String)"CTL_AgeCalcAction", (Object)""));
        this.setTip(NbBundle.getMessage(AgeCalclAction.class, (String)"CTL_AgeCalcAction.tip"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        this.contextToOpen = this.getContext();
        this.gedcom = this.contextToOpen.getGedcom();
        final AgeCalcPanel ageCalcPanel = new AgeCalcPanel(this.getContext());
        Object choice = DialogManager.create((String)NbBundle.getMessage(AgeCalclAction.class, (String)"AgeCalclAction.AskParams"), (JComponent)ageCalcPanel).setMessageType(3).setOptionType(2).setDialogId("ageCalcPanel").show();
        if (choice == DialogManager.OK_OPTION) {
            ageCalcPanel.savePreferences();
            try {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        AgeCalclAction.this.calculateAges(gedcom, ageCalcPanel.isOverwrite(), ageCalcPanel.isAfterDeath(), ageCalcPanel.isGuessed());
                    }
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void calculateAges(Gedcom gedcom, boolean overwriteAgeString, boolean guessedAfterDeath, boolean isGuessed) {
        for (Indi indi : gedcom.getIndis()) {
            PointInTime pitBirth = indi.getStartPITOfAge();
            if (pitBirth == null || !pitBirth.isValid()) continue;
            PropertyDate deathDate = indi.getDeathDate();
            if (!guessedAfterDeath) {
                deathDate = null;
            }
            for (PropertyEventDetails event : indi.getEvents()) {
                PropertyDate eventDate = event.getDate();
                if (eventDate == null) continue;
                event.updateAge(true, overwriteAgeString, deathDate != null && deathDate.isValid() && eventDate.compareTo((Property)deathDate) > 0 || isGuessed);
            }
        }
    }
}

