/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom.privacy;

import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Delta;
import org.openide.util.Lookup;

public abstract class PrivacyPolicy {
    private static PrivacyPolicy defaultInstance = null;

    public String getDisplayValue(Property prop) {
        return this.isPrivate(prop) ? this.getPrivateMask() : prop.getDisplayValue();
    }

    public String getDisplayValue(Property prop, String tag) {
        if (prop == null) {
            return "";
        }
        return (prop = prop.getProperty(tag)) == null ? "" : this.getDisplayValue(prop);
    }

    public abstract boolean isPrivate(Property var1);

    public abstract PrivacyPolicy getAllPublic();

    public abstract PrivacyPolicy getAllPrivate();

    public abstract String getPrivateMask();

    public void openPreferences() {
    }

    public static PrivacyPolicy getDefault() {
        PrivacyPolicy instance = (PrivacyPolicy)Lookup.getDefault().lookup(PrivacyPolicy.class);
        return instance != null ? instance : PrivacyPolicy.getDefaultInstance();
    }

    private static synchronized PrivacyPolicy getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DefaultPrivacyPolicy();
        }
        return defaultInstance;
    }

    private static class DefaultPrivacyPolicy
    extends PrivacyPolicy {
        private int yearsInfoIsPrivate = 100;
        private String tagMarkingPrivate = "_PRIV";
        private String mask = "...";
        private static final PrivacyPolicy PUBLIC = new DefaultPrivacyPolicy(){

            @Override
            public boolean isPrivate(Property prop) {
                return false;
            }
        };
        private static final PrivacyPolicy PRIVATE = new DefaultPrivacyPolicy(){

            @Override
            public boolean isPrivate(Property prop) {
                return true;
            }
        };

        @Override
        public PrivacyPolicy getAllPublic() {
            return PUBLIC;
        }

        @Override
        public PrivacyPolicy getAllPrivate() {
            return PRIVATE;
        }

        private DefaultPrivacyPolicy() {
        }

        @Override
        public String getPrivateMask() {
            return this.mask;
        }

        @Override
        public boolean isPrivate(Property prop) {
            return this.isPrivate(prop, true);
        }

        private boolean isPrivate(Property prop, boolean checkSpouses) {
            if (prop == null) {
                return false;
            }
            if (this.tagMarkingPrivate != null && this.hasTagMarkingPrivate(prop)) {
                return this.cacheProp(prop, true);
            }
            if (this.yearsInfoIsPrivate > 0 && this.isWithinPrivateYears(prop)) {
                return this.cacheProp(prop, true);
            }
            boolean result = this.isPrivate(prop.getParent());
            if (result) {
                return this.cacheProp(prop, true);
            }
            return this.cacheProp(prop, false);
        }

        private boolean cacheProp(Property prop, boolean priv) {
            return priv;
        }

        private boolean hasTagMarkingPrivate(Property prop) {
            return this.getPropertyFor(prop, this.tagMarkingPrivate, Property.class) != null;
        }

        private boolean isWithinPrivateYears(Property prop) {
            PropertyDate date = (PropertyDate)this.getPropertyFor(prop, "DATE", PropertyDate.class);
            if (date == null) {
                return false;
            }
            Delta anniversary = date.getAnniversary();
            return anniversary != null && anniversary.getYears() < this.yearsInfoIsPrivate;
        }

        private Property getPropertyFor(Property prop, String tag, Class<? extends Property> type) {
            int j = prop.getNoOfProperties();
            for (int i = 0; i < j; ++i) {
                Property child = prop.getProperty(i);
                if (!this.is(child, tag, type)) continue;
                return child;
            }
            return null;
        }

        private boolean is(Property prop, String tag, Class<? extends Property> type) {
            return prop.getTag().equals(tag) && type.isAssignableFrom(prop.getClass());
        }
    }
}

