/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertySimpleValue;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class MetaProperty
implements Comparable<MetaProperty> {
    public static final int WHERE_NOT_HIDDEN = 1;
    public static final int WHERE_DEFAULT = 2;
    public static final int WHERE_CARDINALITY_ALLOWS = 4;
    public static final int INCLUDE_ADVANCED = 8;
    private static Map<String, ImageIcon> name2images = new HashMap<String, ImageIcon>();
    public static final ImageIcon IMG_CUSTOM = MetaProperty.loadImage("Attribute");
    public static final ImageIcon IMG_LINK = MetaProperty.loadImage("Association");
    public static final ImageIcon IMG_UNKNOWN = MetaProperty.loadImage("Question");
    public static final ImageIcon IMG_ERROR = MetaProperty.loadImage("Error");
    public static final ImageIcon IMG_WARNING = MetaProperty.loadImage("Warning");
    public static final ImageIcon IMG_PRIVATE = MetaProperty.loadImage("Private");
    private Grammar grammar;
    private String tag;
    private ImageIcon image;
    private String name;
    private String names;
    private Class<? extends Property>[] types;
    private String info;
    private boolean isInstantiated = false;
    private boolean isGrammar;
    private Map<String, String> attrs;
    private Map<String, MetaProperty> tag2nested = new HashMap<String, MetaProperty>();
    List<MetaProperty> nested = new ArrayList<MetaProperty>();

    MetaProperty(Grammar grammar, String tag, Map<String, String> attributes, boolean isGrammar) {
        this.grammar = grammar;
        this.tag = tag;
        this.attrs = attributes;
        this.isGrammar = isGrammar;
        MetaProperty spr = this.getSuper();
        if (spr != null) {
            this.copyAttributesFrom(spr);
        }
    }

    private void copyAttributesFrom(MetaProperty supr) {
        for (MetaProperty sub : new ArrayList<MetaProperty>(supr.nested)) {
            if ("0".equals(sub.attrs.get("inherit"))) continue;
            this.addNested(sub);
        }
        if (this.getAttribute("type") == null) {
            this.attrs.put("type", supr.getAttribute("type"));
        }
        if (this.getAttribute("img") == null) {
            this.attrs.put("img", supr.getAttribute("img"));
        }
        if (this.getAttribute("cardinality") == null) {
            this.attrs.put("cardinality", supr.getAttribute("cardinality"));
        }
        if (this.getAttribute("hide") == null) {
            this.attrs.put("hide", supr.getAttribute("hide"));
        }
        if (supr.getAttribute("super") == null) {
            this.attrs.remove("super");
        }
    }

    public MetaProperty getSuper() {
        String path = this.attrs.get("super");
        return path == null ? null : this.grammar.getMetaRecursively(new TagPath(path), false);
    }

    void redoSuper(List<MetaProperty> alreadyVisited) {
        MetaProperty spr = this.getSuper();
        if (spr != null) {
            this.copyAttributesFrom(spr);
        }
        if (alreadyVisited.contains(this)) {
            return;
        }
        alreadyVisited.add(this);
        for (MetaProperty nest : this.nested) {
            nest.redoSuper(alreadyVisited);
        }
    }

    synchronized void addNested(MetaProperty sub) {
        if (sub == null) {
            throw new IllegalArgumentException("Nested meta can't be null");
        }
        this.tag2nested.put(sub.tag, sub);
        for (int i = 0; i < this.nested.size(); ++i) {
            MetaProperty other = this.nested.get(i);
            if (!other.tag.equals(sub.tag)) continue;
            sub.copyAttributesFrom(other);
            this.nested.set(i, sub);
            return;
        }
        this.nested.add(sub);
    }

    MetaProperty[] getAllNested(Property parent, int filter) {
        ArrayList<MetaProperty> result = new ArrayList<MetaProperty>(this.nested.size());
        for (int s = 0; s < this.nested.size(); ++s) {
            String hide;
            MetaProperty sub = this.nested.get(s);
            if ((filter & 2) != 0 && !sub.isDefault() || (filter & 9) != 0 && (hide = sub.getAttribute("hide")) != null && ((filter & 1) != 0 || !hide.equals("2")) || "0".equals(sub.getAttribute("xref")) && parent instanceof PropertyXRef || "1".equals(sub.getAttribute("xref")) && !(parent instanceof PropertyXRef) || (filter & 4) != 0 && sub.isSingleton() && parent.getProperty(sub.getTag()) != null) continue;
            result.add(sub);
        }
        return result.toArray(new MetaProperty[result.size()]);
    }

    String getAttribute(String key) {
        return this.attrs.get(key);
    }

    void assertTag(String tag) throws GedcomException {
        if (!this.tag.equals(tag)) {
            throw new GedcomException("Tag should be " + tag + " but is " + this.tag);
        }
    }

    public boolean isEntity() {
        return Entity.class.isAssignableFrom(this.getType());
    }

    public boolean isSingleton() {
        String c = this.getAttribute("cardinality");
        return c != null && c.endsWith(":1");
    }

    public boolean isVersion(String version) {
        String v = this.getAttribute("gedcom");
        return v == null || v.equals(version);
    }

    public boolean isDefault() {
        String isDefault = this.getAttribute("default");
        return isDefault != null && "1".equals(isDefault);
    }

    public boolean isRequired() {
        String c = this.getAttribute("cardinality");
        return c != null && c.startsWith("1:");
    }

    @Override
    public int compareTo(MetaProperty other) {
        return Collator.getInstance().compare(this.getName(), other.getName());
    }

    public boolean allows(String sub) {
        MetaProperty meta = this.tag2nested.get(sub);
        return meta == null ? false : meta.isGrammar;
    }

    public boolean allows(String sub, Class<? extends Property> type) {
        MetaProperty meta = this.tag2nested.get(sub);
        return meta != null && type.isAssignableFrom(meta.getType());
    }

    public Property create(String value) throws GedcomException {
        Property result = null;
        try {
            result = this.getType(value).getDeclaredConstructor(String.class).newInstance(this.getTag());
        }
        catch (Exception e) {
            Gedcom.LOG.log(Level.WARNING, "Couldn't instantiate property " + this.getType() + " with value '" + value, e);
            result = new PropertySimpleValue(this.getTag());
        }
        if (value != null) {
            String escapedValue = value.replaceAll("@@", "@");
            result.setValue(escapedValue);
        }
        this.isInstantiated = true;
        return result;
    }

    public boolean isInstantiated() {
        return this.isInstantiated;
    }

    public void setIsInstantiated(boolean isInstantiated) {
        this.isInstantiated = isInstantiated;
    }

    public ImageIcon getImage() {
        if (this.image == null) {
            String s = this.getAttribute("img");
            this.image = s == null ? (this.getTag().startsWith("_") ? IMG_CUSTOM : IMG_UNKNOWN) : MetaProperty.loadImage(s);
        }
        return this.image;
    }

    public ImageIcon getImage(String postfix) {
        String name = this.getAttribute("img." + postfix);
        if (name == null) {
            if ("err".equals(postfix)) {
                return IMG_ERROR;
            }
            if ("warn".equals(postfix)) {
                return IMG_WARNING;
            }
            return this.getImage();
        }
        return MetaProperty.loadImage(name.toString());
    }

    public String getTag() {
        return this.tag;
    }

    public Class<? extends Property> getType() {
        return this.getTypes()[0];
    }

    public Class<? extends Property> getType(String value) {
        for (Class<? extends Property> type : this.getTypes()) {
            if (PropertyXRef.class.isAssignableFrom(type) && (!value.trim().startsWith("@") || !value.trim().endsWith("@")) || PropertyXRef.class.isAssignableFrom(type) && value.trim().startsWith("@@")) continue;
            return type;
        }
        return PropertySimpleValue.class;
    }

    public Class<? extends Property>[] getTypes() {
        if (this.types == null) {
            String attrType = this.getAttribute("type");
            if (attrType == null) {
                this.types = new Class[]{PropertySimpleValue.class};
            } else {
                try {
                    String[] attrTypes = attrType.split("\\|");
                    this.types = new Class[attrTypes.length];
                    for (int i = 0; i < attrTypes.length; ++i) {
                        this.types[i] = Class.forName("genj.gedcom." + attrTypes[i]);
                    }
                }
                catch (Throwable t) {
                    Gedcom.LOG.log(Level.WARNING, "Property type(s) genj.gedcom." + attrType + " couldn't be instantiated", t);
                    this.types = new Class[]{PropertySimpleValue.class};
                }
            }
        }
        return this.types;
    }

    public String getName() {
        return this.getName(false);
    }

    public String getCardinality() {
        return this.attrs.get("cardinality");
    }

    public int getMaxCardinality() {
        String num;
        String[] bits;
        int maxCardinality = Integer.MAX_VALUE;
        String c = this.getAttribute("cardinality");
        if (c != null && (bits = c.split(":")).length == 2 && !(num = bits[1].replaceAll("[^0-9]", "")).isEmpty()) {
            maxCardinality = Integer.parseInt(bits[1]);
        }
        return maxCardinality;
    }

    public String getName(boolean plural) {
        String result;
        if (plural) {
            result = this.names;
            if (result == null) {
                result = Gedcom.getName(this.tag, true);
            }
            this.names = result;
        } else {
            result = this.name;
            if (result == null) {
                result = Gedcom.getName(this.tag, false);
            }
            this.name = result;
        }
        return result;
    }

    public String getInfo() {
        if (this.info == null) {
            this.info = Gedcom.getResources().getString(this.tag + ".info", false);
            if (this.info == null) {
                char c = this.tag.charAt(0);
                if (c != '_') {
                    c = '?';
                }
                this.info = Gedcom.getResources().getString(c + ".info");
            }
            this.info = this.getName() + ":\n" + this.info;
        }
        return this.info;
    }

    public MetaProperty getNestedRecursively(TagPath path, boolean persist) {
        String tag = path.get(0);
        if (!this.tag.equals(tag) && !".".equals(tag)) {
            throw new IllegalArgumentException();
        }
        return this.getNestedRecursively(path, 1, persist);
    }

    MetaProperty getNestedRecursively(TagPath path, int pos, boolean persist) {
        if (pos == path.length()) {
            return this;
        }
        return this.getNested(path.get(pos), persist).getNestedRecursively(path, pos + 1, persist);
    }

    public MetaProperty getNested(String tag, boolean persist) {
        if (tag == null || tag.length() == 0) {
            throw new IllegalArgumentException("tag can't be empty");
        }
        MetaProperty result = this.tag2nested.get(tag);
        if (result == null) {
            result = new MetaProperty(this.grammar, tag, new HashMap<String, String>(), false);
            if (persist) {
                this.addNested(result);
            }
        }
        return result;
    }

    public int getNestedIndex(String subtag) {
        if (subtag.equals("CHAN")) {
            return Integer.MAX_VALUE;
        }
        for (int i = 0; i < this.nested.size(); ++i) {
            if (!this.nested.get(i).getTag().equals(subtag)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    public MetaProperty[] getNestedChildren() {
        return this.nested.toArray(new MetaProperty[this.nested.size()]);
    }

    public static ImageIcon loadImage(String name) {
        ImageIcon result = name2images.get(name);
        if (result == null) {
            try {
                while (true) {
                    try {
                        result = new ImageIcon(MetaProperty.class, "images/" + name);
                        name2images.put(name, result);
                    }
                    catch (IllegalStateException illegalStateException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                Gedcom.LOG.log(Level.WARNING, "Unexpected problem reading " + name, t);
                return IMG_ERROR;
            }
        }
        return result;
    }

    public String toString() {
        return this.getTag() + this.attrs;
    }
}

