/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.io.FileAssociation;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import genj.util.swing.ImageIcon;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbPreferences;

public class PropertyFile
extends Property {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    public static final ImageIcon DEFAULT_IMAGE = Grammar.V55.getMeta(new TagPath("INDI:OBJE:FILE")).getImage();
    private String file;
    private boolean forceRelative = true;
    private boolean isLocal = true;
    private boolean isRemote = false;
    private Optional<InputSource> input = Optional.empty();

    public PropertyFile(String tag) {
        super(tag);
    }

    public boolean isIsLocal() {
        return this.isLocal;
    }

    public boolean isIsRemote() {
        return this.isRemote;
    }

    @Override
    public boolean isValid() {
        if (!NbPreferences.forModule(Gedcom.class).getBoolean("isFileNotFoundValid", false)) {
            this.forceInput();
            this.updateFileFlags();
            return this.isLocal || this.isRemote;
        }
        return super.isValid();
    }

    @Override
    public boolean addFile(InputSource file) {
        this.setValue(file.getLocation(), true);
        return true;
    }

    @Override
    public String getValue() {
        String relative;
        Gedcom gedcom;
        if (this.file == null) {
            return "";
        }
        if (this.forceRelative && (gedcom = this.getGedcom()) != null && (relative = gedcom.getOrigin().calcRelativeLocation(this.file)) != null) {
            this.file = relative;
        }
        return this.file;
    }

    @Override
    public synchronized void setValue(String value) {
        String newValue = value;
        if (value.startsWith("file://")) {
            newValue = value.substring(7);
        }
        String old = this.getValue();
        this.file = newValue.replace('\\', '/');
        this.forceRelative = true;
        this.forceInput();
        this.updateFileFlags();
        this.propagatePropertyChanged(this, old);
    }

    private void forceInput() {
        File fichier = this.getFile();
        if (fichier == null) {
            this.isLocal = false;
            this.isRemote = false;
            this.input = Optional.empty();
            return;
        }
        if (fichier.exists()) {
            this.isLocal = true;
            this.isRemote = false;
            this.input = InputSource.get(fichier);
            return;
        }
        try {
            URL remote = new URL(this.file);
            this.isLocal = false;
            this.isRemote = true;
            this.input = InputSource.get(remote);
            return;
        }
        catch (MalformedURLException mfue) {
            LOG.log(Level.FINEST, "URL exception.", mfue.getLocalizedMessage());
            this.isLocal = false;
            this.isRemote = false;
            this.input = Optional.empty();
            return;
        }
    }

    private void updateFileFlags() {
        this.updateFileSubProperty("_LOCAL", !this.isRemote ? "1" : "0");
        this.updateFileSubProperty("_FOUND", this.isLocal || this.isRemote ? "1" : "0");
    }

    private String updateFileSubProperty(String tag, String value) {
        String oldValue;
        Property sub = this.getProperty(tag);
        String string = oldValue = sub != null ? sub.getValue() : "";
        if (sub == null) {
            if (!value.isEmpty() && this.getParent() != null) {
                sub = this.addProperty(tag, value);
                sub.setGuessed(true);
                return sub.getValue();
            }
            return "";
        }
        if (value == null || value.isEmpty()) {
            this.delProperty(sub);
            return "";
        }
        if (!value.equals(oldValue)) {
            sub.setValue(value);
        }
        sub.setGuessed(true);
        return sub.getValue();
    }

    public synchronized void setValueAsIs(String value) {
        String old = this.getValue();
        this.file = value.replace('\\', '/');
        this.forceRelative = false;
        this.propagatePropertyChanged(this, old);
    }

    public void setValue(String value, boolean updateMeta) {
        Property form;
        this.setValue(value);
        Property media = this.getParent();
        if (!updateMeta || !media.getTag().equals("OBJE")) {
            return;
        }
        Property parent = this;
        if (!this.getMetaProperty().allows("FORM")) {
            if (!media.getMetaProperty().allows("FORM")) {
                return;
            }
            parent = media;
        }
        if ((form = parent.getProperty("FORM", false)) == null) {
            parent.addProperty("FORM", this.getSuffix());
        } else {
            form.setValue(this.getSuffix());
        }
    }

    private File getFile() {
        Gedcom gedcom = this.getGedcom();
        return gedcom != null ? gedcom.getOrigin().getFile(this.file) : null;
    }

    public Optional<InputSource> getInput() {
        if (this.input.isPresent()) {
            return this.input;
        }
        this.forceInput();
        return this.input;
    }

    public static int getMaxValueAsIconSize(boolean kb) {
        return (kb ? 1 : 1024) * GedcomOptions.getInstance().getMaxImageFileSizeKB();
    }

    public String getSuffix() {
        this.getInput();
        if (this.input.isPresent()) {
            return this.input.get().getExtension();
        }
        return PropertyFile.getSuffix(this.file);
    }

    private static String getSuffix(String value) {
        int j;
        int i;
        String result = "";
        if (value != null && (i = value.lastIndexOf(46)) >= 0 && (j = (result = value.substring(i + 1)).indexOf(63)) > 0) {
            result = result.substring(0, j);
        }
        return result;
    }

    public boolean isOpenable() {
        Optional<InputSource> oInput = this.getInput();
        if (!oInput.isPresent()) {
            return false;
        }
        InputSource inputSource = oInput.get();
        return inputSource instanceof FileInput || inputSource instanceof URLInput;
    }

    public void openFile() {
        Optional<InputSource> oInput = this.getInput();
        if (!oInput.isPresent()) {
            return;
        }
        InputSource inputSource = oInput.get();
        if (inputSource instanceof FileInput) {
            FileAssociation.getDefault().execute(((FileInput)inputSource).getFile());
        }
        if (inputSource instanceof URLInput) {
            FileAssociation.getDefault().execute(((URLInput)inputSource).getURL());
        }
    }
}

