/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Property;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyTime
extends Property {
    private static final Logger LOGGER = Logger.getLogger("genj.gedcom.propertytime");
    public static String TIME = "TIME";
    private static final String TIME_PATTERN = "%02d:%02d:%02.0f";
    private int hour = 0;
    private int minute = 0;
    private float second = 0.0f;
    private String value;
    private boolean isValid = false;

    public PropertyTime() {
        super(TIME);
    }

    public PropertyTime(String tag) {
        super(tag);
    }

    @Override
    public String getValue() {
        if (this.isValid) {
            return String.format(TIME_PATTERN, this.hour, this.minute, Float.valueOf(this.second));
        }
        return this.value;
    }

    @Override
    public void setValue(String value) {
        String old = this.value;
        this.value = value;
        try {
            StringTokenizer st = new StringTokenizer(value, ":");
            if (st.hasMoreTokens()) {
                this.hour = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.minute = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.second = Math.round(Float.parseFloat(st.nextToken()));
            }
            this.isValid = true;
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINE, "Unable to parse time value : " + value, e);
        }
        this.propagatePropertyChanged(this, old);
    }
}

