/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.time.PointInTime;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import java.util.HashMap;
import java.util.Map;

public abstract class Calendar {
    protected String escape;
    protected String name;
    protected ImageIcon image;
    protected String[] months;
    protected String[] monthsLowerCase;
    protected String[] weekDays;
    protected String[] localizedWeekDays;
    protected Map<String, String> localizedMonthNames = new HashMap<String, String>();
    protected Map<String, String> abbreviatedMonthNames = new HashMap<String, String>();
    protected static final Resources resources = PointInTime.resources;
    public static final String TXT_CALENDAR_SWITCH = resources.getString("cal.switch");
    public static final String TXT_CALENDAR_RESET = resources.getString("cal.reset");

    protected Calendar(String esc, String key, String img, String[] mOnths, String[] weEkDays) {
        this.months = mOnths;
        this.monthsLowerCase = new String[this.months.length];
        for (int i = 0; i < this.months.length; ++i) {
            this.monthsLowerCase[i] = this.months[i].toLowerCase();
        }
        this.escape = esc;
        this.name = resources.getString("cal." + key);
        this.image = new ImageIcon(Gedcom.class, img);
        this.weekDays = weEkDays;
        this.localizedWeekDays = new String[this.weekDays.length];
        for (int wd = 0; wd < this.weekDays.length; ++wd) {
            this.localizedWeekDays[wd] = resources.getString("day." + this.weekDays[wd]);
        }
        for (int m = 0; m < this.months.length; ++m) {
            String abbreviated;
            String mmm = this.months[m];
            String localized = resources.getString("mon." + mmm);
            int marker = localized.indexOf(124);
            if (marker > 0) {
                abbreviated = localized.substring(0, marker);
                localized = abbreviated + localized.substring(marker + 1);
            } else {
                marker = localized.indexOf(44);
                if (marker > 0) {
                    abbreviated = localized.substring(marker + 1);
                    localized = localized.substring(0, marker);
                } else {
                    abbreviated = localized.length() > 3 ? localized.substring(0, 3) : localized;
                }
            }
            this.localizedMonthNames.put(mmm, localized);
            this.abbreviatedMonthNames.put(mmm, abbreviated);
        }
    }

    public String getName() {
        return this.name;
    }

    public ImageIcon getImage() {
        return this.image;
    }

    protected int parseMonth(String mmm) throws NumberFormatException {
        String mmmLowerCase = mmm.toLowerCase();
        for (int i = 0; i < this.months.length; ++i) {
            if (!this.monthsLowerCase[i].equals(mmmLowerCase)) continue;
            return i;
        }
        throw new NumberFormatException();
    }

    public String getDay(int day) {
        if (day == Integer.MAX_VALUE) {
            return "";
        }
        return "" + (day + 1);
    }

    public String[] getMonths(boolean localize) {
        String[] result = new String[this.months.length];
        for (int m = 0; m < result.length; ++m) {
            String mmm = this.months[m];
            if (localize) {
                mmm = this.localizedMonthNames.get(mmm).toString();
            }
            result[m] = mmm;
        }
        return result;
    }

    public String getMonth(int month) {
        if (month < 0 || month >= this.months.length) {
            return "";
        }
        return this.months[month];
    }

    public String getDisplayMonth(int month, boolean abbrev) {
        String mmm = this.getMonth(month);
        if (mmm.length() == 0) {
            return mmm;
        }
        return abbrev ? this.abbreviatedMonthNames.get(mmm).toString() : this.localizedMonthNames.get(mmm).toString();
    }

    public String getYear(int year) {
        if (year == Integer.MAX_VALUE) {
            return "";
        }
        return "" + year;
    }

    public String getDisplayYear(int year) {
        return this.getYear(year);
    }

    public int getYear(String year) throws GedcomException {
        try {
            return Integer.parseInt(year);
        }
        catch (NumberFormatException e) {
            throw new GedcomException(resources.getString("year.invalid"));
        }
    }

    public int getMonths() {
        return this.months.length;
    }

    public abstract int getDays(int var1, int var2);

    protected String getDayOfWeek(PointInTime pit, boolean localize) throws GedcomException {
        if (!pit.isComplete()) {
            throw new GedcomException(resources.getString("pit.incomplete"));
        }
        String[] result = localize ? this.localizedWeekDays : this.weekDays;
        int dow = (pit.getJulianDay() + 1) % 7;
        return result[dow >= 0 ? dow : dow + 7];
    }

    protected final int toJulianDay(PointInTime pit) throws GedcomException {
        int year = pit.getYear();
        int month = pit.getMonth();
        int day = pit.getDay();
        if (year == Integer.MAX_VALUE || year == 0) {
            throw new GedcomException(resources.getString("year.invalid"));
        }
        if (month == Integer.MAX_VALUE && day != Integer.MAX_VALUE) {
            throw new GedcomException(resources.getString("month.invalid"));
        }
        if (month == Integer.MAX_VALUE) {
            month = 0;
        } else if (month < 0 || month >= this.months.length) {
            throw new GedcomException(resources.getString("month.invalid"));
        }
        if (day == Integer.MAX_VALUE) {
            day = 0;
        } else if (day < 0 || day >= this.getDays(month, year)) {
            throw new GedcomException(resources.getString("day.invalid"));
        }
        return this.toJulianDay(day, month, year);
    }

    protected abstract int toJulianDay(int var1, int var2, int var3) throws GedcomException;

    protected abstract PointInTime toPointInTime(int var1) throws GedcomException;

    public String toString() {
        return this.getName();
    }
}

