/*
 * Decompiled with CFR 0.152.
 */
package genj.io.input;

import genj.io.InputSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URLInput
extends InputSource {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    public static final String WEB = "web";
    private URL url;
    private String extension;
    private boolean isAvailable = true;
    private boolean checkRedirect = false;

    public URLInput(URL theUrl) {
        this(theUrl.getFile(), theUrl);
    }

    public URLInput(String name, URL theUrl) {
        super(name);
        this.url = theUrl;
        this.setLocation(theUrl.toString());
    }

    public URL getURL() {
        return this.url;
    }

    @Override
    public InputStream open() throws IOException {
        if (!this.isAvailable) {
            return null;
        }
        this.checkRedirection();
        try {
            return this.url.openStream();
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, "Unable to open remote adress " + this.url.toString(), ioe);
            this.isAvailable = false;
            return null;
        }
    }

    public int hashCode() {
        return this.url.hashCode() * this.getName().hashCode();
    }

    public String toString() {
        return "file name=" + this.getName() + " url=" + this.url.toString();
    }

    @Override
    public String getExtension() {
        if (this.extension == null) {
            this.extension = this.setExtension();
        }
        return this.extension;
    }

    private String setExtension() {
        if (!this.isAvailable) {
            return WEB;
        }
        this.checkRedirection();
        try {
            String type = URLConnection.guessContentTypeFromStream(this.url.openStream());
            LOG.log(Level.FINE, "Media " + this.getName() + " type from internet : " + type);
            if (type == null) {
                type = this.url.openConnection().getContentType();
                if (type == null) {
                    return WEB;
                }
                LOG.log(Level.FINE, "Media " + this.getName() + " type from internet : " + type);
            }
            if (type.startsWith("image/")) {
                return type.substring(6);
            }
            return WEB;
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "Unable to open remote adress " + this.url.toString(), e);
            return WEB;
        }
    }

    private void checkRedirection() {
        if (this.checkRedirect) {
            return;
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
            conn.setInstanceFollowRedirects(true);
            int rcode = conn.getResponseCode();
            if (rcode == 301 || rcode == 302 || rcode == 303) {
                this.url = new URL(conn.getHeaderField("Location"));
            }
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "Unable to open remote adress " + this.url.toString(), e);
            this.isAvailable = false;
        }
        this.checkRedirect = true;
    }
}

