/*
 * Decompiled with CFR 0.152.
 */
package genj.print;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.util.swing.DialogManager;
import genj.print.PrintRenderer;
import genj.print.PrintTask;
import genj.print.PrintWidget;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintException;
import org.openide.DialogDescriptor;

public abstract class PrintAction
extends AbstractAncestrisAction {
    private static final Resources RES = Resources.get(PrintAction.class);
    private static final ImageIcon IMG = new ImageIcon(PrintAction.class, "images/Print.png");
    private static final Logger LOG = Logger.getLogger("ancestris.print");
    private String title;

    public PrintAction(String title) {
        this.setText(RES.getString("print"));
        this.setTip(this.getText());
        this.setImage(IMG);
        this.title = RES.getString("title", title);
    }

    protected abstract PrintRenderer getRenderer();

    @Override
    public void actionPerformed(ActionEvent e) {
        PrintTask task;
        try {
            task = new PrintTask(this.title, this.getRenderer());
        }
        catch (PrintException pe) {
            LOG.log(Level.INFO, "can't setup print task", pe);
            DialogManager.createError(this.title, pe.getMessage()).show();
            return;
        }
        PrintWidget widget = new PrintWidget(task);
        String printChoice = new String(RES.getString("print"));
        Object choice = DialogManager.create(this.title, widget).setOptions(new Object[]{printChoice, DialogDescriptor.CANCEL_OPTION}).setDialogId("printaction").show();
        if (choice != printChoice || task.getPages().width == 0 || task.getPages().height == 0) {
            return;
        }
        widget.commit();
        task.print();
    }
}

