/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.genids;

import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GenIDPanel
extends JPanel {
    private Context context;
    private Registry registry = null;
    private Settings settings = new Settings();
    private JComponent[] cats = null;
    private JComponent[] singles = null;
    private boolean validChange = false;
    private boolean validFrom = false;
    private boolean validTo = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCID;
    private JCheckBox jCheckBoxAllCat;
    private JCheckBox jCheckBoxFam;
    private JCheckBox jCheckBoxIndi;
    private JCheckBox jCheckBoxNote;
    private JCheckBox jCheckBoxObje;
    private JCheckBox jCheckBoxRepo;
    private JCheckBox jCheckBoxSour;
    private JCheckBox jCheckBoxSubm;
    private JLabel jLabel1;
    private JLabel jLabelFromName;
    private JLabel jLabelIDFrom;
    private JLabel jLabelIDTo;
    private JLabel jLabelLen;
    private JLabel jLabelLetterContent;
    private JLabel jLabelLetterTitle;
    private JLabel jLabelPrefix;
    private JLabel jLabelSuffix;
    private JLabel jLabelToStatus;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonCategory;
    private JRadioButton jRadioButtonSingle;
    private JTextField jTextFieldIDFrom;
    private JTextField jTextFieldIDTo;
    private JTextField jTextFieldLen;
    private JTextField jTextFieldPrefix;
    private JTextField jTextFieldSuffix;

    public GenIDPanel(final Context context) {
        this.context = context;
        this.registry = context.getGedcom().getRegistry();
        this.initComponents();
        this.jCheckBoxIndi.setText(Gedcom.getName((String)"INDI"));
        this.jCheckBoxFam.setText(Gedcom.getName((String)"FAM"));
        this.jCheckBoxNote.setText(Gedcom.getName((String)"NOTE"));
        this.jCheckBoxObje.setText(Gedcom.getName((String)"OBJE"));
        this.jCheckBoxSour.setText(Gedcom.getName((String)"SOUR"));
        this.jCheckBoxRepo.setText(Gedcom.getName((String)"REPO"));
        this.jCheckBoxSubm.setText(Gedcom.getName((String)"SUBM"));
        this.cats = new JComponent[]{this.jCheckBoxIndi, this.jCheckBoxFam, this.jCheckBoxObje, this.jCheckBoxNote, this.jCheckBoxSour, this.jCheckBoxSubm, this.jCheckBoxRepo, this.jCheckBoxAllCat, this.jLabelLetterTitle, this.jLabelLetterContent, this.jLabelPrefix, this.jTextFieldPrefix, this.jLabelLen, this.jTextFieldLen, this.jLabelSuffix, this.jTextFieldSuffix};
        this.singles = new JComponent[]{this.jLabelIDFrom, this.jTextFieldIDFrom, this.jButtonCID, this.jLabelFromName, this.jLabelIDTo, this.jTextFieldIDTo, this.jLabelToStatus};
        this.jLabelFromName.setText("");
        this.jLabelToStatus.setText("");
        this.jTextFieldIDFrom.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateFromEntity();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateFromEntity();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateFromEntity();
            }

            public void updateFromEntity() {
                String str = GenIDPanel.this.jTextFieldIDFrom.getText().trim();
                Entity ent = context.getGedcom().getEntity(str);
                GenIDPanel.this.validFrom = ent != null;
                GenIDPanel.this.jLabelFromName.setText(GenIDPanel.this.validFrom ? ent.toString(false) : NbBundle.getMessage(GenIDPanel.class, (String)"Msg_UnknownEntity"));
                GenIDPanel.this.jLabelFromName.setForeground(GenIDPanel.this.validFrom ? Color.BLACK : Color.RED);
                GenIDPanel.this.updateValidityFlag();
            }
        });
        this.jTextFieldIDTo.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateToStatus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateToStatus();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateToStatus();
            }

            public void updateToStatus() {
                Entity ent = context.getGedcom().getEntity(GenIDPanel.this.jTextFieldIDTo.getText());
                GenIDPanel.this.validTo = ent == null;
                GenIDPanel.this.jLabelToStatus.setText(NbBundle.getMessage(GenIDPanel.class, (String)(GenIDPanel.this.validTo ? "Msg_Available" : "Msg_NotAvailable")));
                GenIDPanel.this.jLabelToStatus.setForeground(GenIDPanel.this.validTo ? Color.BLACK : Color.RED);
                GenIDPanel.this.updateValidityFlag();
            }
        });
        this.loadPreferences();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jRadioButtonCategory = new JRadioButton();
        this.jCheckBoxIndi = new JCheckBox();
        this.jCheckBoxFam = new JCheckBox();
        this.jCheckBoxObje = new JCheckBox();
        this.jCheckBoxNote = new JCheckBox();
        this.jCheckBoxSour = new JCheckBox();
        this.jCheckBoxRepo = new JCheckBox();
        this.jCheckBoxSubm = new JCheckBox();
        this.jCheckBoxAllCat = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabelLetterTitle = new JLabel();
        this.jLabelLetterContent = new JLabel();
        this.jLabelPrefix = new JLabel();
        this.jTextFieldPrefix = new JTextField();
        this.jLabelLen = new JLabel();
        this.jTextFieldLen = new JTextField();
        this.jLabelSuffix = new JLabel();
        this.jTextFieldSuffix = new JTextField();
        this.jRadioButtonSingle = new JRadioButton();
        this.jLabelIDFrom = new JLabel();
        this.jTextFieldIDFrom = new JTextField();
        this.jLabelFromName = new JLabel();
        this.jLabelIDTo = new JLabel();
        this.jTextFieldIDTo = new JTextField();
        this.jLabelToStatus = new JLabel();
        this.jButtonCID = new JButton();
        this.setMinimumSize(new Dimension(400, 200));
        this.setOpaque(false);
        this.jLabel1.setFont(new Font("Bitstream Vera Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jLabel1.text"));
        this.buttonGroup1.add(this.jRadioButtonCategory);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonCategory, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jRadioButtonCategory.text"));
        this.jRadioButtonCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenIDPanel.this.jRadioButtonCategoryActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxIndi, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jCheckBoxIndi.text"));
        this.jCheckBoxIndi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenIDPanel.this.jCheckBoxIndiActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxFam, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jCheckBoxFam.text"));
        this.jCheckBoxFam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenIDPanel.this.jCheckBoxFamActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxObje, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jCheckBoxObje.text"));
        this.jCheckBoxObje.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenIDPanel.this.jCheckBoxObjeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxNote, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jCheckBoxNote.text"));
        this.jCheckBoxNote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenIDPanel.this.jCheckBoxNoteActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxSour, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jCheckBoxSour.text"));
        this.jCheckBoxSour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenIDPanel.this.jCheckBoxSourActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxRepo, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jCheckBoxRepo.text"));
        this.jCheckBoxRepo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenIDPanel.this.jCheckBoxRepoActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxSubm, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jCheckBoxSubm.text"));
        this.jCheckBoxSubm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenIDPanel.this.jCheckBoxSubmActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxAllCat, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jCheckBoxAllCat.text"));
        this.jCheckBoxAllCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenIDPanel.this.jCheckBoxAllCatActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabelLetterTitle, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jLabelLetterTitle.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelLetterContent, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jLabelLetterContent.text"));
        this.jLabelLetterContent.setToolTipText(NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jLabelLetterContent.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelPrefix, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jLabelPrefix.text"));
        this.jTextFieldPrefix.setText(NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jTextFieldPrefix.text"));
        this.jTextFieldPrefix.setToolTipText(NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jTextFieldPrefix.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelLen, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jLabelLen.text"));
        this.jTextFieldLen.setText(NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jTextFieldLen.text"));
        this.jTextFieldLen.setToolTipText(NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jTextFieldLen.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelSuffix, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jLabelSuffix.text"));
        this.jTextFieldSuffix.setText(NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jTextFieldSuffix.text"));
        this.jTextFieldSuffix.setToolTipText(NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jTextFieldSuffix.toolTipText"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelLetterContent).addComponent(this.jLabelLetterTitle)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelPrefix).addComponent(this.jTextFieldPrefix, -2, 75, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelLen).addComponent(this.jTextFieldLen, -2, 36, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelSuffix).addComponent(this.jTextFieldSuffix, -2, 74, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPrefix).addComponent(this.jLabelSuffix).addComponent(this.jLabelLen).addComponent(this.jLabelLetterTitle)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPrefix, -2, -1, -2).addComponent(this.jTextFieldSuffix, -2, -1, -2).addComponent(this.jTextFieldLen, -2, -1, -2).addComponent(this.jLabelLetterContent)).addContainerGap()));
        this.buttonGroup1.add(this.jRadioButtonSingle);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonSingle, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jRadioButtonSingle.text"));
        this.jRadioButtonSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenIDPanel.this.jRadioButtonSingleActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabelIDFrom, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jLabelIDFrom.text"));
        this.jTextFieldIDFrom.setText(NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jTextFieldIDFrom.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelFromName, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jLabelFromName.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelIDTo, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jLabelIDTo.text"));
        this.jTextFieldIDTo.setText(NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jTextFieldIDTo.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelToStatus, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jLabelToStatus.text"));
        this.jButtonCID.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/genids/current.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonCID, (String)NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jButtonCID.text"));
        this.jButtonCID.setToolTipText(NbBundle.getMessage(GenIDPanel.class, (String)"GenIDPanel.jButtonCID.toolTipText"));
        this.jButtonCID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenIDPanel.this.jButtonCIDActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jRadioButtonCategory)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel1)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonSingle).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelIDFrom).addComponent(this.jLabelIDTo)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldIDFrom).addComponent(this.jTextFieldIDTo, -2, 120, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelToStatus).addGroup(layout.createSequentialGroup().addComponent(this.jButtonCID, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelFromName)))))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(127, 127, 127).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxObje).addComponent(this.jCheckBoxNote))).addGroup(layout.createSequentialGroup().addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxIndi).addComponent(this.jCheckBoxFam)))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSour).addComponent(this.jCheckBoxRepo)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAllCat).addComponent(this.jCheckBoxSubm)))).addGap(0, 10, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonCategory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxIndi).addComponent(this.jCheckBoxObje).addComponent(this.jCheckBoxSubm).addComponent(this.jCheckBoxSour)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxFam).addComponent(this.jCheckBoxNote).addComponent(this.jCheckBoxRepo).addComponent(this.jCheckBoxAllCat)).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jRadioButtonSingle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelIDFrom).addComponent(this.jTextFieldIDFrom, -2, -1, -2).addComponent(this.jLabelFromName).addComponent(this.jButtonCID)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelIDTo).addComponent(this.jTextFieldIDTo, -2, -1, -2).addComponent(this.jLabelToStatus)).addGap(17, 17, 17)));
    }

    private void jRadioButtonCategoryActionPerformed(ActionEvent evt) {
        this.enableCat(true);
    }

    private void jRadioButtonSingleActionPerformed(ActionEvent evt) {
        this.enableCat(false);
    }

    private void jCheckBoxAllCatActionPerformed(ActionEvent evt) {
        for (int i = 0; i < 7; ++i) {
            ((JCheckBox)this.cats[i]).setSelected(this.jCheckBoxAllCat.isSelected());
        }
    }

    private void jCheckBoxIndiActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxFamActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxObjeActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxNoteActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxSourActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxRepoActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxSubmActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jButtonCIDActionPerformed(ActionEvent evt) {
        this.setCurrentEntityID();
    }

    private void checkAllCat() {
        boolean all = true;
        for (int i = 0; i < 7; ++i) {
            all &= ((JCheckBox)this.cats[i]).isSelected();
        }
        this.jCheckBoxAllCat.setSelected(all);
    }

    private void enableCat(boolean b) {
        for (JComponent c : this.cats) {
            c.setEnabled(b);
        }
        for (JComponent c : this.singles) {
            c.setEnabled(!b);
        }
    }

    private void updateValidityFlag() {
        this.validChange = this.validFrom & this.validTo;
    }

    public boolean getValidity() {
        return this.validChange;
    }

    private void loadPreferences() {
        boolean catIsON = this.registry.get("GenIDCategoryON", true);
        this.jRadioButtonCategory.setSelected(catIsON);
        this.jRadioButtonSingle.setSelected(!catIsON);
        this.enableCat(catIsON);
        for (int i = 0; i < 8; ++i) {
            ((JCheckBox)this.cats[i]).setSelected(this.registry.get("GenIDCategory" + i, i == 0));
        }
        this.jTextFieldPrefix.setText(this.registry.get("GenIDCategoryPrefix", ""));
        this.jTextFieldLen.setText(this.registry.get("GenIDCategoryLen", ""));
        this.jTextFieldSuffix.setText(this.registry.get("GenIDCategorySuffix", ""));
        this.jTextFieldIDFrom.setText(this.registry.get("GenIDSingleFrom", ""));
        this.jTextFieldIDTo.setText(this.registry.get("GenIDSingleTo", ""));
    }

    public void savePreferences() {
        this.registry.put("GenIDCategoryON", Boolean.valueOf(this.jRadioButtonCategory.isSelected()));
        this.settings.isCat = this.jRadioButtonCategory.isSelected();
        for (int i = 0; i < 8; ++i) {
            this.registry.put("GenIDCategory" + i, Boolean.valueOf(((JCheckBox)this.cats[i]).isSelected()));
            if (i >= 7) continue;
            this.settings.entsTags[i] = ((JCheckBox)this.cats[i]).isSelected() ? Gedcom.ENTITIES[i] : "";
        }
        this.registry.put("GenIDCategoryPrefix", this.jTextFieldPrefix.getText().trim());
        this.registry.put("GenIDCategoryLen", this.jTextFieldLen.getText().trim());
        this.registry.put("GenIDCategorySuffix", this.jTextFieldSuffix.getText().trim());
        this.registry.put("GenIDSingleFrom", this.jTextFieldIDFrom.getText().trim());
        this.registry.put("GenIDSingleTo", this.jTextFieldIDTo.getText().trim());
        this.settings.prefix = this.jTextFieldPrefix.getText().trim();
        this.settings.suffix = this.jTextFieldSuffix.getText().trim();
        String str = this.jTextFieldLen.getText().replaceAll("[^0-9]", "");
        this.settings.len = str.isEmpty() ? 0 : Integer.parseInt(str);
        this.settings.IDFrom = this.jTextFieldIDFrom.getText().trim();
        this.settings.IDTo = this.jTextFieldIDTo.getText().trim();
    }

    public Settings getSettings() {
        return this.settings;
    }

    private void setCurrentEntityID() {
        this.jTextFieldIDFrom.setText(this.context.getEntity().getId());
    }

    public static class Settings {
        public boolean isCat = true;
        public String[] entsTags = new String[7];
        public String prefix = "";
        public int len = 0;
        public String suffix = "";
        public String IDFrom = "";
        public String IDTo = "";
    }
}

