/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.sosanumbers;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.gedcom.sosanumbers.Constants;
import ancestris.modules.gedcom.sosanumbers.SosaNumbersTask;
import ancestris.modules.gedcom.sosanumbers.SosaNumbersTaskFactory;
import ancestris.modules.gedcom.sosanumbers.SosaPanel;
import ancestris.util.ProgressListener;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.util.Trackable;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import spin.Spin;

public final class GenerateSosaAction
extends AbstractAncestrisContextAction
implements Constants {
    private static Gedcom gedcom = null;

    public GenerateSosaAction() {
        this.setImage("ancestris/modules/gedcom/sosanumbers/SosaNumbersIcon.png");
        this.setText(NbBundle.getMessage(GenerateSosaAction.class, (String)"ContextSosaAction"));
        this.setTip(NbBundle.getMessage(GenerateSosaAction.class, (String)"ContextSosaAction.tip"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        GenerateSosaAction.runSosaAction(this.getContext());
    }

    public static boolean runSosaAction(Context context) {
        if (context == null) {
            return false;
        }
        gedcom = context.getGedcom();
        SosaPanel sosaPanel = new SosaPanel(context);
        Object choice = DialogManager.create((String)NbBundle.getMessage(GenerateSosaAction.class, (String)"GenerateSosaAction.AskDeCujus"), (JComponent)sosaPanel).setMessageType(-1).setOptionType(2).setDialogId("sosaPanel").show();
        if (choice == DialogManager.OK_OPTION) {
            sosaPanel.savePreferences();
            SosaNumbersTask task = (SosaNumbersTask)Spin.off((Object)SosaNumbersTaskFactory.create(gedcom, sosaPanel.getSelection(), sosaPanel.getResultMessage()));
            ProgressListener.Dispatcher.processStarted((Trackable)task);
            GenerateSosaAction.commit(task);
            ProgressListener.Dispatcher.processStopped((Trackable)task);
            return true;
        }
        return false;
    }

    private static void commit(Runnable task) {
        block5: {
            try {
                if (gedcom.isWriteLocked()) {
                    task.run();
                    break block5;
                }
                gedcom.doUnitOfWork(localGedcom -> task.run());
            }
            catch (GedcomException ge) {
                Exceptions.printStackTrace((Throwable)ge);
            }
        }
    }
}

