/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.sosanumbers;

import ancestris.modules.gedcom.sosanumbers.Constants;
import ancestris.modules.gedcom.sosanumbers.Pair;
import ancestris.modules.gedcom.sosanumbers.SosaComparator;
import ancestris.modules.gedcom.sosanumbers.SosaNumbersTask;
import ancestris.util.TimingUtility;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.util.Registry;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class SosaNumbersTaskFactory {
    public static SosaNumbersTask create(Gedcom gedcom, Indi indiDeCujus, String message) {
        return new Impl(gedcom, indiDeCujus, message);
    }

    private static class Impl
    implements SosaNumbersTask,
    Constants {
        private static final Logger log = Logger.getLogger(SosaNumbersTaskFactory.class.getName());
        private Gedcom gedcom = null;
        private Registry registry = null;
        private String message = null;
        private Indi indiDeCujus = null;
        private int counter = 0;
        private int maxCounter = 1;
        private boolean cancel = false;
        private String taskName = "";
        private String state = "";
        private static final int STOP_COUNTER = 99000;
        private static final Comparator SOSA_COMPARE = new SosaComparator();
        private int mode = 1;
        private int numbering = 1;
        private boolean allSosa = false;
        private boolean numberSpouse = false;
        private boolean save = true;
        private Set<Indi> changedIndis = null;
        private boolean runBlank = false;

        private Impl(Gedcom gedcom, Indi indiDeCujus, String message) {
            this.gedcom = gedcom;
            this.registry = gedcom.getRegistry();
            this.message = message;
            this.indiDeCujus = indiDeCujus;
            this.taskName = NbBundle.getMessage(SosaNumbersTaskFactory.class, (String)"ContextSosaAction");
        }

        @Override
        public void run() {
            if (this.generateSosaNumbers()) {
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 1));
                    }
                });
            }
        }

        public void cancelTrackable() {
            this.cancel = true;
        }

        public int getProgress() {
            if (this.runBlank) {
                return 0;
            }
            int progress = 100 * this.counter / this.maxCounter;
            if (progress % 5 == 0) {
                log.log(Level.FINER, "Time=" + TimingUtility.getInstance().getTime() + " - state = " + this.getState() + " - progress = " + progress);
            }
            return progress;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public String getState() {
            return this.state;
        }

        private boolean generateSosaNumbers() {
            TimingUtility.getInstance().reset();
            this.maxCounter = 1;
            this.counter = 1;
            this.state = this.taskName;
            this.mode = this.registry.get("sosaPanelAction", 1);
            this.numbering = this.registry.get("sosaPanelNumbering", 1);
            this.allSosa = this.registry.get("sosaPanelAllSosa", false);
            this.numberSpouse = this.registry.get("sosaPanelNumberSpouse", false);
            this.save = this.registry.get("sosaPanelSave", true);
            Runnable task = null;
            if (this.mode == 2 && this.indiDeCujus == null) {
                this.state = NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.taskErase");
                task = () -> this.eraseAll();
            } else if (this.numbering == 4 || this.numbering == 1 || this.numbering == 2) {
                this.state = NbBundle.getMessage(this.getClass(), (String)(this.mode != 2 ? "SosaNumbersGenerator.taskNb" : "SosaNumbersGenerator.taskErase"));
                task = () -> this.numberUp();
            } else if (this.numbering == 3) {
                this.state = NbBundle.getMessage(this.getClass(), (String)(this.mode != 2 ? "SosaNumbersGenerator.taskNb" : "SosaNumbersGenerator.taskErase"));
                task = () -> this.numberDown(this.indiDeCujus, BigInteger.ZERO);
            } else {
                return false;
            }
            this.changedIndis = new HashSet<Indi>();
            this.counter = 1;
            this.runBlank = true;
            task.run();
            this.maxCounter = this.counter;
            if (this.cancel) {
                return false;
            }
            if (this.maxCounter >= 99000 && DialogManager.YES_OPTION != DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"SosanNumberGenerator.longOpTitle"), (String)NbBundle.getMessage(this.getClass(), (String)"SosanNumberGenerator.longOpConfirm", (Object)99000)).setMessageType(2).setOptionType(0).show()) {
                return false;
            }
            this.counter = 1;
            this.runBlank = false;
            this.changedIndis.clear();
            task.run();
            String msg = "<html>";
            msg = this.counter == 0 || this.counter == this.maxCounter ? (this.message == null ? msg + NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.autogen") + "<br>" + NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.changes", (Object)(this.maxCounter - 1)) + "</html>" : msg + this.message + "<br>" + NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.changes", (Object)this.maxCounter) + "</html>") : msg + NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.stopped", (Object)this.counter, (Object)this.maxCounter) + "</html>";
            this.message = msg;
            return true;
        }

        private void eraseAll() {
            if (!(this.numbering != 4 && this.numbering != 1 || this.deleteTags(Indi.TAG_SOSADABOVILLE))) {
                return;
            }
            if (!(this.numbering != 4 && this.numbering != 2 || this.deleteTags(Indi.TAG_SOSA))) {
                return;
            }
            if (this.numbering == 4 || this.numbering == 3) {
                this.deleteTags(Indi.TAG_DABOVILLE);
            }
        }

        public boolean deleteTags(String tagToRemove) {
            if (this.runBlank) {
                for (Entity entity : this.gedcom.getIndis()) {
                    Property[] props = entity.getProperties(tagToRemove);
                    this.counter += props.length;
                }
            } else {
                for (Entity entity : this.gedcom.getIndis()) {
                    this.counter += entity.getProperties(tagToRemove).length;
                    entity.delProperties(tagToRemove);
                }
            }
            return true;
        }

        private void numberUp() {
            HashMap<String, Pair> sosaPairs = new HashMap<String, Pair>();
            LinkedList<Pair> listIter = new LinkedList<Pair>();
            this.updateIndi(this.indiDeCujus, BigInteger.ONE, listIter, sosaPairs, null);
            if (this.treeup(listIter, sosaPairs)) {
                return;
            }
            if (this.numbering == 4 || this.numbering == 1) {
                TreeSet sosaSet = new TreeSet(SOSA_COMPARE);
                sosaSet.addAll(sosaPairs.values());
                for (Pair p : sosaSet) {
                    if (this.numberDown(p.getIndi(), new BigInteger(p.getValue())) || 1 != p.getIndi().getSex()) continue;
                    return;
                }
            }
        }

        private boolean treeup(Queue<Pair> iter, Map<String, Pair> listCurrent) {
            while (!iter.isEmpty()) {
                if (this.runBlank && iter.size() >= 99000) {
                    return false;
                }
                Pair pair = iter.poll();
                if (pair == null) continue;
                BigInteger sosa = new BigInteger(pair.getValue());
                Fam famc = pair.getIndi().getFamilyWhereBiologicalChild();
                if (famc == null) continue;
                Indi husband = famc.getHusband();
                if (husband != null && !this.updateIndi(husband, sosa.shiftLeft(1), iter, listCurrent, null)) {
                    return true;
                }
                Indi wife = famc.getWife();
                if (wife == null || this.updateIndi(wife, sosa.shiftLeft(1).add(BigInteger.ONE), iter, listCurrent, null)) continue;
                return true;
            }
            return false;
        }

        private boolean numberDown(Indi indiFrom, BigInteger sosaValue) {
            HashMap<String, Pair> dabovillePairs = new HashMap<String, Pair>();
            LinkedList<Pair> listIter = new LinkedList<Pair>();
            if (this.numbering == 4 || this.numbering == 3) {
                this.updateIndi(indiFrom, sosaValue, listIter, dabovillePairs, "1");
            } else {
                Pair newPair = new Pair(indiFrom, sosaValue == BigInteger.ZERO ? "1" : "");
                listIter.offer(newPair);
                dabovillePairs.put(indiFrom.getId(), newPair);
            }
            return this.treedown(sosaValue, listIter, dabovillePairs);
        }

        private boolean treedown(BigInteger sosaValue, Queue<Pair> listIter, Map<String, Pair> dabovillePairs) {
            while (!listIter.isEmpty()) {
                Fam[] families;
                if (this.runBlank && listIter.size() >= 99000) {
                    return false;
                }
                Pair current = listIter.poll();
                if (current == null) continue;
                Character suffix = Character.valueOf('a');
                String daboCounter = current.getValue();
                if (daboCounter != null && !"".equals(daboCounter) && Character.isLetter(daboCounter.charAt(daboCounter.length() - 1))) {
                    return this.treedown(sosaValue, listIter, dabovillePairs);
                }
                for (Fam family : families = current.getIndi().getFamiliesWhereSpouse()) {
                    Indi wife;
                    Indi indi;
                    int childOrder = 0;
                    for (Indi child : family.getChildren(true)) {
                        ++childOrder;
                        if (this.changedIndis.contains(child)) continue;
                        String localCtr = daboCounter + (families.length > 1 ? suffix.toString() : "");
                        localCtr = localCtr + (localCtr.length() > 0 ? "." : "");
                        if (this.updateIndi(child, sosaValue, listIter, dabovillePairs, localCtr = localCtr + childOrder)) continue;
                        return false;
                    }
                    if (this.numberSpouse && ((indi = family.getHusband()) != null && !indi.getId().equals(current.getIndi().getId()) ? !this.changedIndis.contains(indi) && !this.updateIndi(indi, sosaValue, listIter, dabovillePairs, daboCounter + suffix.toString()) : (wife = family.getWife()) != null && !this.changedIndis.contains(wife) && !wife.getId().equals(current.getIndi().getId()) && !this.updateIndi(wife, sosaValue, listIter, dabovillePairs, daboCounter + suffix.toString()))) {
                        return false;
                    }
                    Character object = suffix;
                    Character c = suffix = Character.valueOf((char)(suffix.charValue() + '\u0001'));
                }
            }
            return true;
        }

        private boolean updateIndi(Indi indi, BigInteger sosaNumber, Queue<Pair> listIter, Map<String, Pair> list, String daboValue) {
            boolean isNew;
            boolean bl = isNew = !this.changedIndis.contains(indi);
            if (isNew) {
                this.changedIndis.add(indi);
            }
            if (isNew || this.allSosa) {
                Pair newPair = new Pair(indi, daboValue == null ? this.nbToString(sosaNumber) : daboValue);
                listIter.offer(newPair);
                if (isNew) {
                    list.put(indi.getId(), newPair);
                } else {
                    Pair current = list.get(indi.getId());
                    if (current != null && SOSA_COMPARE.compare(newPair, current) < 0) {
                        list.remove(indi.getId());
                        list.put(indi.getId(), newPair);
                    }
                }
            }
            if (this.mode == 2) {
                if (isNew && (this.numbering == 4 || this.numbering == 1)) {
                    this.counter += indi.getProperties(Indi.TAG_SOSADABOVILLE).length;
                    if (!this.runBlank) {
                        indi.delProperties(Indi.TAG_SOSADABOVILLE);
                    }
                }
                if (isNew && (this.numbering == 4 || this.numbering == 2)) {
                    this.counter += indi.getProperties(Indi.TAG_SOSA).length;
                    if (!this.runBlank) {
                        indi.delProperties(Indi.TAG_SOSA);
                    }
                }
                if (isNew && (this.numbering == 4 || this.numbering == 3)) {
                    this.counter += indi.getProperties(Indi.TAG_DABOVILLE).length;
                    if (!this.runBlank) {
                        indi.delProperties(Indi.TAG_DABOVILLE);
                    }
                }
            }
            if (this.mode != 2 && (isNew || this.allSosa)) {
                Property prop = null;
                try {
                    String value = this.nbToString(sosaNumber, "", true, daboValue);
                    switch (this.numbering) {
                        case 1: {
                            if (!this.runBlank) {
                                prop = this.addSosaValue(indi, Indi.TAG_SOSADABOVILLE, value, this.getNumberPosition((Property)indi, Indi.TAG_SOSADABOVILLE, sosaNumber));
                            }
                            ++this.counter;
                            break;
                        }
                        case 2: {
                            if (!this.runBlank) {
                                prop = this.addSosaValue(indi, Indi.TAG_SOSA, value, this.getNumberPosition((Property)indi, Indi.TAG_SOSA, sosaNumber));
                            }
                            ++this.counter;
                            break;
                        }
                        case 3: {
                            if (!this.runBlank) {
                                prop = this.addSosaValue(indi, Indi.TAG_DABOVILLE, value, this.setPropertyPosition((Property)indi, Indi.TAG_DABOVILLE));
                            }
                            ++this.counter;
                            break;
                        }
                    }
                    log.log(Level.FINER, "{0} -> {1}", new Object[]{indi.toString(true), value});
                }
                catch (GedcomException ex) {
                    log.log(Level.WARNING, "Error during Numbering.", ex);
                }
                if (!this.runBlank && prop != null) {
                    prop.setGuessed(!this.save);
                }
            }
            return !isNew || !this.cancel;
        }

        private Property addSosaValue(Indi indi, String tag, String value, int pos) throws GedcomException {
            String oldValue;
            Property oldProp = indi.getProperty(tag);
            if (oldProp != null && (oldValue = oldProp.getValue()).equals(value)) {
                return oldProp;
            }
            return indi.addProperty(tag, value, pos);
        }

        private int getNumberPosition(Property prop, String tag, BigInteger value) {
            if (prop == null) {
                return 1;
            }
            Property[] props = prop.getProperties(tag);
            if (props != null && props.length != 0) {
                for (Property p : props) {
                    BigInteger bi = this.extractNumber(p.getDisplayValue());
                    if (bi.compareTo(value) <= 0) continue;
                    return prop.getPropertyPosition(p);
                }
                return prop.getPropertyPosition(props[props.length - 1]) + 1;
            }
            Property pName = prop.getProperty("NAME");
            if (pName != null) {
                return prop.getPropertyPosition(pName) + 1;
            }
            return 1;
        }

        private int setPropertyPosition(Property prop, String tag) {
            if (prop == null) {
                return 1;
            }
            Property[] props = prop.getProperties(tag);
            if (props != null && props.length != 0) {
                return prop.getPropertyPosition(props[props.length - 1]) + 1;
            }
            Property pName = prop.getProperty("NAME");
            if (pName != null) {
                return prop.getPropertyPosition(pName) + 1;
            }
            return 1;
        }

        private BigInteger extractNumber(String str) {
            int end;
            int start;
            for (start = 0; start <= str.length() - 1 && !Character.isDigit(str.charAt(start)); ++start) {
            }
            for (end = start; end <= str.length() - 1 && Character.isDigit(str.charAt(end)); ++end) {
            }
            if (end == start) {
                return BigInteger.ZERO;
            }
            return new BigInteger(str.substring(start, end));
        }

        protected String nbToString(BigInteger sosa) {
            return this.nbToString(sosa, "", false);
        }

        protected String nbToString(BigInteger sosa, String suffix, boolean gen) {
            return this.nbToString(sosa, suffix, gen, "");
        }

        protected String nbToString(BigInteger sosa, String suffix, boolean gen, String daboValue) {
            String sosaStr;
            DecimalFormat formatNbrs = new DecimalFormat("0");
            String string = sosaStr = sosa != BigInteger.ZERO ? formatNbrs.format(sosa) : "";
            String dabo = daboValue == null || daboValue.isEmpty() ? "" : (sosa != BigInteger.ZERO ? "-" + daboValue : daboValue);
            int genInt = sosa.bitLength();
            if (!dabo.isEmpty()) {
                int i = 1;
                for (int k = 0; k < dabo.length(); ++k) {
                    if (dabo.charAt(k) != '.') continue;
                    ++i;
                }
                genInt -= i;
            }
            String genStr = gen && sosa != BigInteger.ZERO ? " G" + genInt : "";
            return sosaStr + suffix + dabo + genStr;
        }
    }
}

