/*
 * Decompiled with CFR 0.152.
 */
package modules.editors.gedcomproperties.utils;

import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.PropertyFile;
import genj.io.InputSource;
import genj.util.Registry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import modules.editors.gedcomproperties.utils.PathData;
import modules.editors.gedcomproperties.utils.RemoteMediaTableModel;
import org.apache.commons.io.FileUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RemoteMediaManagerPanel
extends JPanel {
    Logger LOG = Logger.getLogger("ancestris.app");
    private Set<PathData> paths = new TreeSet<PathData>();
    private Registry registry = Registry.get(this.getClass());
    private RemoteMediaTableModel rmtm;
    private boolean select = false;
    private boolean modified = false;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextField1;

    public RemoteMediaManagerPanel(Set<PropertyFile> chemin) {
        this.buildPathList(chemin);
        this.rmtm = new RemoteMediaTableModel(this.paths, this);
        this.initComponents();
        this.setPreferredSize(new Dimension(this.registry.get("remoteMediaManagerPanelWidth", this.getPreferredSize().width), this.registry.get("remoteMediaManagerPanelHeight", this.getPreferredSize().height)));
        this.resizeColumn();
    }

    private void resizeColumn() {
        Dimension size = this.getPreferredSize();
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.jTable1.getColumnModel().getColumn(2).setPreferredWidth(size.width - 200);
    }

    private void buildPathList(Set<PropertyFile> chemin) {
        for (PropertyFile pf : chemin) {
            PathData pd = this.getPathData(pf.getValue());
            if (pd != null) {
                pd.addFile(pf);
                continue;
            }
            this.paths.add(new PathData(false, false, pf, pf.getValue()));
        }
    }

    private PathData getPathData(String key) {
        for (PathData pd : this.paths) {
            if (!pd.newPath.equals(key)) continue;
            return pd;
        }
        return null;
    }

    private void initComponents() {
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                RemoteMediaManagerPanel.this.formComponentResized(evt);
            }
        });
        this.jTextField1.setText(NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"RemoteMediaManagerPanel.jTextField1.text"));
        this.jTextField1.setToolTipText(NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"RemoteMediaManagerPanel.jTextField1.toolTipText"));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/modules/editors/gedcomproperties/ressources/Open.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"RemoteMediaManagerPanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoteMediaManagerPanel.this.jButton1ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"RemoteMediaManagerPanel.jLabel1.text"));
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(this.rmtm);
        this.jScrollPane1.setViewportView(this.jTable1);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"RemoteMediaManagerPanel.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoteMediaManagerPanel.this.jButton2ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"RemoteMediaManagerPanel.jButton3.text"));
        this.jButton3.setToolTipText(NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"RemoteMediaManagerPanel.jButton3.toolTipText"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoteMediaManagerPanel.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 341, -2).addGroup(layout.createSequentialGroup().addComponent(this.jTextField1, -1, 362, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 26, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton3).addGap(20, 20, 20)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addComponent(this.jTextField1, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jScrollPane1, -1, 269, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton3)).addGap(21, 21, 21)));
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("remoteMediaManagerPanelWidth", evt.getComponent().getWidth());
        this.registry.put("remoteMediaManagerPanelHeight", evt.getComponent().getHeight());
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.select = !this.select;
        for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
            this.jTable1.setValueAt(this.select, i, 0);
        }
        this.jTable1.repaint();
        if (this.select) {
            this.jButton2.setText(NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"RemoteMediaManagerPanel.unselect"));
        } else {
            this.jButton2.setText(NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"RemoteMediaManagerPanel.jButton2.text"));
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        File file;
        String defaultDir = this.jTextField1.getText();
        if (defaultDir.isEmpty()) {
            defaultDir = System.getProperty("user.home");
        }
        if ((file = new FileChooserBuilder(RemoteMediaManagerPanel.class).setDirectoriesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"FileChooserTitle")).setApproveText(NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"FileChooserButton")).setFileFilter(null).setAcceptAllFileFilterUsed(true).setFileHiding(true).setParent((Component)this).setDefaultPreviewer().setSelectedFile(new File(defaultDir)).setDefaultWorkingDirectory(new File(defaultDir)).showOpenDialog()) != null) {
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            this.jTextField1.setText(file.getAbsolutePath());
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        String dir = this.jTextField1.getText();
        if (dir != null && !dir.isEmpty()) {
            this.downloadFiles();
        } else {
            DialogManager.createError((String)NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"NO_DIRECTORY_TITLE"), (String)NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"NO_DIRECTORY_MSG")).show();
        }
    }

    public void updatePath(String path, boolean value) {
        for (PathData pd : this.paths) {
            if (!pd.newPath.equals(path)) continue;
            pd.found = value;
        }
    }

    private void downloadFiles() {
        TreeSet<PathData> ok = new TreeSet<PathData>();
        long nbProperty = 0L;
        for (PathData pd : this.paths) {
            if (!pd.found) continue;
            boolean done = false;
            InputSource is = null;
            Optional newLocation = Optional.empty();
            for (PropertyFile pf : pd.getFiles()) {
                is = pf.getInput().orElse(null);
                if (is != null && !done) {
                    try {
                        File fichier = new File(this.jTextField1.getText() + File.separator + this.getCleanFileName(pf.getValue(), "-"));
                        FileUtils.copyInputStreamToFile((InputStream)is.open(), (File)fichier);
                        newLocation = InputSource.get((File)fichier);
                        done = true;
                    }
                    catch (IOException e) {
                        this.LOG.log(Level.INFO, "Unable to get remote file", e);
                        break;
                    }
                }
                if (!newLocation.isPresent()) continue;
                pf.addFile((InputSource)newLocation.get());
                this.modified = true;
                ++nbProperty;
            }
            if (!done) continue;
            ok.add(pd);
        }
        this.paths.removeAll(ok);
        this.rmtm = new RemoteMediaTableModel(this.paths, this);
        this.jTable1.setModel(this.rmtm);
        this.resizeColumn();
        this.jTable1.repaint();
        DialogManager.create((String)NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"RESULT_TITLE"), (String)NbBundle.getMessage(RemoteMediaManagerPanel.class, (String)"RESULT_MSG", (Object)ok.size(), (Object)this.jTextField1.getText(), (Object)nbProperty)).setOptionType(10).setMessageType(1).show();
    }

    public boolean isMapModified() {
        return this.modified;
    }

    private String getCleanFileName(String input, String defchar) {
        String str = input.substring(Math.max(0, input.lastIndexOf(":") + 1));
        while (str.startsWith("\\")) {
            str = str.substring(1);
        }
        while (str.startsWith("/")) {
            str = str.substring(1);
        }
        String temp = str.replaceAll("\\s", "_");
        int i = temp.indexOf(63);
        if (i > 0) {
            temp = temp.substring(0, i);
        }
        String cleanName = this.fileNameConvert(temp, defchar);
        return cleanName;
    }

    private String fileNameConvert(String filename, String defchar) {
        if (filename == null) {
            return "null";
        }
        String text = filename.toLowerCase();
        char[] charInput = text.toCharArray();
        StringBuilder strOutput = new StringBuilder(1000);
        for (int i = 0; i < charInput.length; ++i) {
            strOutput.append(this.convertChar(charInput[i], false, defchar));
        }
        return strOutput.toString();
    }

    private String convertChar(char c, boolean isAnchor, String defchar) {
        String str;
        switch (c) {
            case '\u00e0': {
                str = "a";
                break;
            }
            case '\u00e1': {
                str = "a";
                break;
            }
            case '\u00e2': {
                str = "a";
                break;
            }
            case '\u00e3': {
                str = "a";
                break;
            }
            case '\u00e4': {
                str = "a";
                break;
            }
            case '\u00e5': {
                str = "a";
                break;
            }
            case '\u00e6': {
                str = "ae";
                break;
            }
            case '\u00e7': {
                str = "c";
                break;
            }
            case '\u00e8': {
                str = "e";
                break;
            }
            case '\u00e9': {
                str = "e";
                break;
            }
            case '\u00ea': {
                str = "e";
                break;
            }
            case '\u00eb': {
                str = "e";
                break;
            }
            case '\u00ec': {
                str = "i";
                break;
            }
            case '\u00ed': {
                str = "i";
                break;
            }
            case '\u00ee': {
                str = "i";
                break;
            }
            case '\u00ef': {
                str = "i";
                break;
            }
            case '\u00f0': {
                str = "o";
                break;
            }
            case '\u00f1': {
                str = "n";
                break;
            }
            case '\u00f2': {
                str = "o";
                break;
            }
            case '\u00f3': {
                str = "o";
                break;
            }
            case '\u00f4': {
                str = "o";
                break;
            }
            case '\u00f5': {
                str = "o";
                break;
            }
            case '\u00f6': {
                str = "o";
                break;
            }
            case '\u00f8': {
                str = "o";
                break;
            }
            case '\u00f9': {
                str = "u";
                break;
            }
            case '\u00fa': {
                str = "u";
                break;
            }
            case '\u00fb': {
                str = "u";
                break;
            }
            case '\u00fc': {
                str = "u";
                break;
            }
            case '\u00fd': {
                str = "y";
                break;
            }
            case '\u00fe': {
                str = "p";
                break;
            }
            case '\u00ff': {
                str = "y";
                break;
            }
            case '\u00df': {
                str = "ss";
                break;
            }
            default: {
                String str2 = String.valueOf(c);
                if (str2.matches("[a-zA-Z0-9]")) {
                    return str2;
                }
                if (str2.compareTo(".") == 0) {
                    return isAnchor ? defchar : str2;
                }
                if (str2.compareTo("/") == 0) {
                    return isAnchor ? defchar : str2;
                }
                if (str2.compareTo("\\") == 0) {
                    return isAnchor ? defchar : str2;
                }
                return defchar;
            }
        }
        return str;
    }
}

