/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.EventWrapper;
import ancestris.modules.editors.standard.tools.Utils;
import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import org.openide.util.Exceptions;

public class AssoWrapper {
    public PropertyAssociation assoProp = null;
    public String assoTxt = "";
    public Indi assoIndi = null;
    public String assoLastname = "";
    public String assoFirstname = "";
    public int assoSex = 0;
    public String assoOccupation = "";
    private Entity targetEntity = null;
    public EventWrapper targetEvent = null;
    private String targetEventTag = "";
    public String targetEventDesc = "";

    public AssoWrapper(String text) {
        this.assoTxt = text;
    }

    public AssoWrapper(PropertyForeignXRef xrefProperty, EventWrapper event) {
        if (xrefProperty == null) {
            return;
        }
        Indi associatedIndi = (Indi)xrefProperty.getTargetEntity();
        PropertyAssociation assoProperty = (PropertyAssociation)xrefProperty.getTarget();
        this.setValues(associatedIndi, assoProperty, event);
    }

    public AssoWrapper(PropertyAssociation assoProperty) {
        if (assoProperty == null) {
            return;
        }
        Indi associatedIndi = (Indi)assoProperty.getEntity();
        Property eventProp = assoProperty.getTargetParent();
        EventWrapper event = new EventWrapper(eventProp, associatedIndi, null);
        this.setValues(associatedIndi, assoProperty, event);
    }

    private AssoWrapper(AssoWrapper asso) {
        this.assoProp = asso.assoProp;
        this.assoTxt = asso.assoTxt;
        this.assoIndi = asso.assoIndi;
        this.assoLastname = asso.assoLastname;
        this.assoFirstname = asso.assoFirstname;
        this.assoSex = asso.assoSex;
        this.assoOccupation = asso.assoOccupation;
        this.targetEntity = asso.targetEntity;
        this.targetEvent = asso.targetEvent;
        this.targetEventTag = asso.targetEventTag;
        this.targetEventDesc = asso.targetEventDesc;
    }

    public boolean equals(AssoWrapper object) {
        return this.assoProp != null && this.assoProp.equals(object.assoProp);
    }

    private void setValues(Indi associatedIndi, PropertyAssociation assoProperty, EventWrapper event) {
        this.assoProp = assoProperty;
        this.assoIndi = associatedIndi;
        this.targetEntity = event.eventProperty.getEntity();
        this.targetEvent = event;
        this.assoLastname = this.assoIndi.getLastName();
        this.assoFirstname = this.assoIndi.getFirstName();
        this.assoSex = this.assoIndi.getSex();
        this.assoOccupation = this.getOccupation(this.assoIndi, this.targetEvent);
        this.targetEventDesc = this.assoProp.getDisplayValue(false);
        PropertyRelationship relaP = (PropertyRelationship)this.assoProp.getProperty("RELA");
        this.assoTxt = relaP.getDisplayValue();
    }

    public String getOccupation(Indi indi, EventWrapper event) {
        String occu = "";
        Property[] props = indi.getProperties("OCCU");
        if (props.length == 0) {
            return "";
        }
        if (props.length == 1) {
            return props[0].getDisplayValue();
        }
        if (props.length > 1) {
            occu = props[0].getDisplayValue();
        }
        if (event != null) {
            PropertyDate pDate = event.date;
            PointInTime sourcePIT = pDate != null ? pDate.getStart() : null;
            PointInTime latestPIT = null;
            for (Property prop : props) {
                Property date = prop.getProperty("DATE");
                if (date != null) {
                    PropertyDate pdate = (PropertyDate)date;
                    PointInTime pit = pdate.getEnd();
                    if (!pit.isValid()) {
                        pit = pdate.getStart();
                    }
                    if (latestPIT != null && (pit.compareTo(latestPIT) <= 0 || pit.compareTo(sourcePIT) > 0)) continue;
                    latestPIT = pit;
                    occu = prop.getDisplayValue();
                    continue;
                }
                if (latestPIT != null) continue;
                occu = prop.getDisplayValue();
            }
        }
        return occu;
    }

    public static AssoWrapper clone(AssoWrapper asso) {
        return new AssoWrapper(asso);
    }

    public String toString() {
        String name = (this.assoLastname + " " + this.assoFirstname).trim();
        return this.assoTxt + (!name.isEmpty() ? " | " + name : "");
    }

    public void update() {
        if (!this.isToBeUpdated()) {
            return;
        }
        if (this.targetEntity == null) {
            this.targetEntity = this.targetEvent.eventProperty.getEntity();
        }
        if (this.assoIndi == null || this.assoIndi.getGedcom() == null) {
            try {
                this.assoIndi = (Indi)this.targetEntity.getGedcom().createEntity("INDI");
                this.assoProp = null;
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.assoIndi.setName(this.assoFirstname, this.assoLastname);
        this.assoIndi.setSex(this.assoSex);
        this.updateProperty((Property)this.assoIndi, "OCCU", this.assoOccupation, this.targetEvent.eventProperty);
        if (this.assoProp == null) {
            PropertyXRef assoXref = (PropertyXRef)this.assoIndi.addProperty("ASSO", "@");
            this.assoProp = (PropertyAssociation)assoXref;
        } else {
            this.removeLink(this.assoProp);
        }
        Utils.setDistinctValue((Property)this.assoProp, '@' + this.targetEntity.getId() + '@');
        TagPath anchor = this.getAnchor(this.targetEvent.eventProperty);
        this.putProperty((Property)this.assoProp, "RELA", this.assoTxt + (anchor == null ? "" : '@' + anchor.toString()));
        try {
            this.assoProp.link();
        }
        catch (Exception ex) {
            this.removeAsso(this.assoIndi, this.assoProp);
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private boolean isToBeUpdated() {
        TagPath oldAnchor;
        if (!this.assoIndi.getFirstName().equals(this.assoFirstname)) {
            return true;
        }
        if (!this.assoIndi.getLastName().equals(this.assoLastname)) {
            return true;
        }
        if (this.assoIndi.getSex() != this.assoSex) {
            return true;
        }
        Property[] occuProps = this.assoIndi.getProperties("OCCU");
        boolean found = false;
        for (Property p : occuProps) {
            String occuStr = "";
            if (p != null) {
                occuStr = p.getDisplayValue().trim();
            }
            if (!occuStr.equals(this.assoOccupation.trim())) continue;
            found = true;
        }
        if (!found) {
            return true;
        }
        if (this.targetEntity == null || this.assoIndi == null || this.assoIndi.getGedcom() == null || this.assoProp == null) {
            return true;
        }
        String val = this.assoProp.getValue();
        if (!val.equals('@' + this.targetEntity.getId() + '@')) {
            return true;
        }
        TagPath newAnchor = this.getAnchor(this.targetEvent.eventProperty);
        PropertyRelationship p = (PropertyRelationship)this.assoProp.getProperty("RELA");
        TagPath tagPath = oldAnchor = p != null ? p.getAnchor() : null;
        return oldAnchor == null || !oldAnchor.equals((Object)newAnchor);
    }

    public void remove() {
        if (this.assoIndi != null && this.assoProp != null) {
            this.removeLink(this.assoProp);
            this.removeAsso(this.assoIndi, this.assoProp);
        }
    }

    private void putProperty(Property property, String tag, String value) {
        Property prop = property.getProperty(tag, true);
        if (prop != null) {
            Utils.setDistinctValue(prop, value);
        } else {
            property.addProperty(tag, value);
        }
    }

    private void removeLink(PropertyAssociation pa) {
        PropertyXRef target = pa.getTarget();
        if (target == null) {
            return;
        }
        Property targetParent = target.getParent();
        pa.unlink();
        targetParent.delProperty((Property)target);
    }

    private void removeAsso(Indi indi, PropertyAssociation pa) {
        indi.delProperty((Property)pa);
    }

    private TagPath getAnchor(Property property) {
        if (property == null) {
            return null;
        }
        TagPath result = property.getPath(false);
        return property.getEntity().getProperty(result) == property ? result : property.getPath(true);
    }

    private void updateProperty(Property property, String tag, String newValue, Property sourceEvent) {
        Property[] props;
        if (newValue.isEmpty()) {
            return;
        }
        PropertyDate sourceDate = sourceEvent != null ? (PropertyDate)sourceEvent.getProperty("DATE") : null;
        String newDate = sourceDate != null ? sourceDate.getValue() : "";
        String oldValue = "";
        String oldDate = "";
        boolean tagExists = false;
        for (Property prop : props = property.getProperties(tag)) {
            tagExists = true;
            oldValue = prop.getValue().trim();
            PropertyDate pDate = (PropertyDate)prop.getProperty("DATE");
            String string = oldDate = pDate != null ? pDate.getValue() : "";
            if (newValue.equals(oldValue)) {
                if (!oldDate.isEmpty() || newDate.isEmpty()) break;
                this.putProperty(prop, "DATE", newDate);
                pDate = (PropertyDate)prop.getProperty("DATE");
                pDate.setFormat(PropertyDate.BEFORE);
                break;
            }
            if (pDate != null && sourceDate != null) {
                int days = 32;
                try {
                    days = pDate.getStart().getJulianDay() - sourceDate.getStart().getJulianDay();
                    days = Math.abs(days);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (days < 32) {
                    prop.setValue(newValue);
                    break;
                }
                tagExists = false;
                continue;
            }
            tagExists = false;
        }
        if (!tagExists) {
            Property tagProp = property.addProperty(tag, newValue);
            if (!newDate.isEmpty()) {
                PropertyDate pDate = (PropertyDate)tagProp.addProperty("DATE", newDate);
                pDate.setFormat(PropertyDate.BEFORE);
            }
        }
    }
}

