/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.openide.util.Exceptions;

public class AutoCompletion
extends PlainDocument {
    static Map<JComboBox, AutoCompletion> instances = null;
    final JComboBox comboBox;
    JTextComponent textEditor;
    List<String> comboList;
    boolean refreshingList = false;
    boolean refreshList = true;
    boolean showPopup = false;
    boolean readyToSelect = false;

    public AutoCompletion(JComboBox combo, List<String> list) {
        this.comboBox = combo;
        this.comboList = list;
        this.comboBox.setEditable(true);
        this.setScrollBars();
        this.textEditor = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
        this.textEditor.setDocument(this);
        this.textEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AutoCompletion.this.refreshList = false;
                AutoCompletion.this.refreshingList = false;
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 33 || e.getKeyCode() == 34) {
                    AutoCompletion.this.refreshingList = true;
                    AutoCompletion.this.showPopup = true;
                    AutoCompletion.this.readyToSelect = true;
                    AutoCompletion.this.comboBox.setPopupVisible(AutoCompletion.this.showPopup);
                } else if (e.getKeyCode() == 10) {
                    String text;
                    if (AutoCompletion.this.comboBox.isPopupVisible() && !(text = AutoCompletion.this.comboBox.getModel().getSelectedItem().toString().trim()).isEmpty()) {
                        AutoCompletion.this.setText(text);
                    }
                    AutoCompletion.this.showPopup = false;
                    AutoCompletion.this.comboBox.setPopupVisible(AutoCompletion.this.showPopup);
                    AutoCompletion.this.resetList();
                } else if (e.getKeyCode() == 27) {
                    AutoCompletion.this.showPopup = false;
                    AutoCompletion.this.comboBox.setPopupVisible(AutoCompletion.this.showPopup);
                    AutoCompletion.this.readyToSelect = false;
                } else {
                    AutoCompletion.this.refreshList = true;
                    AutoCompletion.this.showPopup = true;
                    AutoCompletion.this.readyToSelect = false;
                }
            }
        });
        this.resetList();
    }

    private void resetList() {
        this.refreshingList = true;
        this.comboList.add("");
        this.comboBox.setModel(new DefaultComboBoxModel<String>(this.comboList.toArray(new String[this.comboList.size()])));
        this.comboBox.setPopupVisible(false);
        this.refreshingList = false;
        this.refreshList = false;
    }

    private void refreshList() {
        if (!this.refreshList) {
            return;
        }
        this.refreshingList = true;
        try {
            String filter = this.getText(0, this.getLength());
            String[] listArray = this.getFilteredList(filter);
            if (listArray.length == 0) {
                String str0 = (String)this.comboBox.getItemAt(0);
                if (this.comboBox.getItemCount() != 0 && !this.comboList.contains(str0)) {
                    this.comboBox.removeItemAt(0);
                }
                this.comboBox.insertItemAt(filter, 0);
                this.comboBox.setSelectedIndex(0);
            }
            if (listArray.length != 0) {
                this.comboBox.setModel(new DefaultComboBoxModel<String>(listArray));
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.comboBox.setPopupVisible(this.showPopup);
        this.refreshingList = false;
        this.refreshList = false;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.refreshingList) {
            return;
        }
        super.remove(offs, len);
        this.refreshList();
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.refreshingList) {
            return;
        }
        super.insertString(offs, str, a);
        this.refreshList();
    }

    private void setText(String text) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private String[] getFilteredList(String text) {
        ArrayList<String> list = new ArrayList<String>();
        for (String item : this.comboList) {
            if (!item.toLowerCase().contains(text.toLowerCase())) continue;
            list.add(item);
        }
        list.add("");
        return list.toArray(new String[list.size()]);
    }

    public static void reset(JComboBox comboBox, List<String> list) {
        AutoCompletion instance;
        if (instances == null) {
            instances = new HashMap<JComboBox, AutoCompletion>();
        }
        if ((instance = instances.get(comboBox)) == null) {
            instance = new AutoCompletion(comboBox, list);
            instances.put(comboBox, instance);
        } else {
            instance.comboList = list;
            instance.resetList();
        }
    }

    private void setScrollBars() {
        Accessible comp = this.comboBox.getUI().getAccessibleChild(this.comboBox, 0);
        if (!(comp instanceof JPopupMenu)) {
            return;
        }
        JPopupMenu popup = (JPopupMenu)comp;
        if (popup.getComponent(0) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)popup.getComponent(0);
            scrollPane.setHorizontalScrollBar(new JScrollBar(0));
            scrollPane.setHorizontalScrollBarPolicy(30);
        }
    }
}

