/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.NoteWrapper;
import ancestris.modules.editors.standard.tools.Utils;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyXRef;
import genj.util.Registry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class NoteChooser
extends JPanel {
    private static int THUMB_WIDTH = 120;
    private static int THUMB_HEIGHT = 140;
    private Registry registry = null;
    private ThumbComparator thumbComparator = new ThumbComparator();
    private TreeSet<NoteThumb> allNote = new TreeSet<NoteThumb>(this.thumbComparator);
    private DefaultListModel filteredModel = new DefaultListModel();
    private Gedcom gedcom = null;
    private NoteWrapper mainNote = null;
    private String mainText = null;
    private String mainTitle = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JLabel filterLabel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPaneNote;
    private JSplitPane jSplitPane;
    private JList noteList;
    private JScrollPane noteScrollPane;
    private JTextArea noteText;
    private JLabel noteTitle;
    private JTextField textFilter;

    public NoteChooser(Gedcom gedcom, NoteWrapper note, JButton okButton, JButton cancelButton) {
        this.gedcom = gedcom;
        this.mainNote = note;
        this.okButton = okButton;
        this.cancelButton = cancelButton;
        this.registry = Registry.get(this.getClass());
        this.initComponents();
        this.setPreferredSize(new Dimension(this.registry.get("noteWindowWidth", this.getPreferredSize().width), this.registry.get("noteWindowHeight", this.getPreferredSize().height)));
        this.jSplitPane.setDividerLocation(this.registry.get("noteSplitDividerLocation", this.jSplitPane.getDividerLocation()));
        this.noteList.setCellRenderer(new ListEntryCellRenderer());
        okButton.setEnabled(false);
        this.textFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void filter() {
                NoteChooser.this.filterModel(NoteChooser.this.textFilter.getText());
            }
        });
        this.createNoteThumbs();
        Thread noteThread = new Thread(){

            @Override
            public void run() {
                NoteChooser.this.displayNoteThumbs();
                NoteChooser.this.selectNote(NoteChooser.this.mainNote);
            }
        };
        noteThread.setName("Note reading thread");
        noteThread.start();
    }

    private void selectNote(NoteWrapper note) {
        NoteThumb selectedNote = null;
        String memorizedNoteId = this.registry.get("noteSelected", "");
        for (NoteThumb notei : this.allNote) {
            if (note == null && notei.entity == null) {
                selectedNote = notei;
            }
            if (note == null && notei.getId().equals(memorizedNoteId)) {
                selectedNote = notei;
            }
            if (note == null || notei.entity == null || !notei.entity.equals(note.getTargetNote())) continue;
            selectedNote = notei;
            break;
        }
        if (selectedNote != null) {
            final NoteThumb notei = selectedNote;
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    NoteChooser.this.noteList.setSelectedValue(notei, true);
                    NoteChooser.this.noteList.ensureIndexIsVisible(NoteChooser.this.noteList.getSelectedIndex());
                    NoteChooser.this.noteList.scrollRectToVisible(NoteChooser.this.noteList.getCellBounds(NoteChooser.this.noteList.getMinSelectionIndex(), NoteChooser.this.noteList.getMaxSelectionIndex()));
                    NoteChooser.this.textFilter.requestFocus();
                }
            });
        }
    }

    private void displayIconAndTitle(int width, int height) {
        this.noteTitle.setText("<html><center>" + this.mainTitle + "</center></html>");
        this.noteTitle.setPreferredSize(new Dimension(width, -1));
        this.noteText.setText(this.mainText);
        this.noteText.setCaretPosition(0);
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.noteTitle = new JLabel();
        this.noteScrollPane = new JScrollPane();
        this.noteText = new JTextArea();
        this.jPanel2 = new JPanel();
        this.filterLabel = new JLabel();
        this.textFilter = new JTextField();
        this.jScrollPaneNote = new JScrollPane();
        this.noteList = new JList(this.filteredModel);
        this.jLabel1 = new JLabel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                NoteChooser.this.formComponentResized(evt);
            }
        });
        this.jSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NoteChooser.this.jSplitPanePropertyChange(evt);
            }
        });
        this.jPanel1.setPreferredSize(new Dimension(250, 383));
        this.noteTitle.setFont(new Font("DejaVu Sans", 1, 12));
        this.noteTitle.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.noteTitle, (String)NbBundle.getMessage(NoteChooser.class, (String)"NoteChooser.noteTitle.text"));
        this.noteTitle.setToolTipText(NbBundle.getMessage(NoteChooser.class, (String)"NoteChooser.noteTitle.toolTipText"));
        this.noteTitle.setVerticalAlignment(1);
        this.noteTitle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.noteScrollPane.setPreferredSize(new Dimension(188, 93));
        this.noteText.setEditable(false);
        this.noteText.setColumns(20);
        this.noteText.setFont(new Font("DejaVu Sans", 2, 12));
        this.noteText.setLineWrap(true);
        this.noteText.setRows(5);
        this.noteText.setText(NbBundle.getMessage(NoteChooser.class, (String)"NoteChooser.noteText.text"));
        this.noteText.setToolTipText(NbBundle.getMessage(NoteChooser.class, (String)"NoteChooser.noteText.toolTipText"));
        this.noteText.setWrapStyleWord(true);
        this.noteText.setPreferredSize(null);
        this.noteScrollPane.setViewportView(this.noteText);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteTitle, -1, 238, Short.MAX_VALUE).addComponent(this.noteScrollPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.noteTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noteScrollPane, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setLeftComponent(this.jPanel1);
        this.jPanel2.setPreferredSize(new Dimension(200, 58));
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getMessage(NoteChooser.class, (String)"NoteChooser.filterLabel.text"));
        this.textFilter.setText(NbBundle.getMessage(NoteChooser.class, (String)"NoteChooser.textFilter.text"));
        this.noteList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.noteList.setFont(new Font("DejaVu Sans Condensed", 0, 10));
        this.noteList.setSelectionMode(0);
        this.noteList.setLayoutOrientation(2);
        this.noteList.setVisibleRowCount(-1);
        this.noteList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NoteChooser.this.noteListMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                NoteChooser.this.noteListMousePressed(evt);
            }
        });
        this.noteList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                NoteChooser.this.noteListValueChanged(evt);
            }
        });
        this.jScrollPaneNote.setViewportView(this.noteList);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 10));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NoteChooser.class, (String)"NoteChooser.jLabel1.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneNote).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFilter, -1, 269, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterLabel).addComponent(this.textFilter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneNote, -1, 342, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel1).addContainerGap()));
        this.jSplitPane.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING, -1, 625, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING, -1, 402, Short.MAX_VALUE));
    }

    private void noteListValueChanged(ListSelectionEvent evt) {
        if (!this.noteList.isSelectionEmpty()) {
            NoteThumb note = (NoteThumb)this.filteredModel.get(this.noteList.getSelectedIndex());
            this.mainText = note.text;
            this.mainTitle = note.title;
            this.displayIconAndTitle(this.noteText.getWidth(), this.noteText.getHeight());
            this.okButton.setEnabled(true);
            this.registry.put("noteSelected", note.getId());
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private void noteListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.okButton.doClick();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        int h;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = evt.getComponent().getWidth();
        if (w > dim.width * 8 / 10) {
            w = dim.width * 8 / 10;
        }
        if ((h = evt.getComponent().getHeight()) > dim.height * 8 / 10) {
            h = dim.height * 8 / 10;
        }
        this.registry.put("noteWindowWidth", w);
        this.registry.put("noteWindowHeight", h);
    }

    private void jSplitPanePropertyChange(PropertyChangeEvent evt) {
        this.registry.put("noteSplitDividerLocation", this.jSplitPane.getDividerLocation());
    }

    private void noteListMousePressed(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.noteList.setSelectedIndex(this.noteList.locationToIndex(evt.getPoint()));
            JPopupMenu menu = new JPopupMenu();
            NoteThumb note = this.getSelectedThumb();
            final Entity entity = note.entity;
            if (entity == null) {
                return;
            }
            Entity[] ents = PropertyXRef.getReferences((Entity)note.entity);
            if (note.isNote && ents.length > 0) {
                for (Entity ent : ents) {
                    JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(this.getClass(), (String)"EditEntity", (Object)ent.toString(true)));
                    menu.add(menuItem);
                    final Entity finalEntity = ent;
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            NoteChooser.this.edit(finalEntity);
                        }
                    });
                }
            } else if (!note.isNote) {
                JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(this.getClass(), (String)"EditEntity", (Object)entity.toString(true)));
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        NoteChooser.this.edit(entity);
                    }
                });
            }
            menu.show(this.noteList, evt.getX(), evt.getY());
        }
    }

    private void edit(Entity entity) {
        this.cancelButton.doClick();
        SelectionDispatcher.fireSelection((Context)new Context(entity));
    }

    private void createNoteThumbs() {
        String[] ENTITIES;
        this.allNote.clear();
        this.allNote.add(new NoteThumb());
        for (String type : ENTITIES = new String[]{"INDI", "FAM", "SUBM"}) {
            Collection entities = this.gedcom.getEntities(type);
            for (Entity entity : entities) {
                Property[] properties;
                for (Property noteProp : properties = entity.getProperties("NOTE")) {
                    String text;
                    if (noteProp == null || noteProp instanceof PropertyNote || (text = noteProp.getValue().trim()).isEmpty()) continue;
                    NoteThumb note = new NoteThumb(noteProp, entity, text);
                    this.allNote.add(note);
                }
            }
        }
        Collection entities = this.gedcom.getEntities("NOTE");
        for (Note entity : entities) {
            if (entity == null || this.isSourceOnly(entity)) continue;
            String text = entity.getValue().trim();
            NoteThumb note = new NoteThumb((Property)entity, entity, text);
            Entity[] ents = PropertyXRef.getReferences((Entity)entity);
            note.setUnused(ents.length == 0);
            this.allNote.add(note);
        }
    }

    private void displayNoteThumbs() {
        this.filteredModel.clear();
        for (NoteThumb item : this.allNote) {
            this.filteredModel.addElement(item);
        }
    }

    private NoteThumb getSelectedThumb() {
        return (NoteThumb)this.filteredModel.get(this.noteList.getSelectedIndex());
    }

    public boolean isSelectedEntityNote() {
        NoteThumb note = this.getSelectedThumb();
        return note == null ? false : note.isNote;
    }

    public Entity getSelectedEntity() {
        NoteThumb note = this.getSelectedThumb();
        return note == null ? null : note.entity;
    }

    public String getSelectedText() {
        NoteThumb note = this.getSelectedThumb();
        return note == null ? "" : note.text;
    }

    public void filterModel(String filter) {
        this.noteList.clearSelection();
        this.noteList.setModel(new DefaultListModel());
        this.filteredModel.clear();
        for (NoteThumb item : this.allNote) {
            if (!item.text.toLowerCase().contains(filter.toLowerCase())) continue;
            this.filteredModel.addElement(item);
        }
        this.noteList.setModel(this.filteredModel);
    }

    private boolean isSourceOnly(Note entity) {
        boolean ret = false;
        List references = entity.getProperties(PropertyXRef.class);
        for (PropertyXRef refProp : references) {
            if (Utils.parentTagsContains((Property)refProp, "SOUR")) {
                ret = true;
                continue;
            }
            return false;
        }
        return ret;
    }

    public int getNbNotes() {
        return this.allNote.size();
    }

    private class ThumbComparator
    implements Comparator<NoteThumb> {
        private ThumbComparator() {
        }

        @Override
        public int compare(NoteThumb o1, NoteThumb o2) {
            String ent1 = o1.entity == null ? "0" : "1";
            String ent2 = o2.entity == null ? "0" : "1";
            String title1 = o1.title;
            String title2 = o2.title;
            String total1 = ent1 + o1.text.toLowerCase() + title1;
            String total2 = ent2 + o2.text.toLowerCase() + title2;
            return total1.compareTo(total2);
        }
    }

    private class NoteThumb {
        public String id = "";
        public boolean isNote = false;
        public Entity entity = null;
        public String title = "";
        public String text = "";
        public boolean isUnused = false;

        private NoteThumb() {
            this.id = "";
            this.isNote = true;
            this.entity = null;
            this.title = NbBundle.getMessage(this.getClass(), (String)"NewNoteTitle");
            this.text = NbBundle.getMessage(this.getClass(), (String)"NewNoteText");
        }

        private NoteThumb(Property origin, Note entity, String text) {
            this.id = origin.getEntity().getId() + "-" + origin.getPath(true).toString();
            this.isNote = true;
            this.entity = entity;
            this.title = this.getTitle((Entity)entity);
            this.text = text;
        }

        private NoteThumb(Property origin, Entity entity, String text) {
            this.id = entity.getId() + "-" + origin.getPath(true).toString();
            this.isNote = entity instanceof Note;
            this.entity = entity;
            this.title = this.getTitle(entity);
            this.text = text;
        }

        private void setUnused(boolean b) {
            this.isUnused = b;
        }

        private String getTitle(Entity entity) {
            if (entity == null) {
                return "";
            }
            if (entity instanceof Note) {
                Entity[] entityArray;
                int n;
                int n2;
                Entity[] ents = PropertyXRef.getReferences((Entity)((Note)entity));
                if (ents.length > 0 && (n2 = 0) < (n = (entityArray = ents).length)) {
                    Entity ent = entityArray[n2];
                    return entity.getId() + "<br>" + ent.toString(true) + (ents.length > 1 ? "<br>..." : "");
                }
            } else {
                return entity.toString(true);
            }
            return entity.getId();
        }

        private String getId() {
            return this.id;
        }
    }

    private static class ListEntryCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ListEntryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String color;
            NoteThumb entry = (NoteThumb)value;
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(1);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredSoftBevelBorder())));
            int labelWidth = THUMB_WIDTH - 8;
            int labelHeight = THUMB_HEIGHT - 8;
            int nbLines = labelHeight / 24;
            int nbTotalLines = this.getFontMetrics(this.getFont()).stringWidth(entry.text) / labelWidth;
            int nbMaxCars = entry.text.length();
            String add = "";
            if (nbTotalLines > nbLines) {
                nbMaxCars = nbMaxCars * nbLines / nbTotalLines - 3;
                add = "...";
            }
            String text = entry.text.substring(0, Math.min(entry.text.length(), nbMaxCars)) + add;
            this.setPreferredSize(new Dimension(labelWidth, labelHeight));
            String string = entry.isNote && !entry.isUnused ? "black" : (color = !entry.isNote && !entry.isUnused ? "blue" : "red");
            if (entry.entity == null) {
                text = "<center><font size=+0><br><br><i><b>" + text + "</b></i></font></center>";
            }
            this.setText("<html><center><font color=" + color + ">" + text + "</font></center></html>");
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

