/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;

public class ImportGeneanet
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importgeneanet_name();
    }

    protected String getImportComment() {
        return Bundle.importgeneanet_note();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        ret |= this.fixMediaName(gedcom);
        this.incrementProgress();
        this.incrementProgress();
        return ret |= this.removeDoubleAssociations(gedcom);
    }

    private boolean removeDoubleAssociations(Gedcom gedcom) {
        boolean fixed = false;
        ArrayList list = new ArrayList();
        gedcom.getIndis().forEach(entity -> this.getPropertiesRecursively(list, "ASSO", (Property)entity));
        HashMap<String, PropertyAssociation> mapL = new HashMap<String, PropertyAssociation>();
        for (Property prop : list) {
            if (prop instanceof PropertyAssociation) {
                PropertyAssociation pa = (PropertyAssociation)prop;
                String origine = pa.getEntity().getId();
                String destination = pa.getTargetEntity().getId();
                String key = origine + " -;- " + destination;
                if (mapL.containsKey(key)) {
                    PropertyAssociation po = (PropertyAssociation)mapL.get(key);
                    Property relaO = po.getProperty("RELA", false);
                    if (!relaO.getValue().contains("@")) {
                        Entity ent = po.getEntity();
                        this.fixes.add(new ImportFix(ent.getId(), "duplicateAssociations.1", po.getPath(true).getShortName(), "", po.getValue(), ""));
                        fixed = true;
                        ent.delProperty((Property)po);
                        mapL.remove(key);
                        mapL.put(key, pa);
                        continue;
                    }
                    Property relaA = pa.getProperty("RELA", false);
                    if (relaA.getValue().contains("@")) continue;
                    Entity ent = pa.getEntity();
                    this.fixes.add(new ImportFix(ent.getId(), "duplicateAssociations.1", pa.getPath(true).getShortName(), "", pa.getValue(), ""));
                    fixed = true;
                    ent.delProperty((Property)pa);
                    continue;
                }
                mapL.put(key, pa);
                continue;
            }
            LOG.log(Level.WARNING, "The following association property is not of type PropertyAssociation: " + prop);
        }
        return fixed;
    }

    private boolean fixMediaName(Gedcom gedcom) {
        boolean hasErrors = false;
        List fileList = gedcom.getPropertiesByClass(PropertyFile.class);
        for (Property file : fileList) {
            String valeur;
            String oldValue = valeur = file.getValue();
            if (!valeur.startsWith("http://gw.geneanet.org")) continue;
            if ((valeur = valeur.replace("http://", "https://")).indexOf("medium") > 0) {
                valeur = valeur.replace("medium", "normal");
            }
            file.setValue(valeur);
            this.fixes.add(new ImportFix(file.getEntity().getId(), "textformatting.3", file.getPath().getShortName(), "", oldValue, valeur));
        }
        return hasErrors;
    }
}

