/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import ancestris.util.TimingUtility;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.openide.util.Exceptions;

public class ImportHeredis
extends Import {
    private boolean repoOK = false;
    private static int clerepo = 0;
    private static final HashMap<String, Integer> hashrepo = new HashMap();
    private static final StringBuilder sb = new StringBuilder();

    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importheredis_name();
    }

    protected String getImportComment() {
        return Bundle.importheredis_note();
    }

    protected void init() {
        super.init();
        this.invalidPaths.add("OBJE:DATE");
        this.invalidPaths.add("INDI:ASSO:TITL");
        this.invalidPaths.add("NOTE:RESN");
        this.invalidPaths.add("SOUR:RESN");
        this.invalidPaths.add("OBJE:RESN");
        this.invalidPaths.add("_SUBMAP:LATI");
        this.invalidPaths.add("_SUBMAP:LONG");
        this.invalidPaths.add("ASSO:TYPE");
    }

    protected void firstPass() {
        super.firstPass();
        this.GEDCOM_VERSION = "5.5.1";
        this.firstPassRepo();
    }

    protected boolean process() throws IOException {
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        String valueBefore = this.input.getValue();
        TimingUtility.getInstance().reset();
        if ("HEAD:GEDC:VERS".equalsIgnoreCase(pathBefore)) {
            String valueAfter = this.GEDCOM_VERSION;
            if (!valueBefore.equals(valueAfter)) {
                this.output.writeLine(2, "VERS", this.GEDCOM_VERSION);
                this.fixes.add(new ImportFix(this.currentXref, "header.Version", pathBefore, pathBefore, valueBefore, valueAfter));
                return true;
            }
            return false;
        }
        if (this.input.getLevel() == 3 && this.input.getTag().equals("WEB")) {
            String valueAfter = "http://" + valueBefore;
            this.output.writeLine(3, "WWW", valueAfter);
            this.fixes.add(new ImportFix(this.currentXref, "header.Web", pathBefore, pathBefore, valueBefore, valueAfter));
            return true;
        }
        if (this.processRepo()) {
            return true;
        }
        if (this.processTagNotAllowed()) {
            return true;
        }
        return super.process();
    }

    protected void finalise() throws IOException {
        super.finalise();
        this.finaliseRepo();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        this.incrementProgress();
        return ret |= this.processEntities(gedcom);
    }

    public void complete() {
        super.complete();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    private void firstPassRepo() {
        if (!this.repoOK && this.input.getLevel() == 1 && this.input.getTag().equals("REPO")) {
            String value = this.input.getValue();
            if (!value.matches("\\@[A-Z0-9]+\\@")) {
                if (!hashrepo.containsKey(value)) {
                    hashrepo.put(this.input.getValue(), ++clerepo);
                    sb.append("0 @REPO").append(clerepo).append("@ REPO").append(EOL);
                    sb.append("1 NAME ").append(this.input.getValue()).append(EOL);
                }
            } else {
                this.repoOK = true;
            }
        }
    }

    private boolean processRepo() throws IOException {
        if (!this.repoOK && this.input.getLevel() == 1 && this.input.getTag().equals("REPO")) {
            String pathBefore = this.input.getPath().getShortName();
            String valueBefore = this.input.getValue();
            if (hashrepo.containsKey(valueBefore)) {
                String valueAfter = "@REPO" + hashrepo.get(this.input.getValue()) + "@";
                this.output.writeLine(1, "REPO", valueAfter);
                this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.20", pathBefore, pathBefore, valueBefore, valueAfter));
            }
            return true;
        }
        return false;
    }

    private void finaliseRepo() throws IOException {
        if (!this.repoOK) {
            this.output.write(sb.toString());
            for (String repoName : hashrepo.keySet()) {
                int index = hashrepo.get(repoName);
                this.fixes.add(new ImportFix("REPO" + index, "invalidEntity.21", "", "REPO", "", repoName));
            }
        }
    }

    private boolean processTagNotAllowed() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        String valueBefore = this.input.getValue();
        if ("SOUR:TYPE".equalsIgnoreCase(path.toString())) {
            this.output.writeLine(this.input.getLevel(), "NOTE", valueBefore);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.2", pathBefore, path.getParent().getShortName() + ":NOTE", valueBefore, valueBefore));
            return true;
        }
        if ("ACQU".equalsIgnoreCase(tag)) {
            this.output.writeLine(this.input.getLevel(), "EVEN", valueBefore);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", pathBefore, path.getParent().getShortName() + ":EVEN", valueBefore, valueBefore));
            return true;
        }
        if (path.toString().startsWith("INDI") && "HUSB".equalsIgnoreCase(tag) || path.toString().startsWith("INDI") && "AGE".equalsIgnoreCase(tag) && path.toString().contains("HUSB") || path.toString().startsWith("INDI") && "WIFE".equalsIgnoreCase(tag) || path.toString().startsWith("INDI") && "AGE".equalsIgnoreCase(tag) && path.toString().contains("WIFE") || "TIME".equals(tag) && !path.toString().startsWith("HEAD") && !path.toString().contains("CHAN")) {
            this.output.writeLine(this.input.getLevel(), "_" + tag, valueBefore);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.1", pathBefore, path.getParent().getShortName() + ":_" + tag, valueBefore, valueBefore));
            return true;
        }
        if ("SEX".equals(tag) && "?".equals(this.input.getValue())) {
            this.output.writeLine(this.input.getLevel(), tag, "U");
            this.fixes.add(new ImportFix(this.currentXref, "invalidSex.1", pathBefore, pathBefore, valueBefore, "U"));
            return true;
        }
        return false;
    }

    public boolean processEntities(Gedcom gedcom) {
        String pathAfter;
        boolean hasErrors = false;
        Property[] props = null;
        ArrayList citationNotes = new ArrayList();
        for (Entity entity : gedcom.getEntities()) {
            for (Property prop : props = entity.getProperties("EVEN", false)) {
                Property[] types;
                if (!prop.getValue().isEmpty() || (types = prop.getProperties("TYPE", false)) == null || types.length <= 1) continue;
                Property type2 = types[1];
                String valueBefore = type2.getValue();
                String pathBefore = type2.getPath(true).getShortName();
                pathAfter = prop.getPath(true).getShortName();
                prop.setValue(valueBefore);
                prop.delProperty(type2);
                this.fixes.add(new ImportFix(entity.getId(), "invalidCardinality.1", pathBefore, pathAfter, valueBefore, valueBefore));
                hasErrors = true;
            }
            if (entity.getTag().equals("HEAD")) continue;
            citationNotes.addAll(entity.getAllProperties("NOTE"));
        }
        Property[] citationNotesArray = citationNotes.toArray(new Property[citationNotes.size()]);
        Note note = null;
        Property parent = null;
        try {
            for (Property citationNote : citationNotesArray) {
                String valueBefore = citationNote.getValue();
                String pathBefore = citationNote.getPath(true).getShortName();
                note = (Note)gedcom.createEntity("NOTE");
                note.setValue(valueBefore);
                parent = citationNote.getParent();
                int i = parent.getPropertyPosition(citationNote);
                parent.addNote(note);
                parent.delProperty(citationNote);
                pathAfter = note.getPath(true).getShortName();
                this.fixes.add(new ImportFix(note.getId(), "createdEntity.1", pathBefore, pathAfter, valueBefore, valueBefore));
                hasErrors = true;
            }
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return hasErrors;
    }
}

