/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor;

import ancestris.modules.commonAncestor.PreviewTopComponent;
import ancestris.modules.commonAncestor.Renderer;
import ancestris.modules.commonAncestor.Step;
import ancestris.modules.commonAncestor.graphics.GraphicsOutputFactory;
import ancestris.modules.commonAncestor.graphics.IGraphicsOutput;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommonAncestorTree {
    private List<Step> firstIndiDirectLinks = new ArrayList<Step>();
    private List<Step> secondIndiDirectLinks = new ArrayList<Step>();
    private final GraphicsOutputFactory outputs = new GraphicsOutputFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Indi> findCommonAncestors(Indi indi1, Indi indi2) {
        try {
            SelectionDispatcher.muteSelection((boolean)true);
            Set<Indi> ancestorList = new LinkedHashSet<Indi>();
            if (indi1 == null || indi2 == null) {
                LinkedHashSet<Indi> linkedHashSet = ancestorList;
                return linkedHashSet;
            }
            if (indi1.isAncestorOf(indi2)) {
                ancestorList.add(indi1);
            } else if (indi2.isAncestorOf(indi1)) {
                ancestorList.add(indi2);
            } else {
                this.getCommonAncestor(indi1, indi2, ancestorList);
                this.getCommonAncestor(indi2, indi1, ancestorList);
                ancestorList = this.filterAncestors(ancestorList);
            }
            LinkedHashSet<Indi> linkedHashSet = ancestorList;
            return linkedHashSet;
        }
        finally {
            SelectionDispatcher.muteSelection((boolean)false);
        }
    }

    public boolean selectLines(Indi indi1, Indi indi2, Indi ancestor) {
        this.firstIndiDirectLinks.clear();
        this.secondIndiDirectLinks.clear();
        if (indi1 == null || indi2 == null || ancestor == null) {
            return false;
        }
        List lines1 = ancestor.getAncestorLinesWith(indi1);
        List lines2 = ancestor.getAncestorLinesWith(indi2);
        if (lines1.size() + lines2.size() == 0) {
            return false;
        }
        List line1 = lines1.size() > 0 ? (List)lines1.get(0) : new ArrayList();
        List line2 = lines2.size() > 0 ? (List)lines2.get(0) : new ArrayList();
        int maxSize1 = Integer.MAX_VALUE;
        int maxSize2 = Integer.MAX_VALUE;
        for (List firstTreeLine : lines1) {
            for (List secondTreeLine : lines2) {
                boolean existCommonIndi = false;
                for (Indi firstIndi : firstTreeLine) {
                    if (firstIndi == indi1 || firstIndi == ancestor) continue;
                    for (Indi secondIndi : secondTreeLine) {
                        if (secondIndi == indi2 || secondIndi == ancestor || !firstIndi.getId().equals(secondIndi.getId())) continue;
                        existCommonIndi = true;
                        break;
                    }
                    if (!existCommonIndi) continue;
                    break;
                }
                if (!existCommonIndi) {
                    if (firstTreeLine.size() >= maxSize1 && secondTreeLine.size() >= maxSize2) continue;
                    line1 = firstTreeLine;
                    line2 = secondTreeLine;
                    maxSize1 = line1.size();
                    maxSize2 = line2.size();
                    continue;
                }
                existCommonIndi = false;
            }
        }
        Indi child = null;
        for (Indi indi : line1) {
            this.firstIndiDirectLinks.add(new Step(this.getLastFamilyWhereSpouse(indi, child), indi, indi.getSex()));
            child = indi;
        }
        child = null;
        for (Indi indi : line2) {
            this.secondIndiDirectLinks.add(new Step(this.getLastFamilyWhereSpouse(indi, child), indi, indi.getSex()));
            child = indi;
        }
        Collections.reverse(this.firstIndiDirectLinks);
        Collections.reverse(this.secondIndiDirectLinks);
        return true;
    }

    public void createPreview(Indi indi1, Indi indi2, Indi ancestor, boolean displayedId, boolean displayRecentYears, int husband_or_wife_first, PreviewTopComponent previewTopComponent) {
        this.selectLines(indi1, indi2, ancestor);
        previewTopComponent.updatePreView(indi1, indi2, this.firstIndiDirectLinks, this.secondIndiDirectLinks, displayedId, displayRecentYears, husband_or_wife_first);
    }

    public void createCommonTree(Indi indi1, Indi indi2, Indi ancestor, File outputFile, boolean displayedId, boolean displayRecentYears, int husband_or_wife_first, String fileTypeName) {
        if (!this.selectLines(indi1, indi2, ancestor)) {
            return;
        }
        IGraphicsOutput output = this.outputs.createOutput(outputFile, fileTypeName);
        if (output == null) {
            return;
        }
        try {
            output.output(new Renderer(indi1, indi2, this.firstIndiDirectLinks, this.secondIndiDirectLinks, displayedId, displayRecentYears, husband_or_wife_first));
        }
        catch (IOException e) {
            System.out.println(e.toString());
            return;
        }
    }

    private Set<Indi> filterAncestors(Set<Indi> ancestorList) {
        LinkedHashSet<Indi> filteredList = new LinkedHashSet<Indi>();
        boolean found = false;
        for (Indi ancestor : ancestorList) {
            Fam[] families;
            found = false;
            for (Fam familie : families = ancestor.getFamiliesWhereSpouse()) {
                Indi otherSpouse = familie.getOtherSpouse(ancestor);
                if (!filteredList.contains(otherSpouse)) continue;
                found = true;
            }
            if (found) continue;
            filteredList.add(ancestor);
        }
        return filteredList;
    }

    private Fam getLastFamilyWhereSpouse(Indi indi, Indi child) {
        Fam[] fams = indi.getFamiliesWhereSpouse();
        if (fams == null || fams.length == 0) {
            return null;
        }
        Fam ret = fams[fams.length - 1];
        if (child != null) {
            for (Fam fam : fams) {
                if (!child.isChildIn(fam)) continue;
                ret = fam;
                break;
            }
        }
        return ret;
    }

    private void getCommonAncestor(Indi firstIndi, Indi secondIndi, Set<Indi> ancestorList) {
        Indi mother;
        Indi father = firstIndi.getBiologicalFather();
        if (father != null) {
            if (father.isAncestorOf(secondIndi)) {
                ancestorList.add(father);
            } else {
                this.getCommonAncestor(father, secondIndi, ancestorList);
            }
        }
        if ((mother = firstIndi.getBiologicalMother()) != null) {
            if (mother.isAncestorOf(secondIndi)) {
                ancestorList.add(mother);
            } else {
                this.getCommonAncestor(mother, secondIndi, ancestorList);
            }
        }
    }

    public Map<String, IGraphicsOutput> getOutputList() {
        return this.outputs.getOutputList();
    }

    public List<String> getFileTypeNames() {
        return this.outputs.getFileTypeNames();
    }
}

