/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.util.regex.Pattern;

public class PropertyEvent
extends PropertyEventDetails {
    public static ImageIcon IMG = Grammar.V55.getMeta(new TagPath("INDI:EVEN")).getImage();
    private boolean knownToHaveHappened;
    private String description;
    protected static final String INDI_TAG_YES_55 = "BIRT|CHR|DEAT|BURI|CREM|ADOP|BAPM|BARM|BASM|BLES|CHRA|CONF|FCOM|ORDN|NATU|EMIG|IMMI|CENS|PROB|WILL|GRAD|RETI|";
    protected static final String FAM_TAG_YES_55 = "ANUL|CENS|DIV|DIVF|ENGA|MARR|MARB|MARC|MARL|MARS|";
    protected static Pattern tag_y_55 = Pattern.compile("(BIRT|CHR|DEAT|BURI|CREM|ADOP|BAPM|BARM|BASM|BLES|CHRA|CONF|FCOM|ORDN|NATU|EMIG|IMMI|CENS|PROB|WILL|GRAD|RETI|ANUL|CENS|DIV|DIVF|ENGA|MARR|MARB|MARC|MARL|MARS|)");
    protected static final String INDI_TAG_YES_551 = "BIRT|CHR|DEAT|";
    protected static final String FAM_TAG_YES_551 = "MARR|";
    protected static Pattern tag_y_551 = Pattern.compile("(BIRT|CHR|DEAT|MARR|)");

    public PropertyEvent(String tag) {
        super(tag);
    }

    @Override
    public String getValue() {
        if (this.description != null && !this.description.isEmpty()) {
            return this.description;
        }
        return this.knownToHaveHappened ? "Y" : "";
    }

    @Override
    public String getDisplayValue() {
        if (this.description != null && !this.description.isEmpty() && !this.knownToHaveHappened) {
            return this.description;
        }
        return this.knownToHaveHappened ? resources.getString("prop.event.knwontohavehappened") : "";
    }

    @Override
    public void setValue(String value) {
        this.setKnownToHaveHappened(value.toLowerCase().equals("y"));
        this.description = value;
    }

    public static TagPath[] getTagPaths(Gedcom gedcom) {
        return gedcom.getGrammar().getAllPaths(null, PropertyEvent.class);
    }

    public Boolean isKnownToHaveHappened() {
        if (this.getTag().equals("EVEN")) {
            return null;
        }
        return new Boolean(this.knownToHaveHappened);
    }

    public void setKnownToHaveHappened(boolean set) {
        String old = this.getValue();
        this.knownToHaveHappened = set;
        this.description = set ? "Y" : "";
        this.propagatePropertyChanged(this, old);
    }

    @Override
    public boolean isValid() {
        boolean hasPDChild;
        String tag = this.getTag();
        if (!tag_y_55.matcher(tag).matches()) {
            return true;
        }
        String value = this.getValue();
        Grammar grammar = this.getGedcom().getGrammar();
        boolean isNull = value.isEmpty();
        boolean isY = value.equals("Y");
        boolean isV55 = Grammar.V55.equals(grammar);
        boolean isV551 = Grammar.V551.equals(grammar);
        boolean isTagY55 = tag_y_55.matcher(tag).matches();
        boolean isTagY551 = tag_y_551.matcher(tag).matches();
        boolean isYesTag = isV55 && isTagY55 || isV551 && isTagY551 || isV551 && isTagY55;
        boolean hasChild = this.getNoOfProperties() > 0;
        boolean bl = hasPDChild = this.getProperty("PLAC", true) != null || this.getProperty("DATE", true) != null;
        if (isNull) {
            if (!hasChild) {
                if (isYesTag) {
                    this.invalidReason = "err.yestag.YvalueRequired";
                    return false;
                }
                return super.isValid();
            }
            return true;
        }
        if (isY) {
            if (isYesTag) {
                if (hasPDChild) {
                    this.invalidReason = "err.yestag.YvalueRedundant";
                    return false;
                }
                return true;
            }
            this.invalidReason = "err.yestag.YvalueForbidden";
            return false;
        }
        if (!isNull) {
            this.invalidReason = isYesTag ? (hasPDChild ? "err.yestag.nonYvalueForbidden" : "err.yestag.YvalueInstead") : "err.value.emptyRequired";
            return false;
        }
        return true;
    }
}

