/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.beans;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.view.PropertyProvider;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.BlueprintRenderer;
import genj.renderer.RenderOptions;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public class ABluePrintBeans
extends JPanel
implements GedcomListener,
PropertyProvider {
    private Blueprint emptyBluePrint = new Blueprint("");
    private static final Registry REGISTRY = Registry.get(ABluePrintBeans.class);
    private BlueprintRenderer renderer = null;
    private Property property;
    private Map<String, Blueprint> type2blueprint = new HashMap<String, Blueprint>();
    private boolean isAntialiasing = true;

    public ABluePrintBeans() {
        BlueprintManager bpm = BlueprintManager.getInstance();
        for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
            String tag = Gedcom.ENTITIES[t];
            this.type2blueprint.put(tag, bpm.getBlueprint(tag, REGISTRY.get("blueprint." + tag, "")));
        }
        this.isAntialiasing = REGISTRY.get("antial", false);
    }

    public void setEmptyBluePrint(String bp) {
        this.emptyBluePrint = new Blueprint(bp);
    }

    public Property getProperty() {
        return this.property;
    }

    public void setContext(Property newProperty) {
        this.renderer = null;
        this.property = newProperty;
        Blueprint blueprint = this.property == null ? this.emptyBluePrint : this.getBlueprint(this.property.getTag());
        this.renderer = new BlueprintRenderer(blueprint);
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(256, 160);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle bounds = this.getBounds();
        g.setColor(Color.white);
        g.fillRect(0, 0, bounds.width, bounds.height);
        g.setColor(Color.black);
        g.setFont(RenderOptions.getInstance().getDefaultFont());
        if (this.renderer == null) {
            return;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isAntialiasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.renderer.render(g, this.property, new Rectangle(0, 0, bounds.width, bounds.height));
    }

    private Blueprint getBlueprint(String tag) {
        Blueprint result = this.type2blueprint.get(tag);
        if (result == null) {
            result = BlueprintManager.getInstance().getBlueprint(tag, "");
            this.type2blueprint.put(tag, result);
        }
        return result;
    }

    public void setBlueprint(String tag, Blueprint bp) {
        if (bp == null) {
            return;
        }
        this.type2blueprint.put(tag, bp);
    }

    public void setBlueprint(String tag, String bp) {
        if (bp == null) {
            return;
        }
        this.type2blueprint.put(tag, new Blueprint(bp));
    }

    public void setAntialiasing(boolean set) {
        this.isAntialiasing = set;
        this.repaint();
    }

    public boolean isAntialiasing() {
        return this.isAntialiasing;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        AncestrisPlugin.register((Object)this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        AncestrisPlugin.unregister((Object)this);
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        if (this.property == entity) {
            this.setContext(null);
        }
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        if (this.property == property.getEntity()) {
            this.repaint();
        }
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        this.gedcomPropertyChanged(gedcom, property);
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
        this.gedcomPropertyChanged(gedcom, property);
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
    }

    public Property provideVisibleProperty(Point point) {
        return this.property;
    }
}

