/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.gedcomvalidate;

import ancestris.modules.gedcom.gedcomvalidate.GedcomValidate;
import ancestris.modules.gedcom.gedcomvalidate.Test;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.view.ViewContext;
import java.util.List;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

class TestDateRangeValid
extends Test {
    private final GedcomValidate report;

    TestDateRangeValid(GedcomValidate report) {
        super((String[])null, Property.class);
        this.report = report;
    }

    @Override
    void test(Property prop, TagPath path, List<ViewContext> issues, GedcomValidate report) {
        if (!(prop instanceof PropertyDate)) {
            return;
        }
        PropertyDate propDate = (PropertyDate)prop;
        if (this.checkPointInTime(propDate.getStart(), report.minYear, report.maxYear) && this.checkPointInTime(propDate.getEnd(), report.minYear, report.maxYear)) {
            return;
        }
        issues.add(new ViewContext(prop).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)"warn.year.range", (Object)propDate.getDisplayValue(), (Object)report.minYear.getYear(), (Object)report.maxYear.getYear(), (Object)path, (Object[])new Object[0])));
    }

    private boolean checkPointInTime(PointInTime pit, PointInTime min, PointInTime max) {
        if (pit == null) {
            return true;
        }
        if (!pit.isValid()) {
            return true;
        }
        Parameters.notNull((CharSequence)"min", (Object)min);
        Parameters.notNull((CharSequence)"max", (Object)max);
        return pit.compareTo(min) >= 0 && pit.compareTo(max) <= 0;
    }

    @Override
    String getCode() {
        return "05";
    }
}

