/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.placeeditor.topcomponents;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringJoiner;

public class CellsData
implements Transferable {
    private Object[][] data;
    public static final DataFlavor CELL_DATA_FLAVOR = new DataFlavor(Object.class, "application/x-cell-values");
    public static final DataFlavor STRING_FLAVOR = DataFlavor.stringFlavor;
    public static final DataFlavor TEXT_FLAVOR = DataFlavor.getTextPlainUnicodeFlavor();
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{CELL_DATA_FLAVOR, STRING_FLAVOR, TEXT_FLAVOR};

    public CellsData(Object[][] data) {
        this.data = data;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < FLAVORS.length; ++i) {
            if (!flavor.equals(FLAVORS[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(TEXT_FLAVOR)) {
            return new StringReader(this.getStringData());
        }
        if (flavor.equals(STRING_FLAVOR)) {
            return this.getStringData();
        }
        if (flavor.equals(CELL_DATA_FLAVOR)) {
            return this.data;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public StringSelection getStringTransferable() throws IOException {
        return new StringSelection(this.getStringData());
    }

    private String getStringData() throws IOException {
        if (this.data == null || this.data.length == 0 || this.data[0].length == 0) {
            return "";
        }
        int nbRows = this.data.length;
        int nbCols = this.data[0].length;
        StringJoiner joinerRows = new StringJoiner("\r\n");
        for (int row = 0; row < nbRows; ++row) {
            StringJoiner joinerCols = new StringJoiner("\t");
            for (int col = 0; col < nbCols; ++col) {
                joinerCols.add(this.data[row][col] == null ? "" : this.data[row][col].toString());
            }
            joinerRows.add(joinerCols.toString());
        }
        return joinerRows.toString();
    }
}

