/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.familygroups;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.ActionSaveViewAsGedcom;
import ancestris.modules.familygroups.ActionMark;
import ancestris.modules.familygroups.ActionSelectSubgroups;
import ancestris.modules.familygroups.FamilyGroupsRunner;
import ancestris.modules.familygroups.OpenFamilyGroupsAction;
import ancestris.util.TimingUtility;
import ancestris.util.Utilities;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyXRef;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.io.Filter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class FamilyGroupsPlugin
extends AncestrisPlugin
implements FamilyGroupsRunner {
    private static final Logger log = Logger.getLogger(FamilyGroupsPlugin.class.getName());
    private static final Level logLevel = Level.FINEST;
    private Gedcom gedcom;
    private Document document;
    private int minGroupSize = 0;
    private int maxGroupSize = 0;
    private int placeListLimit = 0;
    private int familyListLimit = 0;
    private boolean separateAssos = false;
    private boolean decujusForced = false;
    private boolean hideNote = false;
    private FamilyGroupFilter groupsFilter = null;
    private List<FamilyGroupFilter> filters = null;
    private int counter = 0;
    private int maxCounter = 0;
    private boolean cancel = false;
    private String taskName = "";
    private String state = "";

    public FamilyGroupsPlugin() {
    }

    public FamilyGroupsPlugin(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.taskName = NbBundle.getMessage(FamilyGroupsPlugin.class, (String)"CTL_FamilyGroupsTopComponent");
    }

    @Override
    public FamilyGroupsPlugin getFgp() {
        return this;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public void run() {
        if (this.gedcom != null) {
            this.document = this.start(this.gedcom);
        }
    }

    public void cancelTrackable() {
        this.cancel = true;
    }

    public int getProgress() {
        int progress = 100 * this.counter / this.maxCounter;
        log.log(logLevel, "Time=" + TimingUtility.getInstance().getTime() + " - state = " + this.getState() + " - progress = " + progress + " (" + this.counter + ")");
        return progress;
    }

    public String getState() {
        return NbBundle.getMessage(this.getClass(), (String)"TaskState", (Object)this.state);
    }

    public String getTaskName() {
        return this.taskName;
    }

    private Document start(Gedcom gedcom) {
        this.maxCounter = gedcom.getIndis().size() + 1;
        this.counter = 0;
        this.state = "(" + NbBundle.getMessage(this.getClass(), (String)"TaskState_locating") + ")";
        TimingUtility.getInstance().reset();
        log.log(logLevel, "Time=" + TimingUtility.getInstance().getTime());
        ArrayList<Tree> trees = new ArrayList<Tree>();
        Document doc = null;
        Tree treeAssos = new Tree();
        treeAssos.setAsso(true);
        this.setMinGroupSize(Integer.valueOf(NbPreferences.forModule(OpenFamilyGroupsAction.class).get("minGroupSize", "2")));
        this.setMaxGroupSize(Integer.valueOf(NbPreferences.forModule(OpenFamilyGroupsAction.class).get("maxGroupSize", "20")));
        this.setPlaceListLimit(Integer.valueOf(NbPreferences.forModule(OpenFamilyGroupsAction.class).get("placeListLimit", "10")));
        this.setFamilyListLimit(Integer.valueOf(NbPreferences.forModule(OpenFamilyGroupsAction.class).get("familyListLimit", "10")));
        this.setAssoSeparation(NbPreferences.forModule(OpenFamilyGroupsAction.class).getBoolean("separateAssos", false));
        this.setDecujusForced(NbPreferences.forModule(OpenFamilyGroupsAction.class).getBoolean("decujusForced", false));
        this.setHideNote(NbPreferences.forModule(OpenFamilyGroupsAction.class).getBoolean("hideNote", false));
        String title = NbBundle.getMessage(this.getClass(), (String)"title", (Object)gedcom.getDisplayName());
        Collection indiList = gedcom.getIndis();
        HashSet<Indi> unvisited = new HashSet<Indi>(indiList);
        while (!unvisited.isEmpty()) {
            if (this.cancel) {
                return doc;
            }
            Indi indi = (Indi)unvisited.iterator().next();
            Tree tree = new Tree();
            this.iterate(indi, tree, treeAssos, unvisited);
            if (tree.isEmpty()) continue;
            trees.add(tree);
        }
        Collections.sort(trees);
        if (!treeAssos.isEmpty()) {
            trees.add(treeAssos);
        }
        if (!trees.isEmpty()) {
            Tree tree;
            int i;
            doc = new Document(title, "Helvetica", 12, 0, 6, 0);
            doc.startSection(title);
            int grandtotal = 0;
            int loners = 0;
            int nbSmallGroups = 0;
            for (i = 0; i < trees.size(); ++i) {
                tree = (Tree)trees.get(i);
                tree.setNb(i + 1);
                tree.calculateElements();
                if (tree.size() < this.getMinGroupSize()) {
                    loners += tree.size();
                    ++nbSmallGroups;
                    continue;
                }
                grandtotal += tree.size();
            }
            this.state = "(" + NbBundle.getMessage(this.getClass(), (String)"TaskState_rendering") + ")";
            doc.nextParagraph(" ");
            doc.addText("   ");
            doc.nextParagraph("font-size=1.1em,font-weight=bold,line-height=200%");
            if (trees.size() > 1) {
                doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.grandtotal", (Object)gedcom.getIndis().size(), (Object)trees.size()));
                doc.nextParagraph("font-size=1.1em,font-weight=bold,line-height=200%");
                doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.groupsdisplayed", (Object)(trees.size() - nbSmallGroups), (Object)this.getMinGroupSize(), (Object)grandtotal));
                if (loners > 0) {
                    doc.nextParagraph("font-size=1.1em,font-weight=bold,line-height=200%");
                    doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.loners", (Object)nbSmallGroups, (Object)loners));
                }
            } else {
                doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.grandtotal_one", (Object)gedcom.getIndis().size(), (Object)trees.size()));
                doc.nextParagraph("font-size=1.1em,font-weight=bold,line-height=200%");
                doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.groupsdisplayed_one", (Object)(trees.size() - nbSmallGroups), (Object)this.getMinGroupSize(), (Object)grandtotal));
            }
            if (!this.hideNote) {
                doc.nextParagraph("font-size=1.1em, color=white");
                doc.addText("-");
                doc.nextParagraph("font-size=1em,line-height=200%");
                doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.saveas"));
            }
            doc.nextParagraph("font-size=1.1em, color=white");
            doc.addText("-");
            doc.startTable("width=100%, border=1, border-style=solid, border-color=grey, color=black");
            this.filters = new ArrayList<FamilyGroupFilter>(10);
            for (i = 0; i < trees.size(); ++i) {
                tree = (Tree)trees.get(i);
                log.log(logLevel, "Time=" + TimingUtility.getInstance().getTime() + " Analysing tree number " + i + " of size " + tree.size());
                if (tree.size() >= this.getMinGroupSize()) {
                    Map subgroups;
                    LinkedList gi;
                    List lists;
                    int listLength;
                    doc.nextTableRow("font-size=1.125em, font-weight=bold, line-height=200%");
                    doc.nextTableCell("number-columns-spanned=6");
                    String word = NbBundle.getMessage(this.getClass(), (String)(tree.size() > 1 ? "FamilyGroupsTopComponent.individual_plural" : "FamilyGroupsTopComponent.individual_singular"));
                    doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.groupCount", (Object[])new Object[]{i + 1, tree.size(), word}));
                    doc.nextTableRow();
                    doc.nextTableCell("number-columns-spanned=6");
                    if (!tree.isAsso()) {
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.mostAncientAncestor"));
                        doc.addText(" " + tree.oldestIndividual.getLastName(), "font-weight=bold, color=blue");
                        doc.addText(" " + tree.oldestIndividual.getFirstName() + " (" + tree.oldestIndividual.getBirthAsString() + " - " + tree.oldestIndividual.getDeathAsString() + ") ");
                        doc.addLink(tree.oldestIndividual.getId(), tree.oldestIndividual.getLinkAnchor());
                        doc.nextParagraph();
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.mostRecentAncestor"));
                        doc.addText(" " + tree.youngestIndividual.getLastName(), "font-weight=bold, color=blue");
                        doc.addText(" " + tree.youngestIndividual.getFirstName() + " (" + tree.youngestIndividual.getBirthAsString() + " - " + tree.youngestIndividual.getDeathAsString() + ") ");
                        doc.addLink(tree.youngestIndividual.getId(), tree.youngestIndividual.getLinkAnchor());
                        doc.nextParagraph();
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.mostLikelyDeCujus"));
                        doc.addText(" " + tree.decujusIndividual.getLastName(), "font-weight=bold, color=blue");
                        doc.addText(" " + tree.decujusIndividual.getFirstName() + " (" + tree.decujusIndividual.getBirthAsString() + " - " + tree.decujusIndividual.getDeathAsString() + ") ");
                        doc.addLink(tree.decujusIndividual.getId(), tree.decujusIndividual.getLinkAnchor());
                        doc.addText(" " + NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.deCujusNbAncestors", (Object)tree.decujusNbAncestors));
                    } else {
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.assoTreeTitle"));
                    }
                    List<String> places = tree.getPlaces();
                    if (!places.isEmpty()) {
                        doc.nextTableRow();
                        doc.nextTableCell("number-columns-spanned=6");
                        doc.nextParagraph();
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.mostFrequentPlaces"), "font-weight=bold");
                        int nbPlacesLimit = Math.min(places.size(), this.getPlaceListLimit());
                        int idxPlaces = 0;
                        for (String place : places) {
                            if (++idxPlaces > nbPlacesLimit) break;
                            doc.nextParagraph();
                            doc.addText("\u2219 ");
                            doc.addText(place);
                        }
                        doc.nextParagraph();
                    }
                    if ((listLength = ((List)(lists = tree.getLonguestLines(false)).get(0)).size()) > 1) {
                        doc.nextTableRow();
                        doc.nextTableCell("number-columns-spanned=6");
                        doc.nextParagraph();
                        String[] levels = new String[listLength];
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.longuestlines", (Object)lists.size(), (Object)listLength), "font-weight=bold");
                        doc.nextParagraph();
                        String decujusId = tree.getDecujusIndividual().getId();
                        lists = tree.getLonguestLines(true);
                        for (List indis : lists) {
                            Collections.reverse(indis);
                            String tab = "";
                            for (int l = 0; l < indis.size(); ++l) {
                                tab = tab + "---";
                                Indi indi = (Indi)indis.get(l);
                                if (indi.getId().equals(levels[l])) continue;
                                doc.addText(tab);
                                doc.addText("\u2219 ");
                                String genStr = tree.getGeneration(indi) + " - ";
                                if (indi.getId().equals(decujusId)) {
                                    doc.addText(genStr, "font-weight=bold");
                                    doc.addLink(indi.getId(), indi.getLinkAnchor());
                                    doc.addText("  " + indi.getDisplayTitle(false), "font-weight=bold");
                                } else {
                                    doc.addText(genStr);
                                    doc.addLink(indi.getId(), indi.getLinkAnchor());
                                    doc.addText("  " + indi.getDisplayTitle(false));
                                }
                                doc.nextParagraph();
                                levels[l] = indi.getId();
                            }
                        }
                        doc.nextParagraph();
                    }
                    if ((gi = tree.getGenerations()).size() > 1) {
                        doc.nextTableRow("font-weight=bold, color=#ffffff,background-color=#c0c0c0");
                        doc.nextTableCell("text-align=center");
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.generations"));
                        doc.nextTableCell("text-align=center");
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.nbindividuals"));
                        doc.nextTableCell("text-align=center");
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.nbtopindividuals"));
                        doc.nextTableCell("text-align=center");
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.nbbottomindividuals"));
                        doc.nextTableCell("text-align=center");
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.birthfrom"));
                        doc.nextTableCell("text-align=center");
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.birthto"));
                        for (GenInfo genInfo : gi) {
                            doc.nextTableRow();
                            doc.nextTableCell("text-align=center");
                            doc.addText("" + genInfo.genNumber + "");
                            doc.nextTableCell("text-align=center");
                            doc.addText("" + genInfo.nbIndi + "");
                            doc.nextTableCell("text-align=center");
                            doc.addText("" + genInfo.nbTop + "");
                            doc.nextTableCell("text-align=center");
                            doc.addText("" + genInfo.nbBottom + "");
                            doc.nextTableCell("text-align=center");
                            doc.addText("" + (genInfo.minBirthYear == 0 ? "-" : Integer.valueOf(genInfo.minBirthYear)) + "");
                            doc.nextTableCell("text-align=center");
                            doc.addText("" + (genInfo.maxBirthYear == 0 ? "-" : Integer.valueOf(genInfo.maxBirthYear)) + "");
                        }
                        doc.nextTableRow("font-weight=bold");
                        doc.nextTableCell("text-align=center");
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.total"));
                        doc.nextTableCell("text-align=center");
                        doc.addText("" + tree.size() + "");
                        doc.nextTableCell("text-align=center");
                        doc.addText("" + tree.nbTop + "");
                        doc.nextTableCell("text-align=center");
                        doc.addText("" + tree.nbBottom + "");
                        doc.nextTableCell("text-align=center");
                        doc.addText("" + (tree.minBirthYear == 0 ? "-" : Integer.valueOf(tree.minBirthYear)) + "");
                        doc.nextTableCell("text-align=center");
                        doc.addText("" + (tree.maxBirthYear == 0 ? "-" : Integer.valueOf(tree.maxBirthYear)) + "");
                    }
                    if ((subgroups = tree.getSubGroups()).size() > 1) {
                        int total = 0;
                        doc.nextTableRow();
                        doc.nextTableCell("number-columns-spanned=6");
                        doc.nextParagraph();
                        doc.nextTableRow("font-weight=bold, color=#ffffff,background-color=#c0c0c0");
                        doc.nextTableCell("text-align=center, number-columns-spanned=5");
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.nbsubgroups", (Object)subgroups.size()));
                        doc.nextTableCell("text-align=center");
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.nbindividuals"));
                        String subgroupName = "subgroupDC";
                        Set<Indi> subgroup = ((SubgroupInfo)subgroups.get(subgroupName)).getIndis();
                        doc.nextTableRow();
                        doc.nextTableCell("text-align=left, number-columns-spanned=5");
                        if (tree.decujusIndividual != null) {
                            doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.decujus", (Object)tree.decujusIndividual.getDisplayTitle(false)) + "  ", "font-weight=bold, color=blue");
                            doc.addLink(tree.decujusIndividual.getId(), tree.decujusIndividual.getLinkAnchor());
                            doc.addText(" " + NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.siblings") + " ", "font-weight=bold, color=blue");
                        } else {
                            doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.subgroupDC") + " - ", "font-weight=bold, color=blue");
                        }
                        doc.nextTableCell("text-align=center");
                        doc.addText("" + subgroup.size());
                        total += subgroup.size();
                        total = this.displaySubgroupLine("subgroupDDC", subgroups, doc, total);
                        total = this.displaySubgroupLine("subgroupSDDC", subgroups, doc, total);
                        total = this.displaySubgroupLine("subgroupTDDC", subgroups, doc, total);
                        subgroupName = "subgroupFA";
                        subgroup = ((SubgroupInfo)subgroups.get(subgroupName)).getIndis();
                        doc.nextTableRow();
                        doc.nextTableCell("number-columns-spanned=6");
                        doc.nextParagraph();
                        doc.nextTableRow();
                        doc.nextTableCell("text-align=left, number-columns-spanned=5");
                        if (tree.decujusFather != null) {
                            doc.addText(NbBundle.getMessage(this.getClass(), (String)("FamilyGroupsTopComponent." + subgroupName), (Object)tree.decujusFather.getDisplayTitle(false)) + "  ", "font-weight=bold, color=blue");
                            doc.addLink(tree.decujusFather.getId(), tree.decujusFather.getLinkAnchor());
                            doc.addText(" ", "font-weight=bold, color=blue");
                        } else {
                            doc.addText(NbBundle.getMessage(this.getClass(), (String)("FamilyGroupsTopComponent." + subgroupName), (Object)" - "), "font-weight=bold, color=blue");
                        }
                        doc.nextTableCell("text-align=center");
                        doc.addText("" + subgroup.size());
                        total += subgroup.size();
                        total = this.displaySubgroupLine("subgroupDFA", subgroups, doc, total);
                        total = this.displaySubgroupLine("subgroupSDFA", subgroups, doc, total);
                        total = this.displaySubgroupLine("subgroupTDFA", subgroups, doc, total);
                        subgroupName = "subgroupMA";
                        subgroup = ((SubgroupInfo)subgroups.get(subgroupName)).getIndis();
                        doc.nextTableRow();
                        doc.nextTableCell("number-columns-spanned=6");
                        doc.nextParagraph();
                        doc.nextTableRow();
                        doc.nextTableCell("text-align=left, number-columns-spanned=5");
                        if (tree.decujusMother != null) {
                            doc.addText(NbBundle.getMessage(this.getClass(), (String)("FamilyGroupsTopComponent." + subgroupName), (Object)tree.decujusMother.getDisplayTitle(false)) + "  ", "font-weight=bold, color=blue");
                            doc.addLink(tree.decujusMother.getId(), tree.decujusMother.getLinkAnchor());
                            doc.addText(" ", "font-weight=bold, color=blue");
                        } else {
                            doc.addText(NbBundle.getMessage(this.getClass(), (String)("FamilyGroupsTopComponent." + subgroupName), (Object)" - "), "font-weight=bold, color=blue");
                        }
                        doc.nextTableCell("text-align=center");
                        doc.addText("" + subgroup.size());
                        total += subgroup.size();
                        total = this.displaySubgroupLine("subgroupDMA", subgroups, doc, total);
                        total = this.displaySubgroupLine("subgroupSDMA", subgroups, doc, total);
                        total = this.displaySubgroupLine("subgroupTDMA", subgroups, doc, total);
                        subgroupName = "subgroupCA";
                        subgroup = ((SubgroupInfo)subgroups.get(subgroupName)).getIndis();
                        doc.nextTableRow();
                        doc.nextTableCell("number-columns-spanned=6");
                        doc.nextParagraph();
                        doc.nextTableRow();
                        doc.nextTableCell("text-align=left, number-columns-spanned=5");
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)("FamilyGroupsTopComponent." + subgroupName)), "font-weight=bold, color=blue");
                        doc.nextTableCell("text-align=center");
                        doc.addText("" + subgroup.size());
                        total += subgroup.size();
                        total = this.displaySubgroupLine("subgroupDCA", subgroups, doc, total);
                        total = this.displaySubgroupLine("subgroupSDCA", subgroups, doc, total);
                        total = this.displaySubgroupLine("subgroupTDCA", subgroups, doc, total);
                        subgroupName = "subgroupZ";
                        subgroup = ((SubgroupInfo)subgroups.get(subgroupName)).getIndis();
                        if (subgroup.size() > 0) {
                            doc.nextTableRow();
                            doc.nextTableCell("number-columns-spanned=6");
                            doc.nextParagraph();
                            doc.nextTableRow();
                            doc.nextTableCell("text-align=left, number-columns-spanned=5");
                            doc.addText(NbBundle.getMessage(this.getClass(), (String)("FamilyGroupsTopComponent." + subgroupName)), "font-weight=bold, color=blue");
                            doc.nextTableCell("text-align=center");
                            doc.addText("" + subgroup.size());
                            total += subgroup.size();
                        }
                        doc.nextTableRow();
                        doc.nextTableCell("text-align=left, number-columns-spanned=5");
                        doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.total"), "font-weight=bold");
                        doc.nextTableCell("text-align=center");
                        doc.addText("" + total, "font-weight=bold");
                        doc.nextTableRow();
                        doc.nextTableCell("number-columns-spanned=6");
                        doc.nextParagraph();
                        doc.addText(" ");
                    }
                    doc.nextTableRow();
                    doc.nextTableCell("number-columns-spanned=6");
                    doc.nextParagraph();
                    doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.mostDistant"), "font-weight=bold");
                    doc.nextTableRow("font-weight=bold, color=#ffffff,background-color=#c0c0c0");
                    doc.nextTableCell("number-columns-spanned=2");
                    doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.indi_name"));
                    doc.nextTableCell("number-columns-spanned=2");
                    doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.familySpouse"));
                    doc.nextTableCell("number-columns-spanned=2");
                    doc.addText(NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.familyChild"));
                    int nbFamiliesLimit = Math.min(tree.size(), this.getFamilyListLimit());
                    int idxFamilies = 0;
                    for (Indi indi : tree.sorted(true)) {
                        if (++idxFamilies > nbFamiliesLimit) break;
                        if (this.cancel) {
                            return doc;
                        }
                        Fam[] familiesWhereChild = indi.getFamiliesWhereChild();
                        Fam[] familiesWhereSpouse = indi.getFamiliesWhereSpouse();
                        int maxRows = Math.max(Math.max(familiesWhereChild.length, familiesWhereSpouse.length), 1);
                        for (int index = 0; index < maxRows; ++index) {
                            String wife;
                            String husb;
                            doc.nextTableRow();
                            if (index == 0) {
                                doc.nextTableCell("number-columns-spanned=2, number-rows-spanned=" + maxRows);
                                if (index == 0) {
                                    doc.addText(indi.getLastName(), "font-weight=bold, color=blue");
                                    doc.addText(" " + indi.getFirstName() + " (" + indi.getBirthAsString() + " - " + indi.getDeathAsString() + ") ");
                                    doc.addLink(indi.getId(), indi.getLinkAnchor());
                                } else {
                                    doc.addText(" ");
                                }
                            }
                            doc.nextTableCell("number-columns-spanned=2");
                            if (index < familiesWhereSpouse.length) {
                                husb = familiesWhereSpouse[index].getHusband() == null ? "?" : familiesWhereSpouse[index].getHusband().toString();
                                wife = familiesWhereSpouse[index].getWife() == null ? "?" : familiesWhereSpouse[index].getWife().toString();
                                doc.addText(husb + " - " + wife + " ");
                                doc.addLink(familiesWhereSpouse[index].getId(), familiesWhereSpouse[index].getLinkAnchor());
                            } else {
                                doc.addText(" ");
                            }
                            doc.nextTableCell("number-columns-spanned=2");
                            if (index < familiesWhereChild.length) {
                                husb = familiesWhereChild[index].getHusband() == null ? "?" : familiesWhereChild[index].getHusband().toString();
                                wife = familiesWhereChild[index].getWife() == null ? "?" : familiesWhereChild[index].getWife().toString();
                                doc.addText(husb + " - " + wife + " ");
                                doc.addLink(familiesWhereChild[index].getId(), familiesWhereChild[index].getLinkAnchor());
                                continue;
                            }
                            doc.addText(" ");
                        }
                    }
                    doc.nextTableRow("font-weight=bold");
                    doc.nextTableCell("number-columns-spanned=6");
                    doc.nextParagraph();
                    doc.addText(" ");
                    doc.nextParagraph();
                    doc.addText(" ");
                }
                FamilyGroupFilter filter = new FamilyGroupFilter(tree);
                AncestrisPlugin.register((Object)filter);
                this.filters.add(filter);
            }
            doc.endTable();
            doc.nextParagraph(" ");
            doc.addText("   ");
        }
        this.groupsFilter = new FamilyGroupFilter(new Tree());
        log.log(logLevel, "Time=" + TimingUtility.getInstance().getTime());
        return doc;
    }

    private void iterate(Indi indi, Tree tree, Tree treeAssos, Set<Indi> unvisited) {
        Stack<Indi> todos = new Stack<Indi>();
        if (unvisited.remove(indi)) {
            todos.add(indi);
        }
        while (!todos.isEmpty()) {
            Fam[] fams;
            Fam[] famcs;
            Indi todo = (Indi)todos.pop();
            for (Fam famc : famcs = todo.getFamiliesWhereChild()) {
                Indi father;
                if (famc == null) continue;
                Indi mother = famc.getWife();
                if (mother != null && unvisited.remove(mother)) {
                    todos.push(mother);
                }
                if ((father = famc.getHusband()) == null || !unvisited.remove(father)) continue;
                todos.push(father);
            }
            for (Fam fam : fams = todo.getFamiliesWhereSpouse()) {
                Indi spouse = fam.getOtherSpouse(todo);
                if (spouse != null && unvisited.remove(spouse)) {
                    todos.push(spouse);
                }
                for (Indi child : fam.getChildren()) {
                    if (!unvisited.remove(child)) continue;
                    todos.push(child);
                }
            }
            if ((famcs == null || famcs.length == 0) && (fams == null || fams.length == 0) && this.separateAssos && this.isAsso(indi)) {
                treeAssos.add(todo);
                continue;
            }
            tree.add(todo);
        }
    }

    private boolean isAsso(Indi indi) {
        Property[] assoProps = indi.getProperties("ASSO");
        return assoProps.length > 0;
    }

    public int getMinGroupSize() {
        return this.minGroupSize;
    }

    public void setMinGroupSize(int minGroupSize) {
        this.minGroupSize = minGroupSize;
    }

    public int getMaxGroupSize() {
        return this.maxGroupSize;
    }

    public void setMaxGroupSize(int maxGroupSize) {
        this.maxGroupSize = maxGroupSize;
    }

    public int getPlaceListLimit() {
        return this.placeListLimit;
    }

    public void setPlaceListLimit(int placeListLimit) {
        this.placeListLimit = placeListLimit;
    }

    public int getFamilyListLimit() {
        return this.familyListLimit;
    }

    public void setFamilyListLimit(int familyListLimit) {
        this.familyListLimit = familyListLimit;
    }

    public AbstractAncestrisAction selectSubgroupsAction(Gedcom gedcom, ActionSaveViewAsGedcom extractAction, ActionSaveViewAsGedcom extractGroupsAction) {
        return new ActionSelectSubgroups(gedcom, this.filters, extractAction, this.groupsFilter, extractGroupsAction);
    }

    public ActionSaveViewAsGedcom getExtractAction(Gedcom gedcom) {
        return new ActionSaveViewAsGedcom(gedcom, this.filters);
    }

    public ActionSaveViewAsGedcom getExtractGroupsAction(Gedcom gedcom) {
        return new ActionSaveViewAsGedcom(gedcom, (Filter)this.groupsFilter);
    }

    public AbstractAncestrisAction getMarkAction(Gedcom gedcom) {
        return new ActionMark(gedcom, this.filters);
    }

    public void setAssoSeparation(boolean set) {
        this.separateAssos = set;
    }

    public void setDecujusForced(boolean set) {
        this.decujusForced = set;
    }

    public void setHideNote(boolean set) {
        this.hideNote = set;
    }

    public void stop() {
        if (this.filters != null) {
            for (FamilyGroupFilter filter : this.filters) {
                filter.setTree(null);
                AncestrisPlugin.unregister((Object)filter);
            }
        }
        this.filters = null;
    }

    private int getGregorianYear(PropertyDate pDate) {
        try {
            PointInTime pit = pDate.getStart().convertIncomplete((Calendar)PointInTime.GREGORIAN);
            return pit.getYear();
        }
        catch (GedcomException | NullPointerException t) {
            return Integer.MAX_VALUE;
        }
    }

    private int displaySubgroupLine(String subgroupName, Map<String, SubgroupInfo> subgroups, Document doc, int cntr) {
        Set<Indi> subgroup = subgroups.get(subgroupName).getIndis();
        doc.nextTableRow();
        doc.nextTableCell("text-align=left, number-columns-spanned=5");
        doc.addText(NbBundle.getMessage(this.getClass(), (String)("FamilyGroupsTopComponent." + subgroupName)));
        doc.nextTableCell("text-align=center");
        doc.addText("" + subgroup.size());
        return cntr + subgroup.size();
    }

    public static class FamilyGroupFilter
    implements Filter {
        private Tree tree;
        private static final int SIZEMAX = 120;

        private FamilyGroupFilter(Tree tree) {
            this.tree = tree;
        }

        public void setTree(Tree tree) {
            this.tree = tree;
        }

        public void setList(List<Indi> list) {
            this.tree.connectedEntities.clear();
            this.tree.connectedEntities.addAll(list);
        }

        public List<SubgroupInfo> getSubgroups() {
            ArrayList<SubgroupInfo> ret = new ArrayList<SubgroupInfo>(this.tree.getSubGroups().values());
            Collections.sort(ret);
            return ret;
        }

        public List<Indi> getGeneration(int i) {
            return ((GenInfo)this.tree.getGenerations().get(i)).listIndiInfos.stream().map(indiInfo -> ((IndiInfo)indiInfo).indi).collect(Collectors.toList());
        }

        public Object[][] getGenerationsData() {
            LinkedList gens = this.tree.getGenerations();
            Object[][] ret = new Object[gens.size()][6];
            int i = 0;
            for (GenInfo genInfo : gens) {
                int j = 0;
                ret[i][j] = genInfo.genNumber;
                ret[i][++j] = genInfo.nbIndi;
                ret[i][++j] = genInfo.nbTop;
                ret[i][++j] = genInfo.nbBottom;
                ret[i][++j] = genInfo.minBirthYear;
                ret[i][++j] = genInfo.maxBirthYear;
                ++i;
            }
            return ret;
        }

        public String[] getGenerationsTitles() {
            return new String[]{NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.generations"), NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.nbindividuals"), NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.nbtopindividuals"), NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.nbbottomindividuals"), NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.birthfrom"), NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.birthto")};
        }

        public void reset() {
            this.tree.connectedEntities.clear();
        }

        public String getTagValue(SubgroupInfo subgroupInfo) {
            String subgroupName = NbBundle.getMessage(this.getClass(), (String)("FamilyGroupsTopComponent." + subgroupInfo.key));
            return NbBundle.getMessage(FamilyGroupFilter.class, (String)"TTL_Filter_Tag_Value", (Object)this.tree.getNb(), (Object)subgroupName, (Object)subgroupInfo.getNbIndis(), (Object)this.tree.size(), (Object[])new Object[0]);
        }

        public String getFilterName() {
            String text;
            String extract = " ";
            int extractNb = this.tree.getExtractNb();
            if (extractNb < this.tree.size()) {
                extract = " " + NbBundle.getMessage(FamilyGroupFilter.class, (String)"TTL_Filter_Extract", (Object)this.tree.size()) + " ";
            }
            if ((text = NbBundle.getMessage(FamilyGroupFilter.class, (String)"TTL_Filter", (Object)extractNb, (Object)this.tree.getNb(), (Object)this.tree.getOldestIndividual(), (Object)extract, (Object[])new Object[0])).length() > 120) {
                int index = text.substring(0, 120).lastIndexOf(" ");
                text = text.substring(0, index) + "...";
            }
            return text;
        }

        public String getSelectionName() {
            return "Group_" + this.tree.getNb() + "_" + this.tree.getOldestIndividual().getLastName() + "_" + this.tree.getOldestIndividual().getFirstName();
        }

        public String toString() {
            return this.getFilterName();
        }

        public boolean veto(Entity entity) {
            if (entity == entity.getGedcom().getSubmitter()) {
                return false;
            }
            this.calculateIndis();
            return !this.tree.connectedEntities.contains(entity);
        }

        public boolean veto(Property property) {
            PropertyXRef xref;
            return property instanceof PropertyXRef && (xref = (PropertyXRef)property).isValid() && !this.tree.connectedEntities.contains(xref.getTargetEntity());
        }

        public boolean canApplyTo(Gedcom gedcom) {
            if (this.tree == null || this.tree.oldestIndividual == null) {
                return false;
            }
            return this.tree.oldestIndividual.getGedcom().equals(gedcom);
        }

        private void calculateIndis() {
            if (this.tree.connectedEntities.isEmpty()) {
                List<SubgroupInfo> subgroups = this.getSubgroups();
                for (SubgroupInfo subgroup : subgroups) {
                    if (!subgroup.isSelected()) continue;
                    for (Indi indi : subgroup.getIndis()) {
                        this.tree.connectedEntities.addAll(Utilities.getDependingEntitiesRecursively((Entity)indi, subgroup.getIndis()));
                    }
                }
            }
        }

        public int getIndividualsCount() {
            if (this.tree.connectedEntities.isEmpty()) {
                this.calculateIndis();
            }
            int sum = 0;
            for (Entity ent : this.tree.connectedEntities) {
                if (!(ent instanceof Indi)) continue;
                ++sum;
            }
            return sum;
        }
    }

    public class SubgroupInfo
    implements Comparable {
        public String key = "";
        private Set<Indi> indis = null;
        private boolean selected = true;

        private SubgroupInfo(String key, Set<Indi> indis) {
            this.key = key;
            this.indis = indis;
        }

        public void setSelected(boolean set) {
            this.selected = set;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public int getNbIndis() {
            return this.indis == null ? 0 : this.indis.size();
        }

        public Set<Indi> getIndis() {
            return this.indis;
        }

        public Integer getSortOrder() {
            return SubgroupOrder.valueOf(this.key).ordinal();
        }

        public String toString() {
            return "[" + this.getNbIndis() + "] - " + NbBundle.getMessage(this.getClass(), (String)("FamilyGroupsTopComponent." + this.key), (Object)"");
        }

        public int compareTo(Object o) {
            return this.getSortOrder().compareTo(((SubgroupInfo)o).getSortOrder());
        }
    }

    private class GenInfo {
        private int key = Integer.MAX_VALUE;
        private int genNumber = 0;
        private int nbIndi = 0;
        private int nbTop = 0;
        private int nbBottom = 0;
        private int minBirthYear = Integer.MAX_VALUE;
        private int maxBirthYear = Integer.MIN_VALUE;
        private List<IndiInfo> listIndiInfos = null;

        private GenInfo(int generation) {
            this.key = generation;
            this.listIndiInfos = new ArrayList<IndiInfo>();
        }

        private void updateWith(IndiInfo indiInfo) {
            ++this.nbIndi;
            this.nbTop += indiInfo.isTop ? 1 : 0;
            this.nbBottom += indiInfo.isBottom ? 1 : 0;
            this.listIndiInfos.add(indiInfo);
            if (indiInfo.birthYear != Integer.MAX_VALUE) {
                if (indiInfo.birthYear < this.minBirthYear) {
                    this.minBirthYear = indiInfo.birthYear;
                }
                if (indiInfo.birthYear > this.maxBirthYear) {
                    this.maxBirthYear = indiInfo.birthYear;
                }
            }
        }

        private void setGenNumber(int set) {
            this.genNumber = set;
        }
    }

    private class IndiInfo {
        private Indi indi = null;
        private boolean isTop = false;
        private boolean isBottom = false;
        private boolean isGenSet = false;
        private int generation = 0;
        private int birthYear = Integer.MAX_VALUE;
        private int deathYear = Integer.MIN_VALUE;
        private BigInteger sosa = BigInteger.ZERO;
        private int nbAncestors = 0;

        private IndiInfo(Indi indi) {
            int gregYear;
            this.indi = indi;
            if (indi.getParents().isEmpty()) {
                this.isTop = true;
            }
            if (indi.getChildren().length == 0) {
                this.isBottom = true;
            }
            if ((gregYear = FamilyGroupsPlugin.this.getGregorianYear(indi.getBirthDate())) != Integer.MAX_VALUE) {
                this.birthYear = gregYear;
                if (this.deathYear < this.birthYear) {
                    this.deathYear = this.birthYear;
                }
            }
            if ((gregYear = FamilyGroupsPlugin.this.getGregorianYear(indi.getDeathDate())) != Integer.MAX_VALUE) {
                this.deathYear = gregYear;
                if (this.birthYear > this.deathYear) {
                    this.birthYear = this.deathYear;
                }
            }
        }
    }

    protected class Tree
    extends HashSet<Indi>
    implements Comparable<Tree> {
        private boolean isAssoType = false;
        private int number;
        private int nbTop = 0;
        private int nbBottom = 0;
        private Indi oldestIndividual = null;
        private Indi youngestIndividual = null;
        private Indi decujusIndividual = null;
        private int decujusNbAncestors = 0;
        private List<Indi> decujusLonguestLine = null;
        private Indi decujusFather = null;
        private Indi decujusMother = null;
        private int minBirthYear = Integer.MAX_VALUE;
        private int maxBirthYear = Integer.MIN_VALUE;
        private List<String> places = null;
        private Map<Indi, IndiInfo> infos = new HashMap<Indi, IndiInfo>();
        private Map<Integer, GenInfo> generations = new HashMap<Integer, GenInfo>();
        private int oldestGeneration = 0;
        private int youngestGeneration = 0;
        private Map<String, SubgroupInfo> subGroups = new HashMap<String, SubgroupInfo>();
        private List<List<Indi>> longuestLines = new ArrayList<List<Indi>>();
        public Set<Entity> connectedEntities = new HashSet<Entity>();

        protected Tree() {
        }

        @Override
        public boolean add(Indi indi) {
            IndiInfo indiInfo = this.infos.get(indi);
            if (indiInfo == null) {
                indiInfo = new IndiInfo(indi);
                this.infos.put(indi, indiInfo);
            }
            if (this.isOldest(indi)) {
                this.oldestIndividual = indi;
            }
            if (this.isYoungest(indi)) {
                this.youngestIndividual = indi;
            }
            if (indiInfo.isTop) {
                ++this.nbTop;
            }
            if (indiInfo.isBottom) {
                ++this.nbBottom;
            }
            if (indiInfo.birthYear != Integer.MAX_VALUE) {
                if (indiInfo.birthYear < this.minBirthYear) {
                    this.minBirthYear = indiInfo.birthYear;
                }
                if (indiInfo.birthYear > this.maxBirthYear) {
                    this.maxBirthYear = indiInfo.birthYear;
                }
            }
            return super.add(indi);
        }

        @Override
        public int compareTo(Tree that) {
            return that.size() - this.size();
        }

        public void setNb(int i) {
            this.number = i;
        }

        public int getNb() {
            return this.number;
        }

        public void setAsso(boolean set) {
            this.isAssoType = set;
        }

        public boolean isAsso() {
            return this.isAssoType;
        }

        public List<String> getPlaces() {
            return this.places;
        }

        public Indi getOldestIndividual() {
            return this.oldestIndividual;
        }

        public Indi getYoungestIndividual() {
            return this.youngestIndividual;
        }

        public Indi getDecujusIndividual() {
            return this.decujusIndividual;
        }

        private boolean isOldest(Indi indi) {
            long jd;
            try {
                jd = this.oldestIndividual.getBirthDate().getStart().getJulianDay();
            }
            catch (GedcomException | NullPointerException t) {
                return true;
            }
            try {
                return (long)indi.getBirthDate().getStart().getJulianDay() < jd;
            }
            catch (GedcomException | NullPointerException t) {
                return false;
            }
        }

        private boolean isYoungest(Indi indi) {
            long jd;
            try {
                jd = this.youngestIndividual.getBirthDate().getStart().getJulianDay();
            }
            catch (GedcomException | NullPointerException t) {
                return true;
            }
            try {
                return (long)indi.getBirthDate().getStart().getJulianDay() > jd;
            }
            catch (GedcomException | NullPointerException t) {
                return false;
            }
        }

        private int getGeneration(Indi indi) {
            IndiInfo indiInfo = this.infos.get(indi);
            return indiInfo.generation;
        }

        private int getNbGenerations() {
            return this.oldestGeneration - this.youngestGeneration + 1;
        }

        private LinkedList<GenInfo> getGenerations() {
            LinkedList<GenInfo> ret = new LinkedList<GenInfo>();
            int gen = this.getNbGenerations();
            this.generations.keySet().stream().sorted(Comparator.reverseOrder()).forEach(this.withCounter((i, x) -> {
                this.generations.get(x).setGenNumber(gen - i - 1);
                ret.add(this.generations.get(x));
            }));
            return ret;
        }

        public <T> Consumer<T> withCounter(BiConsumer<Integer, T> consumer) {
            AtomicInteger cntr = new AtomicInteger(0);
            return item -> consumer.accept(cntr.getAndIncrement(), item);
        }

        private List<List<Indi>> getLonguestLines(boolean includeDecujus) {
            if (includeDecujus && !this.longuestLines.contains(this.decujusLonguestLine)) {
                this.longuestLines.add(this.decujusLonguestLine);
            }
            Collections.sort(this.longuestLines, (a1, a2) -> a2.size() - a1.size());
            int max = this.longuestLines.get(0).size();
            return this.longuestLines.stream().filter(l -> l.size() == max || includeDecujus && l.equals(this.decujusLonguestLine)).sorted(new ListComparator()).collect(Collectors.toList());
        }

        private Map<String, SubgroupInfo> getSubGroups() {
            return this.subGroups;
        }

        private int getExtractNb() {
            int t = 0;
            t = this.getSubGroups().values().stream().filter(subgroup -> subgroup.isSelected()).map(subgroup -> subgroup.getNbIndis()).reduce(t, Integer::sum);
            return t;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "empty";
            }
            return this.oldestIndividual.getId() + " " + this.getTitle();
        }

        public String getTitle() {
            if (!this.isAssoType) {
                return NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.treeTitle", (Object[])new Object[]{this.oldestIndividual.getName(), this.oldestIndividual.getBirthAsString().length() > 0 ? this.oldestIndividual.getBirthAsString() : "-", this.oldestIndividual.getDeathAsString().length() > 0 ? this.oldestIndividual.getDeathAsString() : "-", this.youngestIndividual.getName(), this.youngestIndividual.getBirthAsString().length() > 0 ? this.youngestIndividual.getBirthAsString() : "-", this.youngestIndividual.getDeathAsString().length() > 0 ? this.youngestIndividual.getDeathAsString() : "-"});
            }
            return NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.assoTreeTitle");
        }

        private List<Indi> sorted(boolean descendant) {
            final int sense = descendant ? 1 : -1;
            LinkedList<Indi> list = new LinkedList<Indi>();
            this.stream().sorted(new Comparator(){

                public int compare(Object o1, Object o2) {
                    PropertyDate d1 = ((Indi)o1).getBirthDate();
                    PropertyDate d2 = ((Indi)o2).getBirthDate();
                    if (d1 != null && !d1.isValid()) {
                        d1 = null;
                    }
                    if (d2 != null && !d2.isValid()) {
                        d2 = null;
                    }
                    if (d1 == null && d2 == null) {
                        return 0;
                    }
                    if (d1 == null && d2 != null) {
                        return sense;
                    }
                    if (d1 != null && d2 == null) {
                        return -sense;
                    }
                    return d1.compareTo((Property)d2);
                }
            }).forEachOrdered(x -> list.add((Indi)x));
            return list;
        }

        private StringBuilder getListString(List<Indi> list, String separator) {
            StringBuilder sb = new StringBuilder("");
            ListIterator<Indi> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                Indi indi = listIterator.previous();
                PropertyDate pDate = indi.getBirthDate();
                String date = "0000";
                try {
                    PointInTime pit = pDate.getStart();
                    date = "" + pit.getYear() + pit.getMonth() + pit.getDay();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                date = date + indi.getLastName() + indi.getFirstName();
                sb.append(date).append(separator);
            }
            return sb;
        }

        private void calculateElements() {
            FamilyGroupsPlugin.this.state = "(" + NbBundle.getMessage(this.getClass(), (String)"TaskState_places") + ")";
            log.log(logLevel, "Time=" + TimingUtility.getInstance().getTime() + " Places...");
            this.places = this.calcPlaces();
            FamilyGroupsPlugin.this.counter = FamilyGroupsPlugin.this.counter + this.size() * 10 / 100;
            FamilyGroupsPlugin.this.state = "(" + NbBundle.getMessage(this.getClass(), (String)"TaskState_lines") + ")";
            log.log(logLevel, "Time=" + TimingUtility.getInstance().getTime() + " Longuest lines...");
            this.calcLonguestLine();
            FamilyGroupsPlugin.this.counter = FamilyGroupsPlugin.this.counter + this.size() * 40 / 100;
            FamilyGroupsPlugin.this.state = "(" + NbBundle.getMessage(this.getClass(), (String)"TaskState_decujus") + ")";
            log.log(logLevel, "Time=" + TimingUtility.getInstance().getTime() + " DeCujus...");
            this.calcDeCujus();
            FamilyGroupsPlugin.this.counter = FamilyGroupsPlugin.this.counter + this.size() * 20 / 100;
            FamilyGroupsPlugin.this.state = "(" + NbBundle.getMessage(this.getClass(), (String)"TaskState_subgroups") + ")";
            log.log(logLevel, "Time=" + TimingUtility.getInstance().getTime() + " Subgroups...");
            this.subGroups = this.calcSubGroups(this.decujusIndividual, this.decujusFather, this.decujusMother);
            FamilyGroupsPlugin.this.counter = FamilyGroupsPlugin.this.counter + this.size() * 10 / 100;
            FamilyGroupsPlugin.this.state = "(" + NbBundle.getMessage(this.getClass(), (String)"TaskState_generations") + ")";
            log.log(logLevel, "Time=" + TimingUtility.getInstance().getTime() + " Generations...");
            this.calcGenerations();
            FamilyGroupsPlugin.this.counter = FamilyGroupsPlugin.this.counter + this.size() * 19 / 100;
            FamilyGroupsPlugin.this.state = "(" + NbBundle.getMessage(this.getClass(), (String)"TaskState_youngold") + ")";
            log.log(logLevel, "Time=" + TimingUtility.getInstance().getTime() + " Youngest and oldest...");
            this.youngestIndividual = this.calcYoungestIndividual();
            this.oldestIndividual = this.calcOldestIndividual();
            FamilyGroupsPlugin.this.counter = FamilyGroupsPlugin.this.counter + this.size() * 1 / 100;
            log.log(logLevel, "Time=" + TimingUtility.getInstance().getTime() + " Done.");
        }

        public List<String> calcPlaces() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Indi indi : this) {
                List placeProps = indi.getAllProperties("PLAC");
                for (Property placeProp : placeProps) {
                    if (!(placeProp instanceof PropertyPlace)) continue;
                    PropertyPlace pplace = (PropertyPlace)placeProp;
                    String city = pplace.getValueStartingWithCity().replaceAll(",", " ").replaceAll("\\s+", " ").trim();
                    Integer n = (Integer)map.get(city);
                    if (n == null) {
                        n = 1;
                    }
                    Integer n2 = n;
                    Integer n3 = n = Integer.valueOf(n + 1);
                    map.put(city, n);
                }
            }
            LinkedHashMap reverseSortedMap = new LinkedHashMap();
            map.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEachOrdered(x -> {
                Integer cfr_ignored_0 = (Integer)reverseSortedMap.put(x.getKey(), x.getValue());
            });
            ArrayList<String> ret = new ArrayList<String>();
            reverseSortedMap.entrySet().stream().forEach(x -> ret.add((String)x.getKey() + " (" + x.getValue() + ")"));
            return ret;
        }

        private void calcLonguestLine() {
            this.longuestLines.clear();
            ArrayList lists = new ArrayList();
            HashMap<BigInteger, IndiInfo> map = new HashMap<BigInteger, IndiInfo>();
            BigInteger maxsosa = BigInteger.ONE;
            int maxancestors = 0;
            for (Indi indi : this) {
                IndiInfo indiInfo = this.infos.get(indi);
                if (indiInfo == null || !indiInfo.isBottom) continue;
                map.clear();
                BigInteger bi = this.numberSosa(indiInfo, map);
                indiInfo.nbAncestors = map.size();
                if (bi.bitLength() >= maxsosa.bitLength()) {
                    maxsosa = bi;
                    this.longuestLines.add(this.getLineFrom(maxsosa, map));
                }
                if (map.size() <= maxancestors) continue;
                maxancestors = map.size();
                this.decujusIndividual = indi;
                this.decujusLonguestLine = this.getLineFrom(bi, map);
            }
        }

        private BigInteger numberSosa(IndiInfo indiInfo, Map<BigInteger, IndiInfo> map) {
            BigInteger sosa = BigInteger.ONE;
            BigInteger maxsosa = BigInteger.ONE;
            BigInteger tmpsosa = BigInteger.ONE;
            Stack<Indi> todos = new Stack<Indi>();
            HashSet<Indi> seen = new HashSet<Indi>();
            Indi todo = indiInfo.indi;
            indiInfo.sosa = sosa;
            todos.push(todo);
            while (!todos.isEmpty()) {
                todo = (Indi)todos.pop();
                if (seen.contains(todo)) continue;
                seen.add(todo);
                sosa = this.infos.get(todo).sosa;
                map.put(sosa, this.infos.get(todo));
                if (sosa.compareTo(maxsosa) > 0) {
                    maxsosa = sosa;
                }
                for (Fam famc : todo.getFamiliesWhereChild()) {
                    Indi father = famc.getHusband();
                    tmpsosa = sosa.shiftLeft(1);
                    if (father != null) {
                        this.infos.get(father).sosa = tmpsosa;
                        todos.push(father);
                    }
                    Indi mother = famc.getWife();
                    tmpsosa = sosa.shiftLeft(1).add(BigInteger.ONE);
                    if (mother == null) continue;
                    this.infos.get(mother).sosa = tmpsosa;
                    todos.push(mother);
                }
            }
            return maxsosa;
        }

        private List<Indi> getLineFrom(BigInteger bi, Map<BigInteger, IndiInfo> map) {
            ArrayList<Indi> list = new ArrayList<Indi>();
            BigInteger tmpBi = bi;
            while (tmpBi.compareTo(BigInteger.ONE) >= 0) {
                list.add(map.get(tmpBi).indi);
                tmpBi = tmpBi.shiftRight(1);
            }
            Collections.reverse(list);
            return list;
        }

        private void calcDeCujus() {
            Indi markedDecujus = FamilyGroupsPlugin.this.gedcom.getDeCujusIndi();
            if (markedDecujus != null && this.contains(markedDecujus) && FamilyGroupsPlugin.this.decujusForced) {
                this.decujusIndividual = markedDecujus;
            } else if (this.decujusIndividual == null) {
                this.decujusIndividual = this.getLonguestLines(false).get(0).get(0);
            }
            this.decujusFather = this.decujusIndividual.getBiologicalFather();
            this.decujusMother = this.decujusIndividual.getBiologicalMother();
            this.decujusNbAncestors = this.infos.get(this.decujusIndividual).nbAncestors - 1;
        }

        private Map<String, SubgroupInfo> calcSubGroups(Indi decujus, Indi father, Indi mother) {
            HashMap<String, SubgroupInfo> map = new HashMap<String, SubgroupInfo>();
            if (father == null || mother == null) {
                map.put("subgroupA", new SubgroupInfo("subgroupA", this));
                return map;
            }
            map.put("subgroupDC", new SubgroupInfo("subgroupDC", this.getDeCujusSiblings(decujus, father, mother)));
            map.put("subgroupFA", new SubgroupInfo("subgroupFA", this.getExclusiveAncestors(father, mother)));
            map.put("subgroupMA", new SubgroupInfo("subgroupMA", this.getExclusiveAncestors(mother, father)));
            map.put("subgroupCA", new SubgroupInfo("subgroupCA", this.getCommonAncestors(father, mother)));
            HashSet<Indi> exclude = new HashSet<Indi>();
            exclude.addAll(((SubgroupInfo)map.get("subgroupFA")).getIndis());
            exclude.addAll(((SubgroupInfo)map.get("subgroupMA")).getIndis());
            exclude.addAll(((SubgroupInfo)map.get("subgroupCA")).getIndis());
            Set<Object> descendantsOfExclude = new HashSet<Indi>();
            map.put("subgroupDDC", new SubgroupInfo("subgroupDDC", this.getExclusiveDescendants(((SubgroupInfo)map.get("subgroupDC")).getIndis(), exclude, descendantsOfExclude)));
            exclude.clear();
            exclude.addAll(((SubgroupInfo)map.get("subgroupDC")).getIndis());
            exclude.addAll(((SubgroupInfo)map.get("subgroupMA")).getIndis());
            exclude.addAll(((SubgroupInfo)map.get("subgroupCA")).getIndis());
            descendantsOfExclude = new HashSet();
            descendantsOfExclude = this.getExclusiveDescendants(exclude, descendantsOfExclude, descendantsOfExclude);
            map.put("subgroupDFA", new SubgroupInfo("subgroupDFA", this.getExclusiveDescendants(((SubgroupInfo)map.get("subgroupFA")).getIndis(), exclude, descendantsOfExclude)));
            exclude.clear();
            exclude.addAll(((SubgroupInfo)map.get("subgroupDC")).getIndis());
            exclude.addAll(((SubgroupInfo)map.get("subgroupFA")).getIndis());
            exclude.addAll(((SubgroupInfo)map.get("subgroupCA")).getIndis());
            descendantsOfExclude.clear();
            descendantsOfExclude = this.getExclusiveDescendants(exclude, descendantsOfExclude, descendantsOfExclude);
            map.put("subgroupDMA", new SubgroupInfo("subgroupDMA", this.getExclusiveDescendants(((SubgroupInfo)map.get("subgroupMA")).getIndis(), exclude, descendantsOfExclude)));
            exclude.clear();
            for (Object key : map.keySet()) {
                exclude.addAll(((SubgroupInfo)map.get(key)).getIndis());
            }
            descendantsOfExclude.clear();
            HashSet<Indi> input = new HashSet<Indi>();
            input.addAll(((SubgroupInfo)map.get("subgroupFA")).getIndis());
            input.addAll(((SubgroupInfo)map.get("subgroupCA")).getIndis());
            input.addAll(((SubgroupInfo)map.get("subgroupMA")).getIndis());
            map.put("subgroupDCA", new SubgroupInfo("subgroupDCA", this.getExclusiveDescendants(input, exclude, descendantsOfExclude)));
            exclude.clear();
            for (String key : map.keySet()) {
                exclude.addAll(((SubgroupInfo)map.get(key)).getIndis());
            }
            Set<Indi> spousesDDC = this.getSpouses(((SubgroupInfo)map.get("subgroupDC")).getIndis(), exclude);
            map.put("subgroupSDDC", new SubgroupInfo("subgroupSDDC", spousesDDC));
            exclude.addAll(((SubgroupInfo)map.get("subgroupSDDC")).getIndis());
            Set<Indi> spousesDFA = this.getSpouses(((SubgroupInfo)map.get("subgroupFA")).getIndis(), exclude);
            map.put("subgroupSDFA", new SubgroupInfo("subgroupSDFA", spousesDFA));
            exclude.addAll(((SubgroupInfo)map.get("subgroupSDFA")).getIndis());
            Set<Indi> spousesDMA = this.getSpouses(((SubgroupInfo)map.get("subgroupMA")).getIndis(), exclude);
            map.put("subgroupSDMA", new SubgroupInfo("subgroupSDMA", spousesDMA));
            exclude.addAll(((SubgroupInfo)map.get("subgroupSDMA")).getIndis());
            Set<Indi> spousesDCA = this.getSpouses(((SubgroupInfo)map.get("subgroupCA")).getIndis(), exclude);
            map.put("subgroupSDCA", new SubgroupInfo("subgroupSDCA", spousesDCA));
            exclude.addAll(((SubgroupInfo)map.get("subgroupSDCA")).getIndis());
            HashSet<Indi> relativesDDC = new HashSet<Indi>();
            for (Indi indi : spousesDDC) {
                this.getRelatives(indi, relativesDDC, exclude);
            }
            map.put("subgroupTDDC", new SubgroupInfo("subgroupTDDC", relativesDDC));
            HashSet<Indi> relativesDFA = new HashSet<Indi>();
            for (Indi indi : spousesDFA) {
                this.getRelatives(indi, relativesDFA, exclude);
            }
            map.put("subgroupTDFA", new SubgroupInfo("subgroupTDFA", relativesDFA));
            HashSet<Indi> hashSet = new HashSet<Indi>();
            for (Indi indi : spousesDMA) {
                this.getRelatives(indi, hashSet, exclude);
            }
            map.put("subgroupTDMA", new SubgroupInfo("subgroupTDMA", hashSet));
            HashSet<Indi> hashSet2 = new HashSet<Indi>();
            for (Indi spouse : spousesDCA) {
                this.getRelatives(spouse, hashSet2, exclude);
            }
            map.put("subgroupTDCA", new SubgroupInfo("subgroupTDCA", hashSet2));
            HashSet<Indi> hashSet3 = new HashSet<Indi>();
            for (Indi indi : this) {
                if (exclude.contains(indi)) continue;
                hashSet3.add(indi);
            }
            map.put("subgroupZ", new SubgroupInfo("subgroupZ", hashSet3));
            return map;
        }

        private Set<Indi> getDeCujusSiblings(Indi indi, Indi father, Indi mother) {
            HashSet<Indi> ret = new HashSet<Indi>();
            for (Fam famc : indi.getFamiliesWhereChild()) {
                if (father == null || father != famc.getHusband() || mother == null || mother != famc.getWife()) continue;
                ret.addAll(Arrays.asList(famc.getChildren()));
                break;
            }
            return ret;
        }

        private Set<Indi> getExclusiveAncestors(Indi indi, Indi exclude) {
            HashSet<Indi> tree = new HashSet<Indi>();
            Stack<Indi> todos = new Stack<Indi>();
            todos.add(indi);
            HashSet<Indi> seen = new HashSet<Indi>();
            while (!todos.isEmpty()) {
                Indi todo = (Indi)todos.pop();
                if (seen.contains(todo)) continue;
                seen.add(todo);
                for (Fam famc : todo.getFamiliesWhereChild()) {
                    Indi father;
                    Indi mother = famc.getWife();
                    if (mother != null && !tree.contains(mother) && !mother.isAncestorOf(exclude)) {
                        todos.push(mother);
                    }
                    if ((father = famc.getHusband()) == null || tree.contains(father) || father.isAncestorOf(exclude)) continue;
                    todos.push(father);
                }
                tree.add(todo);
            }
            return tree;
        }

        private Set<Indi> getCommonAncestors(Indi indi1, Indi indi2) {
            HashSet<Indi> tree = new HashSet<Indi>();
            Stack<Indi> todos = new Stack<Indi>();
            todos.add(indi1);
            HashSet<Indi> seen = new HashSet<Indi>();
            while (!todos.isEmpty()) {
                Indi todo = (Indi)todos.pop();
                if (seen.contains(todo)) continue;
                seen.add(todo);
                for (Fam famc : todo.getFamiliesWhereChild()) {
                    Indi father;
                    Indi mother = famc.getWife();
                    if (mother != null && !tree.contains(mother)) {
                        todos.push(mother);
                    }
                    if ((father = famc.getHusband()) == null || tree.contains(father)) continue;
                    todos.push(father);
                }
                if (!todo.isAncestorOf(indi2)) continue;
                tree.add(todo);
            }
            return tree;
        }

        private Set<Indi> getExclusiveDescendants(Set<Indi> input, Set<Indi> exclude, Set<Indi> descendantsOfExclude) {
            HashSet<Indi> tree = new HashSet<Indi>();
            Stack<Indi> todos = new Stack<Indi>();
            todos.addAll(input);
            HashSet<Indi> seen = new HashSet<Indi>();
            while (!todos.isEmpty()) {
                Indi todo = (Indi)todos.pop();
                if (seen.contains(todo)) continue;
                seen.add(todo);
                for (Fam fam : todo.getFamiliesWhereSpouse()) {
                    for (Indi child : fam.getChildren()) {
                        if (tree.contains(child) || input.contains(child)) continue;
                        if (!todos.contains(child)) {
                            todos.push(child);
                        }
                        if (exclude.contains(child) || descendantsOfExclude.contains(child)) continue;
                        tree.add(child);
                    }
                }
            }
            return tree;
        }

        private Set<Indi> getSpouses(Set<Indi> input, Set<Indi> exclude) {
            HashSet<Indi> tree = new HashSet<Indi>();
            Stack<Indi> todos = new Stack<Indi>();
            todos.addAll(input);
            HashSet<Indi> seen = new HashSet<Indi>();
            while (!todos.isEmpty()) {
                Indi todo = (Indi)todos.pop();
                if (seen.contains(todo)) continue;
                seen.add(todo);
                for (Fam fam : todo.getFamiliesWhereSpouse()) {
                    Indi spouse = fam.getOtherSpouse(todo);
                    if (!(spouse == null || seen.contains(spouse) || exclude.contains(spouse) || todos.contains(spouse))) {
                        tree.add(spouse);
                    }
                    for (Indi child : fam.getChildren()) {
                        if (input.contains(child) || seen.contains(child) || todos.contains(child)) continue;
                        todos.push(child);
                    }
                }
            }
            return tree;
        }

        private void getRelatives(Indi indi, Set<Indi> relatives, Set<Indi> exclude) {
            Stack<Indi> todos = new Stack<Indi>();
            todos.push(indi);
            while (!todos.isEmpty()) {
                Indi todo = (Indi)todos.pop();
                for (Fam famc : todo.getFamiliesWhereChild()) {
                    Indi father;
                    if (famc == null) continue;
                    Indi mother = famc.getWife();
                    if (mother != null && !exclude.contains(mother)) {
                        todos.push(mother);
                    }
                    if ((father = famc.getHusband()) == null || exclude.contains(father)) continue;
                    todos.push(father);
                }
                for (Fam fam : todo.getFamiliesWhereSpouse()) {
                    Indi spouse = fam.getOtherSpouse(todo);
                    if (spouse != null && !exclude.contains(spouse)) {
                        todos.push(spouse);
                    }
                    for (Indi child : fam.getChildren()) {
                        if (exclude.contains(child)) continue;
                        todos.push(child);
                    }
                }
                relatives.add(todo);
                exclude.add(todo);
            }
            relatives.remove(indi);
        }

        private void calcGenerations() {
            if (this.isAssoType) {
                return;
            }
            List<List<Indi>> lists = this.getLonguestLines(false);
            lists.forEach(line -> {
                int gen = 1;
                for (Indi indi : line) {
                    IndiInfo indiInfo = this.infos.get(indi);
                    this.setGeneration(indiInfo, gen);
                    ++gen;
                }
            });
            ArrayList<Indi> visited = new ArrayList<Indi>();
            lists.forEach(line -> line.forEach(indi -> this.setGenerationsOf((Indi)indi, this.infos.get(indi).generation, visited, true, false)));
            visited.clear();
            lists.forEach(line -> line.forEach(indi -> this.setGenerationsOf((Indi)indi, this.infos.get(indi).generation, visited, false, true)));
            visited.clear();
            lists.forEach(line -> line.forEach(indi -> this.setGenerationsOf((Indi)indi, this.infos.get(indi).generation, visited, true, true)));
            boolean changed = true;
            while (changed) {
                changed = false;
                Stack todos = new Stack();
                this.stream().filter(indi -> !this.infos.get(indi).isGenSet).forEachOrdered(indi -> todos.add(indi));
                while (!todos.isEmpty()) {
                    Indi indi2 = (Indi)todos.pop();
                    for (Fam fam : indi2.getFamiliesWhereSpouse()) {
                        IndiInfo spouseInfo;
                        Indi spouse = fam.getOtherSpouse(indi2);
                        if (spouse == null || (spouseInfo = this.infos.get(spouse)) == null || !spouseInfo.isGenSet) continue;
                        changed |= this.setGenerationsOf(indi2, spouseInfo.generation, visited, true, true);
                    }
                }
            }
            for (Indi indi2 : this) {
                GenInfo genInfo;
                IndiInfo indiInfo = this.infos.get(indi2);
                if (indiInfo.generation < this.youngestGeneration) {
                    this.youngestGeneration = indiInfo.generation;
                }
                if (indiInfo.generation > this.oldestGeneration) {
                    this.oldestGeneration = indiInfo.generation;
                }
                if ((genInfo = this.generations.get(indiInfo.generation)) == null) {
                    genInfo = new GenInfo(indiInfo.generation);
                    this.generations.put(indiInfo.generation, genInfo);
                }
                genInfo.updateWith(indiInfo);
            }
            for (GenInfo genInfo : this.generations.values()) {
                if (genInfo.minBirthYear > 100000) {
                    genInfo.minBirthYear = 0;
                }
                if (genInfo.maxBirthYear >= -100000) continue;
                genInfo.maxBirthYear = 0;
            }
            if (this.minBirthYear > 100000) {
                this.minBirthYear = 0;
            }
            if (this.maxBirthYear < -100000) {
                this.maxBirthYear = 0;
            }
        }

        private boolean setGenerationsOf(Indi indi, int gen, List<Indi> visited, boolean upward, boolean downward) {
            Stack<IndiInfo> todos = new Stack<IndiInfo>();
            Indi seen = indi;
            IndiInfo indiInfo = this.infos.get(indi);
            boolean changed = this.setGeneration(indiInfo, gen);
            todos.push(indiInfo);
            while (!todos.isEmpty()) {
                indiInfo = (IndiInfo)todos.pop();
                gen = indiInfo.generation;
                seen = indiInfo.indi;
                if (visited.contains(seen)) continue;
                if (downward) {
                    for (Fam fam : seen.getFamiliesWhereSpouse()) {
                        for (Indi child : fam.getChildren()) {
                            if (visited.contains(child)) continue;
                            indiInfo = this.infos.get(child);
                            changed |= this.setGeneration(indiInfo, gen - 1);
                            todos.push(indiInfo);
                        }
                    }
                }
                if (upward) {
                    for (Fam famc : seen.getFamiliesWhereChild()) {
                        Indi mother;
                        Indi father = famc.getHusband();
                        if (father != null && !visited.contains(father)) {
                            indiInfo = this.infos.get(father);
                            changed |= this.setGeneration(indiInfo, gen + 1);
                            todos.push(indiInfo);
                        }
                        if ((mother = famc.getWife()) == null || visited.contains(mother)) continue;
                        indiInfo = this.infos.get(mother);
                        changed |= this.setGeneration(indiInfo, gen + 1);
                        todos.push(indiInfo);
                    }
                }
                visited.add(seen);
            }
            return changed;
        }

        private boolean setGeneration(IndiInfo indiInfo, int gen) {
            if (!indiInfo.isGenSet) {
                indiInfo.generation = gen;
                indiInfo.isGenSet = true;
                return true;
            }
            return false;
        }

        private Indi calcYoungestIndividual() {
            if (this.youngestIndividual != null) {
                Integer key = 0;
                try {
                    key = (Integer)this.generations.keySet().stream().sorted().findFirst().get();
                }
                catch (NoSuchElementException e) {
                    return this.youngestIndividual;
                }
                GenInfo genInfo = this.generations.get(key);
                if (genInfo == null) {
                    return this.youngestIndividual;
                }
                List youngsInfo = genInfo.listIndiInfos;
                for (IndiInfo indiInfo : youngsInfo) {
                    if (indiInfo.indi == this.youngestIndividual) {
                        return this.youngestIndividual;
                    }
                    if (!indiInfo.indi.isDescendantOf(this.youngestIndividual)) continue;
                    return indiInfo.indi;
                }
                return this.youngestIndividual;
            }
            return null;
        }

        private Indi calcOldestIndividual() {
            if (this.oldestIndividual != null) {
                Integer key = 0;
                try {
                    key = (Integer)this.generations.keySet().stream().sorted(Comparator.reverseOrder()).findFirst().get();
                }
                catch (NoSuchElementException e) {
                    return this.oldestIndividual;
                }
                GenInfo genInfo = this.generations.get(key);
                if (genInfo == null) {
                    return this.oldestIndividual;
                }
                for (IndiInfo indiInfo : genInfo.listIndiInfos) {
                    if (indiInfo.indi == this.oldestIndividual) {
                        return this.oldestIndividual;
                    }
                    if (!indiInfo.indi.isAncestorOf(this.oldestIndividual)) continue;
                    return indiInfo.indi;
                }
                return this.oldestIndividual;
            }
            return null;
        }

        private class ListComparator
        implements Comparator<List<Indi>> {
            private ListComparator() {
            }

            @Override
            public int compare(List<Indi> l1, List<Indi> l2) {
                StringBuilder sb1 = Tree.this.getListString(l1, "");
                StringBuilder sb2 = Tree.this.getListString(l2, "");
                return sb1.toString().compareTo(sb2.toString());
            }
        }
    }

    private static enum SubgroupOrder {
        subgroupA,
        subgroupDC,
        subgroupDDC,
        subgroupSDDC,
        subgroupTDDC,
        subgroupFA,
        subgroupDFA,
        subgroupSDFA,
        subgroupTDFA,
        subgroupMA,
        subgroupDMA,
        subgroupSDMA,
        subgroupTDMA,
        subgroupCA,
        subgroupDCA,
        subgroupSDCA,
        subgroupTDCA,
        subgroupZ;

    }
}

