/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.FamBox;
import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.Translator;
import ancestris.report.svgtree.output.FilterTreeElements;
import ancestris.report.svgtree.output.TreeElements;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class RotateTreeElements
extends FilterTreeElements {
    public static final int ROTATE_0 = 0;
    public static final int ROTATE_270 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_90 = 3;
    public int boxrotation = 0;
    public String[] boxrotations = new String[]{"none", "270", "180", "90"};
    private final Translator translator;

    public RotateTreeElements(Translator translator, Graphics2D graphics, TreeElements elements) {
        super(graphics, elements);
        this.translator = translator;
        for (int i = 0; i < this.boxrotations.length; ++i) {
            this.boxrotations[i] = translator.translate("rotation." + this.boxrotations[i]);
        }
    }

    public RotateTreeElements(Translator translator, TreeElements elements) {
        this(translator, null, elements);
    }

    @Override
    public void drawIndiBox(IndiBox indibox, int x, int y, int gen) {
        AffineTransform transform = this.graphics.getTransform();
        this.transform(x, y, indibox.width, indibox.height);
        this.transpose(indibox);
        this.elements.drawIndiBox(indibox, 0, 0, gen);
        this.transpose(indibox);
        this.graphics.setTransform(transform);
    }

    @Override
    public void drawFamBox(FamBox fambox, int x, int y, int gen) {
        AffineTransform transform = this.graphics.getTransform();
        this.transform(x, y, fambox.width, fambox.height);
        this.transpose(fambox);
        this.elements.drawFamBox(fambox, 0, 0, gen);
        this.transpose(fambox);
        this.graphics.setTransform(transform);
    }

    private void transform(int x, int y, int w, int h) {
        switch (this.boxrotation) {
            case 0: {
                this.graphics.translate(x, y);
                break;
            }
            case 3: {
                this.graphics.translate(x + w, y);
                this.graphics.rotate(1.5707963267948966);
                break;
            }
            case 2: {
                this.graphics.translate(x + w, y + h);
                this.graphics.rotate(Math.PI);
                break;
            }
            case 1: {
                this.graphics.translate(x, y + h);
                this.graphics.rotate(-1.5707963267948966);
            }
        }
    }

    private void transpose(IndiBox indibox) {
        if (this.boxrotation == 0 || this.boxrotation == 2) {
            return;
        }
        int tmp = indibox.width;
        indibox.width = indibox.height;
        indibox.height = tmp;
    }

    private void transpose(FamBox fambox) {
        if (this.boxrotation == 0 || this.boxrotation == 2) {
            return;
        }
        int tmp = fambox.width;
        fambox.width = fambox.height;
        fambox.height = tmp;
    }

    @Override
    public void getIndiBoxSize(IndiBox indibox) {
        this.elements.getIndiBoxSize(indibox);
        this.transpose(indibox);
    }

    @Override
    public void getFamBoxSize(FamBox fambox) {
        this.elements.getFamBoxSize(fambox);
        this.transpose(fambox);
    }
}

