/**
 * \par Copyright (C), 2012-2016, MakeBlock
 * \brief   Driver for BaseBoard.
 * \file    MeBaseBoard.h
 * @author  MakeBlock
 * @version V1.0.2
 * @date    2016/09/20
 * @brief   Driver for BaseBoard.
 *
 * \par Copyright
 * This software is Copyright (C), 2012-2016, MakeBlock. Use is subject to license \n
 * conditions. The main licensing options available are GPL V2 or Commercial: \n
 *
 * \par Open Source Licensing GPL V2
 * This is the appropriate option if you want to share the source code of your \n
 * application with everyone you distribute it to, and you also want to give them \n
 * the right to share who uses it. If you wish to use this software under Open \n
 * Source Licensing, you must contribute all your source code to the open source \n
 * community in accordance with the GPL Version 2 when your application is \n
 * distributed. See http://www.gnu.org/copyleft/gpl.html
 *
 * \par Description
 * This file is Hardware adaptation layer between BaseBoard board
 * and all MakeBlock drives
 *
 * \par History:
 * <pre>
 * `<Author>`         `<Time>`        `<Version>`        `<Descr>`
 * Mark Yan         2015/09/01         1.0.0            Rebuild the old lib.
 * Scott wang       2016/09/18         1.0.1            Add the PORT[15].
 * Scott            2016/09/20         1.0.2            Add the PORT[16].
 * </pre>
 */
#ifndef MeBaseBoard_H
#define MeBaseBoard_H

#include <Arduino.h>
#include "MeConfig.h"

/* Supported Modules drive needs to be added here */
#include "Me7SegmentDisplay.h"
#include "MeUltrasonicSensor.h"
#include "MeDCMotor.h"
#include "MeRGBLed.h"
#include "Me4Button.h"
#include "MePotentiometer.h"
#include "MeJoystick.h"
#include "MePIRMotionSensor.h"
#include "MeShutter.h"
#include "MeLineFollower.h"
#include "MeSoundSensor.h"
#include "MeLimitSwitch.h"
#include "MeLightSensor.h"
#include "MeSerial.h"
#include "MeBluetooth.h"
#include "MeWifi.h"
#include "MeTemperature.h"
#include "MeGyro.h"
#include "MeInfraredReceiver.h"
#include "MeCompass.h"
#include "MeUSBHost.h"
#include "MeTouchSensor.h"
#include "MeStepper.h"
#include "MeEncoderMotor.h"
#include "MeEncoderNew.h"
#include "MeBuzzer.h"
#include "MeLEDMatrix.h"
#include "MeHumitureSensor.h"
#include "MeFlameSensor.h"
#include "MeGasSensor.h"

/*********************  base Board GPIO Map *********************************/
MePort_Sig mePort[17] =
{
  {   NC,  NC }, { 11, A8 }, { 13, A11 }, { A10, A9 }, {  1,  0 },
  { MISO, SCK }, { A0, A1 }, { A2,  A3 }, {  A4, A5 }, {  6,  7 },
  {    5,   4 }, { NC, NC }, { NC,  NC }, {  NC, NC }, { NC, NC },
  { NC, NC },{ NC, NC },
};

#define buzzerOn()  DDRE |= 0x04,PORTE |= B00000100
#define buzzerOff() DDRE |= 0x04,PORTE &= B11111011

#endif // MeBaseBoard_H

